/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class StringUtil {
    private static final Pattern FORMATTING_CODE_PATTERN = Pattern.compile("(?i)\\u00A7[0-9A-FK-OR]");

    public static String toTitleCase(@NotNull String str) {
        StringBuilder buffer = new StringBuilder(str.length());
        boolean capitaliseNext = true;
        for (char ch : str.toCharArray()) {
            if (Character.isWhitespace(ch) || ch == '_') {
                buffer.append(' ');
                capitaliseNext = true;
                continue;
            }
            if (capitaliseNext) {
                buffer.append(Character.toUpperCase(ch));
                capitaliseNext = false;
                continue;
            }
            buffer.append(Character.toLowerCase(ch));
        }
        return buffer.toString();
    }

    public static boolean isSnakeCase(String str) {
        return str != null && !str.isEmpty() && Pattern.matches("[a-z0-9_]", str);
    }

    public static String toSentenceCase(String string) {
        return Character.toTitleCase(string.charAt(0)) + string.substring(1).toLowerCase();
    }

    public static String removeFormatting(String string) {
        return FORMATTING_CODE_PATTERN.matcher(string).replaceAll("");
    }
}

