/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import com.mojang.blaze3d.font.GlyphInfo;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.FormattedCharSink;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.extensions.common.IClientMobEffectExtensions;
import net.tslat.aoa3.common.registration.AoAConfigs;
import org.joml.Matrix4f;

public final class RenderUtil {
    public static void renderTexture(PoseStack matrix, float x, float y, float u, float v, float width, float height) {
        RenderUtil.renderCustomSizedTexture(matrix, x, y, u, v, width, height, width, height);
    }

    public static void renderSprite(PoseStack poseStack, ResourceLocation sprite, int x, int y, float renderWidth, float renderHeight) {
        TextureAtlasSprite atlasSprite = RenderUtil.getSprite(sprite);
        float uWidth = atlasSprite.getU1() - atlasSprite.getU0();
        float vHeight = atlasSprite.getV1() - atlasSprite.getV0();
        RenderUtil.prepRenderTexture(atlasSprite.atlasLocation());
        RenderUtil.renderScaledCustomSizedTexture(poseStack, x, y, atlasSprite.getU0(), atlasSprite.getV0(), uWidth, vHeight, renderWidth, renderHeight, 1.0f, 1.0f);
    }

    public static void renderCustomSizedTexture(PoseStack matrix, float x, float y, float u, float v, float uWidth, float vHeight, float textureWidth, float textureHeight) {
        RenderUtil.renderScaledCustomSizedTexture(matrix, x, y, u, v, uWidth, vHeight, uWidth, vHeight, textureWidth, textureHeight);
    }

    public static void renderCustomSizedSprite(PoseStack poseStack, ResourceLocation sprite, int x, int y, float renderWidth, float renderHeight) {
        TextureAtlasSprite atlasSprite = RenderUtil.getSprite(sprite);
        float uWidth = atlasSprite.getU1() - atlasSprite.getU0();
        float vHeight = atlasSprite.getV1() - atlasSprite.getV0();
        RenderUtil.prepRenderTexture(atlasSprite.atlasLocation());
        RenderUtil.renderScaledCustomSizedTexture(poseStack, x, y, atlasSprite.getU0(), atlasSprite.getV0(), uWidth, vHeight, renderWidth, renderHeight, 1.0f, 1.0f);
    }

    public static void renderScaledCustomSizedTexture(PoseStack matrixStack, float x, float y, float u, float v, float uWidth, float vHeight, float renderWidth, float renderHeight, float textureWidth, float textureHeight) {
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        Matrix4f pose = matrixStack.last().pose();
        float widthRatio = 1.0f / textureWidth;
        float heightRatio = 1.0f / textureHeight;
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        buffer.addVertex(pose, x, y + renderHeight, 0.0f).setUv(u * widthRatio, (v + vHeight) * heightRatio);
        buffer.addVertex(pose, x + renderWidth, y + renderHeight, 0.0f).setUv((u + uWidth) * widthRatio, (v + vHeight) * heightRatio);
        buffer.addVertex(pose, x + renderWidth, y, 0.0f).setUv((u + uWidth) * widthRatio, v * heightRatio);
        buffer.addVertex(pose, x, y, 0.0f).setUv(u * widthRatio, v * heightRatio);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
    }

    public static void renderFullscreenTexture(GuiGraphics guiGraphics, ResourceLocation texture) {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderUtil.resetShaderColour();
        guiGraphics.blit(texture, 0, 0, -90, 0.0f, 0.0f, guiGraphics.guiWidth(), guiGraphics.guiHeight(), guiGraphics.guiWidth(), guiGraphics.guiHeight());
        RenderSystem.depthMask((boolean)true);
        RenderUtil.resetShaderColour();
    }

    public static void renderVerticalGradient(PoseStack poseStack, float x, float y, float width, float height, int topColour, int bottomColour) {
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        RenderUtil.renderVerticalGradient(poseStack, bufferSource.getBuffer(RenderType.gui()), x, y, width, height, topColour, bottomColour);
        bufferSource.endBatch(RenderType.gui());
    }

    public static void renderVerticalGradient(PoseStack poseStack, VertexConsumer buffer, float x, float y, float width, float height, int topColour, int bottomColour) {
        float alphaTop = (float)(topColour >> 24 & 0xFF) / 255.0f;
        float redTop = (float)(topColour >> 16 & 0xFF) / 255.0f;
        float greenTop = (float)(topColour >> 8 & 0xFF) / 255.0f;
        float blueTop = (float)(topColour & 0xFF) / 255.0f;
        float alphaBottom = (float)(bottomColour >> 24 & 0xFF) / 255.0f;
        float redBottom = (float)(bottomColour >> 16 & 0xFF) / 255.0f;
        float greenBottom = (float)(bottomColour >> 8 & 0xFF) / 255.0f;
        float blueBottom = (float)(bottomColour & 0xFF) / 255.0f;
        Matrix4f pose = poseStack.last().pose();
        buffer.addVertex(pose, x + width, y, 0.0f).setColor(redTop, greenTop, blueTop, alphaTop);
        buffer.addVertex(pose, x, y, 0.0f).setColor(redTop, greenTop, blueTop, alphaTop);
        buffer.addVertex(pose, x, y + height, 0.0f).setColor(redBottom, greenBottom, blueBottom, alphaBottom);
        buffer.addVertex(pose, x + width, y + height, 0.0f).setColor(redBottom, greenBottom, blueBottom, alphaBottom);
    }

    public static void drawRectangle(PoseStack poseStack, float x, float y, float width, float height, int colour) {
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        RenderUtil.drawRectangle(poseStack, bufferSource.getBuffer(RenderType.gui()), x, y, width, height, colour);
        bufferSource.endBatch(RenderType.gui());
    }

    public static void drawRectangle(PoseStack poseStack, VertexConsumer buffer, float x, float y, float width, float height, int colour) {
        float alpha = (float)(colour >> 24 & 0xFF) / 255.0f;
        float red = (float)(colour >> 16 & 0xFF) / 255.0f;
        float green = (float)(colour >> 8 & 0xFF) / 255.0f;
        float blue = (float)(colour & 0xFF) / 255.0f;
        Matrix4f pose = poseStack.last().pose();
        buffer.addVertex(pose, x, y + height, 0.0f).setColor(red, green, blue, alpha);
        buffer.addVertex(pose, x + width, y + height, 0.0f).setColor(red, green, blue, alpha);
        buffer.addVertex(pose, x + width, y, 0.0f).setColor(red, green, blue, alpha);
        buffer.addVertex(pose, x, y, 0.0f).setColor(red, green, blue, alpha);
    }

    public static void renderText(PoseStack poseStack, Component text, float x, float y, int colour, TextRenderType renderType) {
        RenderUtil.renderText(poseStack, Minecraft.getInstance().font, text.getVisualOrderText(), x, y, colour, 0, renderType, 0xF000F0, Minecraft.getInstance().renderBuffers().bufferSource());
    }

    public static void renderText(PoseStack poseStack, Font fontRenderer, FormattedCharSequence text, float x, float y, int colour, int outlineColour, TextRenderType renderType, int packedLight, MultiBufferSource.BufferSource bufferSource) {
        renderType.render(fontRenderer, poseStack.last().pose(), text, x, y, colour, outlineColour, packedLight, bufferSource);
        bufferSource.endLastBatch();
    }

    public static void renderCenteredScaledText(PoseStack poseStack, Component text, float x, float y, float scale, int colour, TextRenderType renderType) {
        RenderUtil.renderCenteredScaledText(poseStack, Minecraft.getInstance().font, text, x, y, scale, colour, 0, renderType, 0xF000F0, Minecraft.getInstance().renderBuffers().bufferSource());
    }

    public static void renderCenteredScaledText(PoseStack poseStack, Font fontRenderer, Component text, float x, float y, float scale, int colour, int outlineColour, TextRenderType renderType, int packedLight, MultiBufferSource.BufferSource bufferSource) {
        poseStack.pushPose();
        poseStack.scale(scale, scale, 1.0f);
        float renderX = (x - (float)fontRenderer.width((FormattedText)text) * scale / 2.0f) / scale;
        float renderY = y / scale;
        RenderUtil.renderText(poseStack, fontRenderer, text.getVisualOrderText(), renderX, renderY, colour, outlineColour, renderType, packedLight, bufferSource);
        poseStack.popPose();
    }

    public static void renderScaledText(PoseStack poseStack, Component text, float x, float y, float scale, int colour, TextRenderType renderType) {
        RenderUtil.renderScaledText(poseStack, Minecraft.getInstance().font, text, x, y, scale, colour, 0, renderType, 0xF000F0, Minecraft.getInstance().renderBuffers().bufferSource());
    }

    public static void renderScaledText(PoseStack poseStack, Font fontRenderer, Component text, float x, float y, float scale, int colour, int outlineColour, TextRenderType renderType, int packedLight, MultiBufferSource.BufferSource bufferSource) {
        poseStack.pushPose();
        poseStack.scale(scale, scale, 1.0f);
        RenderUtil.renderText(poseStack, fontRenderer, text.getVisualOrderText(), x / scale, y / scale, colour, outlineColour, renderType, packedLight, bufferSource);
        poseStack.popPose();
    }

    public static void renderWrappedText(PoseStack poseStack, Component text, float x, float y, int maxLength, int colour, TextRenderType renderType) {
        RenderUtil.renderWrappedText(poseStack, Minecraft.getInstance().font, text, x, y, maxLength, colour, 0, renderType, 0xF000F0, Minecraft.getInstance().renderBuffers().bufferSource());
    }

    public static void renderWrappedText(PoseStack poseStack, Font fontRenderer, Component text, float x, float y, int maxLength, int colour, int outlineColour, TextRenderType renderType, int packedLight, MultiBufferSource.BufferSource bufferSource) {
        for (FormattedCharSequence line : fontRenderer.split((FormattedText)text, maxLength)) {
            RenderUtil.renderText(poseStack, fontRenderer, line, x, y, colour, outlineColour, renderType, packedLight, bufferSource);
            bufferSource.endLastBatch();
            Objects.requireNonNull(fontRenderer);
            y += 9.0f;
        }
    }

    public static void renderItemInGui(PoseStack matrix, Minecraft mc, ItemStack stack, int x, int y) {
        boolean useItemLight;
        BakedModel model = mc.getItemRenderer().getModel(stack, null, null, 0);
        matrix.pushPose();
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
        mc.getTextureManager().getTexture(InventoryMenu.BLOCK_ATLAS).setFilter(false, false);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrix.translate((double)x, (double)y, 100.0);
        matrix.translate(8.0f, 8.0f, 0.0f);
        matrix.scale(1.0f, -1.0f, 1.0f);
        matrix.scale(16.0f, 16.0f, 16.0f);
        MultiBufferSource.BufferSource renderTypeBuffer = Minecraft.getInstance().renderBuffers().bufferSource();
        boolean bl = useItemLight = !model.usesBlockLight();
        if (useItemLight) {
            Lighting.setupForFlatItems();
        }
        mc.getItemRenderer().render(stack, ItemDisplayContext.GUI, false, matrix, (MultiBufferSource)renderTypeBuffer, 0xF000F0, OverlayTexture.NO_OVERLAY, model);
        renderTypeBuffer.endBatch();
        RenderSystem.enableDepthTest();
        if (useItemLight) {
            Lighting.setupFor3DItems();
        }
        matrix.popPose();
    }

    public static int getPotionGuiRenderOffset() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.player.getActiveEffects().isEmpty() || ((Boolean)AoAConfigs.CLIENT.disableHudPotionOffset.get()).booleanValue()) {
            return 0;
        }
        int effectRenderYOffset = 0;
        for (MobEffectInstance effect : mc.player.getActiveEffects()) {
            if (effect.getDuration() <= 0 || !IClientMobEffectExtensions.DEFAULT.isVisibleInGui(effect) || !effect.isVisible()) continue;
            if (!((MobEffect)effect.getEffect().value()).isBeneficial()) {
                effectRenderYOffset = 50;
                break;
            }
            effectRenderYOffset = 25;
        }
        return effectRenderYOffset;
    }

    public static void prepSpriteRender(ResourceLocation sprite) {
        RenderUtil.prepRenderTexture(RenderUtil.getSprite(sprite).atlasLocation());
    }

    public static TextureAtlasSprite getSprite(ResourceLocation path) {
        return Minecraft.getInstance().getGuiSprites().getSprite(path);
    }

    public static void prepRenderTexture(ResourceLocation texture) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderUtil.setRenderingTexture(texture);
    }

    public static void setRenderingTexture(ResourceLocation texture) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
    }

    public static void resetShaderColour() {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void setDefaultAlphaBlend() {
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }

    public static int selectVForWidgetState(AbstractWidget widget, int disabledV, int activeV, int focussedV) {
        return widget.isActive() ? (widget.isHoveredOrFocused() ? focussedV : activeV) : disabledV;
    }

    public static interface TextRenderType {
        public static final TextRenderType NORMAL = (fontRenderer, pose, text, x, y, colour, outlineColour, packedLight, bufferSource) -> fontRenderer.drawInBatch(text, x, y, colour, false, pose, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, outlineColour, packedLight);
        public static final TextRenderType DROP_SHADOW = (fontRenderer, pose, text, x, y, colour, outlineColour, packedLight, bufferSource) -> fontRenderer.drawInBatch(text, x, y, colour, true, pose, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, outlineColour, packedLight);
        public static final TextRenderType TRANSLUCENT = (fontRenderer, pose, text, x, y, colour, outlineColour, packedLight, bufferSource) -> fontRenderer.drawInBatch(text, x, y, colour, false, pose, (MultiBufferSource)bufferSource, Font.DisplayMode.SEE_THROUGH, outlineColour, packedLight);
        public static final TextRenderType GLOWING = (fontRenderer, pose, text, x, y, colour, outlineColour, packedLight, bufferSource) -> fontRenderer.drawInBatch8xOutline(text, x, y, colour, outlineColour, pose, (MultiBufferSource)bufferSource, packedLight);
        public static final TextRenderType OUTLINED = (fontRenderer, pose, text, x, y, colour, outlineColour, packedLight, bufferSource) -> {
            int borderColour = (outlineColour & 0xFC000000) == 0 ? outlineColour | 0xFF000000 : outlineColour;
            Font font = fontRenderer;
            Objects.requireNonNull(font);
            Font.StringRenderOutput outlineOutput = new Font.StringRenderOutput(font, (MultiBufferSource)bufferSource, 0.0f, 0.0f, borderColour, false, pose, Font.DisplayMode.NORMAL, packedLight);
            for (float deltaX = -1.0f; deltaX <= 1.0f; deltaX += 1.0f) {
                for (float deltaY = -1.0f; deltaY <= 1.0f; deltaY += 1.0f) {
                    if (!(deltaX == 0.0f ^ deltaY == 0.0f)) continue;
                    float[] newX = new float[]{x};
                    float offsetX = deltaX;
                    float offsetY = deltaY;
                    text.accept((currentPosition, style, codePoint) -> {
                        GlyphInfo glyphInfo = fontRenderer.getFontSet(style.getFont()).getGlyphInfo(codePoint, fontRenderer.filterFishyGlyphs);
                        outlineOutput.x = newX[0] + offsetX * glyphInfo.getShadowOffset() * 0.6f;
                        outlineOutput.y = y + offsetY * glyphInfo.getShadowOffset() * 0.6f;
                        newX[0] = newX[0] + glyphInfo.getAdvance(style.isBold());
                        return outlineOutput.accept(currentPosition, style.withColor(borderColour), codePoint);
                    });
                }
            }
            Font font2 = fontRenderer;
            Objects.requireNonNull(font2);
            Font.StringRenderOutput output = new Font.StringRenderOutput(font2, (MultiBufferSource)bufferSource, x, y, (colour & 0xFC000000) == 0 ? colour | 0xFF000000 : colour, false, pose, Font.DisplayMode.POLYGON_OFFSET, packedLight);
            text.accept((FormattedCharSink)output);
            output.finish(0, x);
        };

        public void render(Font var1, Matrix4f var2, FormattedCharSequence var3, float var4, float var5, int var6, int var7, int var8, MultiBufferSource.BufferSource var9);
    }
}

