/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import java.time.LocalDate;
import java.time.Month;

public final class HolidayUtil {
    public static Holiday getCurrentHoliday() {
        LocalDate date = LocalDate.now();
        if (date.isEqual(HolidayUtil.forDay(Month.APRIL, 1))) {
            return Holiday.APRIL_FOOLS;
        }
        if (date.isEqual(HolidayUtil.forDay(Month.DECEMBER, 25))) {
            return Holiday.CHRISTMAS;
        }
        if (date.isEqual(HolidayUtil.forDay(Month.OCTOBER, 31))) {
            return Holiday.HALLOWEEN;
        }
        if (date.isEqual(HolidayUtil.forDay(Month.JUNE, 24))) {
            return Holiday.ANNIVERSARY;
        }
        return Holiday.NONE;
    }

    public static boolean isChristmas() {
        return HolidayUtil.getCurrentHoliday() == Holiday.CHRISTMAS;
    }

    public static boolean isHalloween() {
        return HolidayUtil.getCurrentHoliday() == Holiday.HALLOWEEN;
    }

    public static boolean isAprilFools() {
        return HolidayUtil.getCurrentHoliday() == Holiday.APRIL_FOOLS;
    }

    public static boolean isAnniversary() {
        return HolidayUtil.getCurrentHoliday() == Holiday.ANNIVERSARY;
    }

    private static LocalDate forDay(Month month, int number) {
        return LocalDate.of(LocalDate.now().getYear(), month, number);
    }

    public static enum Holiday {
        NONE,
        CHRISTMAS,
        HALLOWEEN,
        APRIL_FOOLS,
        ANNIVERSARY;

    }
}

