/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.common.registration.item.AoACreativeModeTabs;
import net.tslat.aoa3.library.object.MutableSupplier;
import org.jetbrains.annotations.Nullable;

public final class FluidUtil {

    public record RegisteredFluidHolder(DeferredHolder<Item, BucketItem> bucket, DeferredHolder<Block, LiquidBlock> fluidBlock, DeferredHolder<Fluid, BaseFlowingFluid.Source> fluid) {
        public BucketItem getBucket() {
            return (BucketItem)this.bucket.get();
        }

        public LiquidBlock getBlock() {
            return (LiquidBlock)this.fluidBlock.get();
        }

        public BaseFlowingFluid.Source getFluid() {
            return (BaseFlowingFluid.Source)this.fluid.get();
        }
    }

    public static class Builder {
        private final String id;
        private final Supplier<FluidType> fluidType;
        private final MutableSupplier<BaseFlowingFluid.Source> sourceFluid = new MutableSupplier(null);
        private final MutableSupplier<BaseFlowingFluid.Flowing> flowingFluid = new MutableSupplier(null);
        private BiFunction<MutableSupplier<BaseFlowingFluid.Flowing>, BlockBehaviour.Properties, Supplier<LiquidBlock>> blockCreationFunction = (flowingFluid, blockProperties) -> () -> new LiquidBlock((FlowingFluid)flowingFluid.get(), blockProperties);
        private BiFunction<MutableSupplier<BaseFlowingFluid.Source>, Item.Properties, Supplier<BucketItem>> bucketCreationFunction = (sourceFluid, itemProperties) -> () -> new BucketItem((Fluid)sourceFluid.get(), itemProperties);
        private Function<BaseFlowingFluid.Properties, Supplier<BaseFlowingFluid.Source>> sourceFluidFunction = properties -> () -> new BaseFlowingFluid.Source(properties);
        private Function<BaseFlowingFluid.Properties, Supplier<BaseFlowingFluid.Flowing>> flowingFluidFunction = properties -> () -> new BaseFlowingFluid.Flowing(properties);
        private BaseFlowingFluid.Properties fluidProperties;
        private int tickRate = 5;
        private ToIntFunction<BlockState> lightFunction = state -> 0;
        private String localeKey;

        public Builder(String id, Supplier<FluidType> fluidType) {
            this.id = id;
            this.localeKey = "block.aoa3." + id;
            this.fluidType = fluidType;
        }

        public Builder localeKey(String key) {
            this.localeKey = key;
            return this;
        }

        public Builder luminosity(int lightLevel) {
            return this.luminosity(state -> lightLevel);
        }

        public Builder luminosity(ToIntFunction<BlockState> lightFunction) {
            this.lightFunction = lightFunction;
            return this;
        }

        public Builder tickRate(int tickRate) {
            this.tickRate = tickRate;
            return this;
        }

        public Builder noBucket() {
            this.bucketCreationFunction = null;
            return this;
        }

        public Builder noBlock() {
            this.blockCreationFunction = null;
            return this;
        }

        public Builder customBlock(BiFunction<MutableSupplier<BaseFlowingFluid.Flowing>, BlockBehaviour.Properties, Supplier<LiquidBlock>> blockCreationFunction) {
            this.blockCreationFunction = blockCreationFunction;
            return this;
        }

        public Builder customBucket(BiFunction<MutableSupplier<BaseFlowingFluid.Source>, Item.Properties, Supplier<BucketItem>> bucketCreationFunction) {
            this.bucketCreationFunction = bucketCreationFunction;
            return this;
        }

        public Builder customSourceFluid(Function<BaseFlowingFluid.Properties, Supplier<BaseFlowingFluid.Source>> sourceFluidCreationFunction) {
            this.sourceFluidFunction = sourceFluidCreationFunction;
            return this;
        }

        public Builder customFlowingFluid(Function<BaseFlowingFluid.Properties, Supplier<BaseFlowingFluid.Flowing>> flowingFluidCreationFunction) {
            this.flowingFluidFunction = flowingFluidCreationFunction;
            return this;
        }

        public RegisteredFluidHolder defaultRegisterAll() {
            return this.registerAll(AoARegistries.ITEMS.deferredRegister(), AoARegistries.BLOCKS.deferredRegister(), AoARegistries.FLUIDS.deferredRegister());
        }

        public RegisteredFluidHolder registerAll(DeferredRegister<Item> itemRegistry, DeferredRegister<Block> blockRegistry, DeferredRegister<Fluid> fluidRegistry) {
            DeferredHolder<Item, BucketItem> bucket = this.registerBucket(itemRegistry);
            DeferredHolder<Fluid, BaseFlowingFluid.Source> fluid = this.registerFluid(fluidRegistry);
            DeferredHolder<Block, LiquidBlock> fluidBlock = this.registerBlock(blockRegistry);
            return new RegisteredFluidHolder(bucket, fluidBlock, fluid);
        }

        @Nullable
        public DeferredHolder<Block, LiquidBlock> registerBlock(DeferredRegister<Block> blockRegistry) {
            if (this.blockCreationFunction == null) {
                return null;
            }
            this.makeFluidProperties();
            DeferredHolder block = blockRegistry.register(this.id, this.blockCreationFunction.apply(this.flowingFluid, BlockBehaviour.Properties.of().mapColor(MapColor.WATER).replaceable().noCollission().strength(100.0f).pushReaction(PushReaction.DESTROY).noLootTable().liquid().sound(SoundType.EMPTY).lightLevel(this.lightFunction)));
            this.fluidProperties.block((Supplier)block);
            AoABlocks.registeredLiquid((DeferredHolder<Block, ? extends LiquidBlock>)block);
            return block;
        }

        @Nullable
        public DeferredHolder<Item, BucketItem> registerBucket(DeferredRegister<Item> itemRegistry) {
            if (this.bucketCreationFunction == null) {
                return null;
            }
            this.makeFluidProperties();
            DeferredHolder bucket = itemRegistry.register(this.id + "_bucket", this.bucketCreationFunction.apply(this.sourceFluid, new Item.Properties().craftRemainder(Items.BUCKET).stacksTo(1)));
            this.fluidProperties.bucket((Supplier)bucket);
            AoACreativeModeTabs.setItemCreativeTabs((Supplier<? extends Item>)bucket, List.of(CreativeModeTabs.TOOLS_AND_UTILITIES));
            return bucket;
        }

        public DeferredHolder<Fluid, BaseFlowingFluid.Source> registerFluid(DeferredRegister<Fluid> fluidRegistry) {
            this.makeFluidProperties();
            DeferredHolder fluid = fluidRegistry.register(this.id, this.sourceFluidFunction.apply(this.fluidProperties));
            this.sourceFluid.update((Supplier<BaseFlowingFluid.Source>)fluid);
            this.flowingFluid.update((Supplier<BaseFlowingFluid.Flowing>)fluidRegistry.register(this.id + "_flowing", this.flowingFluidFunction.apply(this.fluidProperties)));
            return fluid;
        }

        private void makeFluidProperties() {
            if (this.fluidProperties == null) {
                this.fluidProperties = new BaseFlowingFluid.Properties(this.fluidType, this.sourceFluid, this.flowingFluid).tickRate(this.tickRate);
            }
        }
    }
}

