/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import java.util.function.Consumer;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import net.tslat.smartbrainlib.util.RandomUtil;
import org.jetbrains.annotations.Nullable;

public final class EntitySpawningUtil {
    @Nullable
    public static <T extends Entity> T spawnEntity(ServerLevel level, EntityType<T> entityType) {
        return (T)EntitySpawningUtil.spawnEntity(level, entityType, new Vec3(0.0, 0.0, 0.0), MobSpawnType.COMMAND, (T entity) -> {});
    }

    @Nullable
    public static <T extends Entity> T spawnEntity(ServerLevel level, EntityType<T> entityType, Vec3i position, MobSpawnType spawnReason) {
        return (T)EntitySpawningUtil.spawnEntity(level, entityType, Vec3.atBottomCenterOf((Vec3i)position), spawnReason, (T entity) -> {});
    }

    @Nullable
    public static <T extends Entity> T spawnEntity(ServerLevel level, EntityType<T> entityType, Vec3 position, MobSpawnType spawnReason) {
        return (T)EntitySpawningUtil.spawnEntity(level, entityType, position, spawnReason, (T entity) -> {});
    }

    @Nullable
    public static <T extends Entity> T spawnEntity(ServerLevel level, EntityType<T> entityType, Vec3i position, Consumer<T> entityModifications) {
        return (T)EntitySpawningUtil.spawnEntity(level, entityType, Vec3.atBottomCenterOf((Vec3i)position), MobSpawnType.COMMAND, entityModifications);
    }

    @Nullable
    public static <T extends Entity> T spawnEntity(ServerLevel level, EntityType<T> entityType, Vec3 position, Consumer<T> entityModifications) {
        return (T)EntitySpawningUtil.spawnEntity(level, entityType, position, MobSpawnType.COMMAND, entityModifications);
    }

    @Nullable
    public static <T extends Entity> T spawnEntity(ServerLevel level, EntityType<T> entityType, Vec3i position, MobSpawnType spawnReason, Consumer<T> entityModifications) {
        return (T)EntitySpawningUtil.spawnEntity(level, entityType, Vec3.atBottomCenterOf((Vec3i)position), spawnReason, entityModifications);
    }

    @Nullable
    public static <T extends Entity> T spawnEntity(ServerLevel level, EntityType<T> entityType, Vec3 position, MobSpawnType spawnReason, Consumer<T> entityModifications) {
        Entity entity = entityType.create((Level)level);
        if (entity == null) {
            return null;
        }
        return (T)EntitySpawningUtil.spawnEntity(level, entity, position, spawnReason, entityModifications);
    }

    public static <T extends Entity> T spawnEntity(ServerLevel level, T entity, Vec3 position, MobSpawnType spawnReason, Consumer<T> entityModifications) {
        entity.moveTo(position.x(), position.y(), position.z(), Mth.wrapDegrees((float)((float)RandomUtil.randomValueUpTo((double)360.0))), 0.0f);
        entityModifications.accept(entity);
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.yHeadRot = mob.getYRot();
            mob.yBodyRot = mob.getYRot();
            EventHooks.finalizeMobSpawn((Mob)mob, (ServerLevelAccessor)level, (DifficultyInstance)level.getCurrentDifficultyAt(entity.blockPosition()), (MobSpawnType)spawnReason, null);
            mob.playAmbientSound();
        }
        level.addFreshEntityWithPassengers(entity);
        return entity;
    }
}

