/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;

public final class EnchantmentUtil {
    public static boolean hasEnchantment(Level level, ItemStack stack, ResourceKey<Enchantment> enchantment) {
        return EnchantmentUtil.hasEnchantment(stack, EnchantmentUtil.toHolder(level, enchantment));
    }

    public static boolean hasEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return EnchantmentUtil.getEnchantmentLevel(stack, enchantment) > 0;
    }

    public static int getEnchantmentLevel(Level level, ItemStack stack, ResourceKey<Enchantment> enchantment) {
        return EnchantmentUtil.getEnchantmentLevel(stack, EnchantmentUtil.toHolder(level, enchantment));
    }

    public static int getEnchantmentLevel(ItemStack stack, Holder<Enchantment> enchantment) {
        return stack.getEnchantmentLevel(enchantment);
    }

    public static void removeEnchantment(Level level, ItemStack stack, ResourceKey<Enchantment> enchantment) {
        Holder<Enchantment> enchant = EnchantmentUtil.toHolder(level, enchantment);
        EnchantmentHelper.updateEnchantments((ItemStack)stack, enchants -> enchants.removeIf(arg_0 -> ((Holder)enchant).is(arg_0)));
    }

    public static void addEnchantment(Level level, ItemStack stack, ResourceKey<Enchantment> enchantment) {
        EnchantmentUtil.addEnchantment(level, stack, enchantment, 1);
    }

    public static void addEnchantment(Level level, ItemStack stack, ResourceKey<Enchantment> enchantment, int enchantLevel) {
        EnchantmentUtil.addEnchantment(level, stack, enchantment, enchantLevel, false);
    }

    public static void addEnchantment(Level level, ItemStack stack, ResourceKey<Enchantment> enchantment, int enchantLevel, boolean ignoreRestrictions) {
        stack.enchant(EnchantmentUtil.toHolder(level, enchantment), enchantLevel);
    }

    public static Holder<Enchantment> toHolder(Level level, ResourceLocation enchantment) {
        return EnchantmentUtil.toHolder(level, (ResourceKey<Enchantment>)ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)enchantment));
    }

    public static Holder<Enchantment> toHolder(Level level, ResourceKey<Enchantment> enchantment) {
        return level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(enchantment);
    }

    public static Component getFormattedName(Holder<Enchantment> enchantment) {
        return EnchantmentUtil.getFormattedName(enchantment, 1);
    }

    public static Component getFormattedName(Holder<Enchantment> enchantment, int level) {
        return Enchantment.getFullname(enchantment, (int)level);
    }
}

