/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;

public final class ColourUtil {
    public static final int WHITE = 0xFFFFFF;
    public static final int BLACK = 0;
    public static final int RED = 0xFF0000;
    public static final int GREEN = 65280;
    public static final int BLUE = 255;
    public static final int YELLOW = 0xFFFF00;
    public static final int CYAN = 65535;

    public static int RGB(int red, int green, int blue) {
        return red << 16 | green << 8 | blue;
    }

    public static int ARGB(int red, int green, int blue, int alpha) {
        return ColourUtil.makeARGB(ColourUtil.RGB(red, green, blue), alpha);
    }

    public static int RGB(float red, float green, float blue) {
        return (int)(red * 255.0f) << 16 | (int)(green * 255.0f) << 8 | (int)(blue * 255.0f);
    }

    public static int ARGB(float red, float green, float blue, float alpha) {
        return ColourUtil.makeARGB(ColourUtil.RGB(red, green, blue), (int)(alpha * 255.0f));
    }

    public static int RGB(double red, double green, double blue) {
        return (int)(red * 255.0) << 16 | (int)(green * 255.0) << 8 | (int)(blue * 255.0);
    }

    public static int ARGB(double red, double green, double blue, double alpha) {
        return ColourUtil.makeARGB(ColourUtil.RGB(red, green, blue), (int)(alpha * 255.0));
    }

    public static int makeARGB(int colour, int alpha) {
        return alpha << 24 | colour;
    }

    public static int getAlpha(int rgb) {
        return rgb >> 24 & 0xFF;
    }

    public static int getRed(int rgb) {
        return rgb >> 16 & 0xFF;
    }

    public static int getGreen(int rgb) {
        return rgb >> 8 & 0xFF;
    }

    public static int getBlue(int rgb) {
        return rgb & 0xFF;
    }

    public static int lerpColour(int fromColour, int toColour, float delta) {
        Colour from = new Colour(fromColour);
        Colour to = new Colour(toColour);
        return ColourUtil.ARGB(ColourUtil.lerpColourSegment(from.red, to.red, delta), ColourUtil.lerpColourSegment(from.green, to.green, delta), ColourUtil.lerpColourSegment(from.blue, to.blue, delta), ColourUtil.lerpAlpha(from.alpha, to.alpha, delta));
    }

    public static float lerpColourSegment(float from, float to, float delta) {
        return (float)Math.sqrt((1.0f - delta) * (from * from) + delta * to * to);
    }

    public static float lerpAlpha(float from, float to, float delta) {
        return (1.0f - delta) * from + delta * to;
    }

    public record Colour(float red, float green, float blue, float alpha) {
        public Colour(int red, int green, int blue) {
            this((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, 1.0f);
        }

        public Colour(int rgb) {
            this((float)ColourUtil.getRed(rgb) / 255.0f, (float)ColourUtil.getGreen(rgb) / 255.0f, (float)ColourUtil.getBlue(rgb) / 255.0f, (float)ColourUtil.getAlpha(rgb) / 255.0f);
        }

        public String rgbHex() {
            return Integer.toHexString((int)(this.red * 255.0f)) + Integer.toHexString((int)(this.green * 255.0f)) + Integer.toHexString((int)(this.blue * 255.0f));
        }

        public String argbHex() {
            return Integer.toHexString((int)(this.alpha * 255.0f)) + Integer.toHexString((int)(this.red * 255.0f)) + Integer.toHexString((int)(this.green * 255.0f)) + Integer.toHexString((int)(this.blue * 255.0f));
        }

        public int rgbInt() {
            return ColourUtil.RGB(this.red, this.green, this.blue);
        }

        public int argbInt() {
            return ColourUtil.ARGB(this.red, this.green, this.blue, this.alpha);
        }

        public Colour multiply(float red, float green, float blue, float alpha) {
            return new Colour(Mth.clamp((float)(this.red * red), (float)0.0f, (float)1.0f), Mth.clamp((float)(this.green * green), (float)0.0f, (float)1.0f), Mth.clamp((float)(this.blue * blue), (float)0.0f, (float)1.0f), Mth.clamp((float)(this.alpha * alpha), (float)0.0f, (float)1.0f));
        }

        public void toNetwork(FriendlyByteBuf buffer) {
            buffer.writeFloat(this.red);
            buffer.writeFloat(this.green);
            buffer.writeFloat(this.blue);
            buffer.writeFloat(this.alpha);
        }

        public static Colour fromNetwork(FriendlyByteBuf buffer) {
            return new Colour(buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
        }
    }
}

