/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentTable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tslat.aoa3.util.RegistryUtil;
import org.jetbrains.annotations.Nullable;

public final class BlockUtil {
    public static final float UNBREAKABLE_HARDNESS = -1.0f;
    public static final float UNBREAKABLE_RESISTANCE = 1.0E9f;

    public static Vec3 posToVec(BlockPos pos) {
        return new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
    }

    public static VoxelShape pixelBasedCube(int minPixelX, int minPixelY, int minPixelZ, int maxPixelX, int maxPixelY, int maxPixelZ) {
        return Shapes.create((AABB)new AABB((double)minPixelX / 16.0, (double)minPixelY / 16.0, (double)minPixelZ / 16.0, (double)maxPixelX / 16.0, (double)maxPixelY / 16.0, (double)maxPixelZ / 16.0));
    }

    public static boolean canPlayerHarvest(BlockState state, Player player, LevelAccessor world, BlockPos pos) {
        if (!state.requiresCorrectToolForDrops()) {
            return true;
        }
        return player.getMainHandItem().isCorrectToolForDrops(state);
    }

    public static class SpawnerBuilder {
        private short initialSpawnDelay = (short)20;
        private short minSpawnDelay = (short)200;
        private short maxSpawnDelay = (short)800;
        private short spawnsPerGroup = (short)4;
        private short maxNearbyEntities = (short)6;
        private short requiredPlayerRange = (short)16;
        private short spawnRange = (short)4;
        private SpawnData nextSpawn = null;
        private final SimpleWeightedRandomList.Builder<SpawnData> mobs = SimpleWeightedRandomList.builder();

        public SpawnerBuilder initialSpawnDelay(int ticks) {
            this.initialSpawnDelay = (short)ticks;
            return this;
        }

        public SpawnerBuilder minSpawnDelay(int ticks) {
            this.minSpawnDelay = (short)ticks;
            return this;
        }

        public SpawnerBuilder maxSpawnDelay(int ticks) {
            this.maxSpawnDelay = (short)ticks;
            return this;
        }

        public SpawnerBuilder spawnsPerGroup(int amount) {
            this.spawnsPerGroup = (short)amount;
            return this;
        }

        public SpawnerBuilder maxNearbyEntities(int amount) {
            this.maxNearbyEntities = (short)amount;
            return this;
        }

        public SpawnerBuilder whenPlayerWithin(int distance) {
            this.requiredPlayerRange = (short)distance;
            return this;
        }

        public SpawnerBuilder spawnWithinXBlocks(int distance) {
            this.spawnRange = (short)distance;
            return this;
        }

        public SpawnerBuilder withSpawns(EntityType<?> ... entities) {
            for (EntityType<?> entity : entities) {
                this.withSpawn(1, entity);
            }
            return this;
        }

        public SpawnerBuilder withSpawns(Holder<EntityType<?>> ... entities) {
            for (Holder<EntityType<?>> registryEntry : entities) {
                this.withSpawn(1, (EntityType)registryEntry.value());
            }
            return this;
        }

        public SpawnerBuilder withSpawn(int weight, EntityType<?> entity) {
            return this.withSpawn(weight, entity, null);
        }

        public SpawnerBuilder withSpawn(int weight, EntityType<?> entity, @Nullable SpawnData.CustomSpawnRules spawnRules) {
            CompoundTag tag = new CompoundTag();
            tag.putString("id", RegistryUtil.getId(entity).toString());
            return this.withSpawn(weight, tag, Optional.ofNullable(spawnRules), Optional.empty());
        }

        public SpawnerBuilder withSpawn(int weight, EntityType<?> entity, @Nullable SpawnData.CustomSpawnRules spawnRules, @Nullable EquipmentTable equipmentInfo) {
            CompoundTag tag = new CompoundTag();
            tag.putString("id", RegistryUtil.getId(entity).toString());
            return this.withSpawn(weight, tag, Optional.ofNullable(spawnRules), Optional.ofNullable(equipmentInfo));
        }

        public SpawnerBuilder withSpawn(int weight, CompoundTag nbt, Optional<SpawnData.CustomSpawnRules> spawnRules, Optional<EquipmentTable> equipmentInfo) {
            if (this.nextSpawn == null) {
                this.nextSpawn = new SpawnData(nbt, spawnRules, equipmentInfo);
                return this;
            }
            this.mobs.add((Object)new SpawnData(nbt, spawnRules, equipmentInfo), weight);
            return this;
        }

        public CompoundTag build() {
            CompoundTag nbt = new CompoundTag();
            if (this.nextSpawn == null) {
                throw new IllegalStateException("Attempted to create spawner data with no mobs listed.");
            }
            nbt.putShort("Delay", this.initialSpawnDelay);
            nbt.putShort("MinSpawnDelay", this.minSpawnDelay);
            nbt.putShort("MaxSpawnDelay", this.maxSpawnDelay);
            nbt.putShort("SpawnCount", this.spawnsPerGroup);
            nbt.putShort("MaxNearbyEntities", this.maxNearbyEntities);
            nbt.putShort("RequiredPlayerRange", this.requiredPlayerRange);
            nbt.putShort("SpawnRange", this.spawnRange);
            nbt.put("SpawnData", (Tag)SpawnData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.nextSpawn).result().orElseThrow(() -> new IllegalStateException("Invalid SpawnData")));
            nbt.put("SpawnPotentials", (Tag)SpawnData.LIST_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.mobs.build()).result().orElseThrow());
            return nbt;
        }
    }
}

