/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.scheduling.sync;

import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.tslat.aoa3.event.GlobalEvents;
import net.tslat.aoa3.scheduling.AoAScheduler;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.effectslib.api.util.EffectBuilder;

public class UltimatumStaffTask
implements Runnable {
    private final int startingTick = GlobalEvents.tick;
    private final LivingEntity shooter;
    private final LivingEntity target;
    private final BlockPos shooterPos;
    private final BlockPos targetPos;
    private final float shooterStartHealth;
    private final float targetStartHealth;
    private boolean targetTurn = true;

    public UltimatumStaffTask(LivingEntity shooter, LivingEntity target) {
        this.shooter = shooter;
        this.target = target;
        this.shooterPos = shooter.blockPosition();
        this.targetPos = target.blockPosition();
        this.shooterStartHealth = shooter.getHealth();
        this.targetStartHealth = target.getHealth();
        target.setDeltaMovement(0.0, 0.0, 0.0);
        shooter.setDeltaMovement(0.0, 0.0, 0.0);
        EntityUtil.removePotions(target, MobEffects.REGENERATION);
        EntityUtil.removePotions(shooter, MobEffects.REGENERATION);
        EntityUtil.applyPotions(Arrays.asList(target, shooter), new EffectBuilder(MobEffects.MOVEMENT_SLOWDOWN, 210).level(100).hideParticles(), new EffectBuilder(MobEffects.WEAKNESS, 210).level(50).hideParticles(), new EffectBuilder(MobEffects.DAMAGE_RESISTANCE, 210).level(5).hideParticles(), new EffectBuilder(MobEffects.NIGHT_VISION, 510).hideParticles(), new EffectBuilder(MobEffects.BLINDNESS, 210).hideParticles(), new EffectBuilder(MobEffects.LEVITATION, 210).level(-1).hideParticles());
    }

    @Override
    public void run() {
        if (this.shooter == null || this.target == null || this.shooter.level().isClientSide || !this.shooter.blockPosition().equals((Object)this.shooterPos) || !this.target.blockPosition().equals((Object)this.targetPos)) {
            this.resetStates();
            return;
        }
        float healthPercent = 1.0f - (float)(GlobalEvents.tick - this.startingTick) / 200.0f;
        float targetPostHealth = this.targetStartHealth * healthPercent;
        float shooterPostHealth = this.shooterStartHealth * healthPercent;
        if (this.targetTurn) {
            if (this.target.getHealth() == 0.0f) {
                this.resetStates();
                return;
            }
            if (targetPostHealth <= 0.0f) {
                this.resetStates();
                DamageUtil.doRecoilAttack((Entity)this.target, this.target.getHealth() - targetPostHealth);
                this.target.setDeltaMovement(0.0, 0.0, 0.0);
                LivingEntity livingEntity = this.shooter;
                if (livingEntity instanceof Player) {
                    Player pl = (Player)livingEntity;
                    this.target.setLastHurtByPlayer(pl);
                } else {
                    this.target.setLastHurtByMob(this.shooter);
                }
            } else {
                this.target.setHealth(targetPostHealth);
            }
            ((ServerLevel)this.shooter.level()).sendParticles((ParticleOptions)ParticleTypes.DAMAGE_INDICATOR, this.target.getX(), this.target.getY() + (double)this.target.getBbHeight(), this.target.getZ(), (int)Math.ceil(10.0f * healthPercent), 0.0, 0.0, 0.0, 0.0);
        } else if (!(this.shooter instanceof Player) || !((Player)this.shooter).isCreative()) {
            if (shooterPostHealth <= 0.0f) {
                this.resetStates();
                DamageUtil.doRecoilAttack((Entity)this.shooter, this.shooter.getHealth() - shooterPostHealth);
            } else {
                this.shooter.setHealth(shooterPostHealth);
            }
            ((ServerLevel)this.shooter.level()).sendParticles((ParticleOptions)ParticleTypes.DAMAGE_INDICATOR, this.shooter.getX(), this.shooter.getY() + (double)this.shooter.getBbHeight(), this.shooter.getZ(), (int)Math.ceil(10.0f * healthPercent), 0.0, 0.0, 0.0, 0.0);
        }
        this.targetTurn = !this.targetTurn;
        AoAScheduler.scheduleSyncronisedTask(this, 1);
    }

    private void resetStates() {
        if (this.target != null && this.target.getHealth() > 0.0f) {
            EntityUtil.removePotions(this.target, MobEffects.BLINDNESS, MobEffects.DAMAGE_RESISTANCE, MobEffects.WEAKNESS, MobEffects.MOVEMENT_SLOWDOWN, MobEffects.LEVITATION, MobEffects.NIGHT_VISION);
        }
        if (this.shooter != null && this.shooter.getHealth() > 0.0f) {
            EntityUtil.removePotions(this.shooter, MobEffects.BLINDNESS, MobEffects.DAMAGE_RESISTANCE, MobEffects.WEAKNESS, MobEffects.MOVEMENT_SLOWDOWN, MobEffects.LEVITATION, MobEffects.NIGHT_VISION);
        }
    }
}

