/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.scheduling.sync;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.scheduling.AoAScheduler;
import net.tslat.smartbrainlib.util.RandomUtil;

public class RuneCreationTask
implements Runnable {
    private final ServerLevel level;
    private final BlockPos pos;
    private final Item rune;
    private final int count;
    private final Player owner;
    private int ticker;

    public RuneCreationTask(ServerLevel level, BlockPos pos, Item rune, int count, Player owner) {
        this.level = level;
        this.pos = pos;
        this.rune = rune;
        this.count = count;
        this.owner = owner;
        this.ticker = 20 * (3 + count / 10);
    }

    @Override
    public void run() {
        this.ticker -= 5;
        if (this.ticker > 0) {
            this.level.sendParticles((ParticleOptions)ParticleTypes.END_ROD, (double)this.pos.getX() + 0.5 + RandomUtil.randomGaussianValue() * 0.1, (double)this.pos.getY() + 1.0 + (0.85 - 0.85 * (double)this.ticker / (double)(20.0f * (3.0f + (float)this.count / 10.0f))), (double)this.pos.getZ() + 0.5 + RandomUtil.randomGaussianValue() * 0.1, 1, 0.0, 0.0, 0.0, 0.01);
            AoAScheduler.scheduleSyncronisedTask(this, 5);
        } else {
            ItemEntity entity;
            for (int spawned = 0; spawned < this.count; spawned += entity.getItem().getCount()) {
                entity = new ItemEntity((Level)this.level, (double)((float)this.pos.getX() + 0.5f), (double)((float)this.pos.getY() + 1.85f), (double)((float)this.pos.getZ() + 0.5f), new ItemStack((ItemLike)this.rune, Math.min(64, this.count)));
                entity.setDeltaMovement(0.0, 0.0, 0.0);
                entity.setThrower((Entity)this.owner);
                entity.setNoPickUpDelay();
                entity.setNoGravity(true);
                this.level.addFreshEntity((Entity)entity);
            }
        }
    }
}

