/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.scheduling.async;

import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.common.registration.custom.AoAResources;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.scheduling.AoAScheduler;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PlayerUtil;

public class KrorSpawnTask
implements Runnable {
    private final ServerPlayer player;
    private final Level world;
    private final BlockPos chargingTablePos;
    private int chargedAmount = 0;

    public KrorSpawnTask(ServerPlayer player, BlockPos pos) {
        this.player = player;
        this.world = player.level();
        this.chargingTablePos = pos;
    }

    @Override
    public void run() {
        if (this.player.level() != this.world || this.player.distanceToSqr((double)this.chargingTablePos.getX(), (double)this.chargingTablePos.getY(), (double)this.chargingTablePos.getZ()) > 100.0) {
            return;
        }
        if (this.world.getDifficulty() == Difficulty.PEACEFUL) {
            this.player.sendSystemMessage((Component)LocaleUtil.getLocaleMessage(LocaleUtil.createFeedbackLocaleKey("spawnBoss.difficultyFail")));
            return;
        }
        if (this.world.getBlockState(this.chargingTablePos).getBlock() != AoABlocks.CHARGING_TABLE.get()) {
            return;
        }
        if (this.chargedAmount < 200) {
            if (PlayerUtil.consumeResource(this.player, (AoAResource)AoAResources.SPIRIT.get(), 20.0f, false)) {
                this.chargedAmount += 20;
                ((ServerLevel)this.world).sendParticles((ParticleOptions)ParticleTypes.END_ROD, (double)this.chargingTablePos.getX() + 0.5, (double)this.chargingTablePos.getY() + 0.9, (double)this.chargingTablePos.getZ() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
                ((ServerLevel)this.world).sendParticles((ParticleOptions)ParticleTypes.END_ROD, this.player.getX(), this.player.getBoundingBox().maxY + 0.5, this.player.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
                this.schedule(1, TimeUnit.SECONDS);
            } else {
                PlayerUtil.notifyPlayerOfInsufficientResources(this.player, (AoAResource)AoAResources.SPIRIT.get(), 20.0f);
            }
        }
    }

    public void schedule(Integer time, TimeUnit units) {
        AoAScheduler.scheduleAsyncTask(this, time, units);
    }
}

