/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.skill;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.event.entity.player.ItemFishedEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.tslat.aoa3.common.registration.AoATags;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.event.custom.events.HaulingItemFishedEvent;
import net.tslat.aoa3.event.dynamic.DynamicEventSubscriber;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.smartbrainlib.util.RandomUtil;

public class HaulingSkill
extends AoASkill.Instance {
    private final List<DynamicEventSubscriber<?>> eventSubscribers = List.of(this.listener(ItemFishedEvent.class, PlayerEvent::getEntity, this.serverOnly(this::handleItemFished)));

    public HaulingSkill(ServerPlayerDataManager plData, JsonObject jsonData) {
        super((AoASkill)AoASkills.HAULING.get(), plData, jsonData);
    }

    public HaulingSkill(CompoundTag nbtData) {
        super((AoASkill)AoASkills.HAULING.get(), nbtData);
    }

    public List<DynamicEventSubscriber<?>> getEventSubscribers() {
        return this.eventSubscribers;
    }

    private void handleItemFished(ItemFishedEvent ev) {
        if (!this.canGainXp(true)) {
            return;
        }
        float xp = PlayerUtil.getTimeBasedXpForLevel(this.getLevel(true), 200.0f) * (float)(1.0 + RandomUtil.randomScaledGaussianValue((double)0.25));
        if (ev instanceof HaulingItemFishedEvent) {
            xp *= 2.0f;
            for (ItemStack stack : ev.getDrops()) {
                if (!stack.is(AoATags.Items.HAULING_FISH)) continue;
                xp *= 1.25f;
            }
        }
        this.adjustXp(xp, false, false);
    }
}

