/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.skill;

import com.google.gson.JsonObject;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.event.entity.living.BabyEntitySpawnEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.event.dynamic.DynamicEventSubscriber;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.BlockUtil;
import net.tslat.aoa3.util.PlayerUtil;

public class FarmingSkill
extends AoASkill.Instance {
    private final List<DynamicEventSubscriber<?>> eventSubscribers = List.of(this.listener(BlockEvent.BreakEvent.class, BlockEvent.BreakEvent::getPlayer, this.serverOnly(this::handleBlockBreak)), this.listener(BabyEntitySpawnEvent.class, BabyEntitySpawnEvent::getCausedByPlayer, this.serverOnly(this::handleAnimalBreed)));

    public FarmingSkill(ServerPlayerDataManager plData, JsonObject jsonData) {
        super((AoASkill)AoASkills.FARMING.get(), plData, jsonData);
    }

    public FarmingSkill(CompoundTag nbtData) {
        super((AoASkill)AoASkills.FARMING.get(), nbtData);
    }

    public List<DynamicEventSubscriber<?>> getEventSubscribers() {
        return this.eventSubscribers;
    }

    private void handleBlockBreak(BlockEvent.BreakEvent ev) {
        if (this.canGainXp(true) && BlockUtil.canPlayerHarvest(ev.getState(), ev.getPlayer(), ev.getLevel(), ev.getPos())) {
            int xpTime;
            Block block = ev.getState().getBlock();
            Objects.requireNonNull(block);
            Block block2 = block;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CropBlock.class, NetherWartBlock.class}, (Object)block2, n)) {
                case 0: {
                    int n2;
                    CropBlock crop = (CropBlock)block2;
                    if (crop.isMaxAge(ev.getState())) {
                        n2 = 7 * crop.getMaxAge();
                        break;
                    }
                    n2 = 0;
                    break;
                }
                case 1: {
                    int n2;
                    NetherWartBlock netherWart = (NetherWartBlock)block2;
                    if ((Integer)ev.getState().getValue((Property)NetherWartBlock.AGE) == 3) {
                        n2 = 21;
                        break;
                    }
                    n2 = 0;
                    break;
                }
                default: {
                    int n2 = xpTime = ev.getState().is(BlockTags.CROPS) ? 12 : 0;
                }
            }
            if (xpTime > 0) {
                PlayerUtil.giveTimeBasedXpToPlayer((ServerPlayer)ev.getPlayer(), this.type(), xpTime, false);
            }
        }
    }

    private void handleAnimalBreed(BabyEntitySpawnEvent ev) {
        if (!this.canGainXp(true)) {
            return;
        }
        PlayerUtil.giveTimeBasedXpToPlayer((ServerPlayer)this.getPlayer(), this.type(), 600, false);
    }
}

