/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.resource;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.tslat.aoa3.common.registration.custom.AoAResources;
import net.tslat.aoa3.event.dynamic.DynamicEventSubscriber;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.player.resource.AoAResource;

public class RageResource
extends AoAResource.Instance {
    private final List<DynamicEventSubscriber<?>> eventSubscribers = List.of(this.afterTakingDamage(this::handleAfterDamaged), this.listener(PlayerTickEvent.Pre.class, PlayerEvent::getEntity, this::handlePlayerTick));
    private final float maxValue;
    private final float perTickDrain;
    private float value = 0.0f;

    public RageResource(ServerPlayerDataManager plData, JsonObject jsonData) {
        super((AoAResource)AoAResources.RAGE.get(), plData);
        this.maxValue = Math.max(0.0f, GsonHelper.getAsFloat((JsonObject)jsonData, (String)"max_value"));
        this.perTickDrain = GsonHelper.getAsFloat((JsonObject)jsonData, (String)"per_tick_drain");
    }

    public RageResource(CompoundTag nbtData) {
        super((AoAResource)AoAResources.RAGE.get(), null);
        this.maxValue = nbtData.getFloat("max_value");
        this.perTickDrain = nbtData.getFloat("per_tick_drain");
    }

    public List<DynamicEventSubscriber<?>> getEventSubscribers() {
        return this.eventSubscribers;
    }

    @Override
    public float getCurrentValue() {
        return this.value;
    }

    @Override
    public void setValue(float amount) {
        this.value = Mth.clamp((float)amount, (float)0.0f, (float)this.getMaxValue());
    }

    @Override
    public float getMaxValue() {
        return this.maxValue;
    }

    private void handleAfterDamaged(LivingDamageEvent.Post ev) {
        if (ev.getSource().getEntity() != null) {
            this.value = Math.min(this.getMaxValue(), this.value + ev.getOriginalDamage());
        }
    }

    private void handlePlayerTick(PlayerTickEvent.Pre ev) {
        if (this.value > 0.0f) {
            this.value -= this.perTickDrain;
        }
    }

    @Override
    public CompoundTag getSyncData(boolean forClientSetup) {
        CompoundTag nbt = new CompoundTag();
        if (forClientSetup) {
            nbt.putFloat("max_value", this.maxValue);
            nbt.putFloat("per_tick_drain", this.perTickDrain);
        } else {
            nbt.putFloat("value", this.getCurrentValue());
        }
        return nbt;
    }

    @Override
    public void receiveSyncData(CompoundTag data) {
        this.value = data.getFloat("value");
    }
}

