/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.resource;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.tslat.aoa3.common.registration.custom.AoAResources;
import net.tslat.aoa3.event.dynamic.DynamicEventSubscriber;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.player.resource.AoAResource;
import org.jetbrains.annotations.NotNull;

public class EnergyResource
extends AoAResource.Instance {
    private final List<DynamicEventSubscriber<?>> eventSubscribers = List.of(this.afterTakingDamage(this::handleAfterDamaged), this.listener(PlayerTickEvent.Pre.class, PlayerEvent::getEntity, this::handlePlayerTick));
    private final float maxValue;
    private final int dischargeDelay;
    private final int hitDelay;
    private final float regenAmount;
    private int currentDelay = 0;
    private float value = 0.0f;

    public EnergyResource(ServerPlayerDataManager plData, JsonObject jsonData) {
        super((AoAResource)AoAResources.ENERGY.get(), plData);
        this.maxValue = Math.max(0.0f, GsonHelper.getAsFloat((JsonObject)jsonData, (String)"max_value"));
        this.dischargeDelay = GsonHelper.getAsInt((JsonObject)jsonData, (String)"delay_on_empty");
        this.hitDelay = GsonHelper.getAsInt((JsonObject)jsonData, (String)"delay_on_hit");
        this.regenAmount = GsonHelper.getAsFloat((JsonObject)jsonData, (String)"regen_per_tick");
    }

    public EnergyResource(CompoundTag nbtData) {
        super((AoAResource)AoAResources.ENERGY.get(), null);
        this.maxValue = nbtData.getFloat("max_value");
        this.dischargeDelay = nbtData.getInt("delay_on_empty");
        this.hitDelay = nbtData.getInt("delay_on_hit");
        this.regenAmount = nbtData.getFloat("regen_per_tick");
    }

    public List<DynamicEventSubscriber<?>> getEventSubscribers() {
        return this.eventSubscribers;
    }

    @Override
    public float getCurrentValue() {
        return this.value;
    }

    public int getCurrentDelay() {
        return this.currentDelay;
    }

    @Override
    public boolean consume(float amount, boolean consumeIfInsufficient) {
        boolean success = super.consume(amount, true);
        if (this.getCurrentValue() <= 0.0f) {
            this.currentDelay += this.dischargeDelay;
            if (this.currentDelay > 1200) {
                this.currentDelay = 1200;
            }
        }
        return success;
    }

    @Override
    public void setValue(float amount) {
        this.value = Mth.clamp((float)amount, (float)0.0f, (float)this.getMaxValue());
    }

    @Override
    public float getMaxValue() {
        return this.maxValue;
    }

    @Override
    public float getPerTickRegen() {
        return this.regenAmount;
    }

    private void handlePlayerTick(PlayerTickEvent.Pre ev) {
        if (this.currentDelay > 0) {
            --this.currentDelay;
        } else if (this.value < this.getMaxValue()) {
            this.addValue(this.getPerTickRegen());
        }
    }

    private void handleAfterDamaged(LivingDamageEvent.Post ev) {
        if (ev.getNewDamage() > 0.0f) {
            this.currentDelay += this.hitDelay;
            if (this.currentDelay > 1200) {
                this.currentDelay = 1200;
            }
        }
    }

    @Override
    @NotNull
    public CompoundTag saveToNbt() {
        return new CompoundTag();
    }

    @Override
    public CompoundTag getSyncData(boolean forClientSetup) {
        CompoundTag data = new CompoundTag();
        if (forClientSetup) {
            data.putFloat("max_value", this.getMaxValue());
            data.putInt("delay_on_empty", this.dischargeDelay);
            data.putInt("delay_on_hit", this.hitDelay);
            data.putFloat("regen_per_tick", this.getPerTickRegen());
        } else {
            data.putFloat("value", this.getCurrentValue());
            data.putInt("current_delay", this.getCurrentDelay());
        }
        return data;
    }

    @Override
    public void receiveSyncData(CompoundTag data) {
        if (data.contains("value")) {
            this.value = data.getFloat("value");
        }
        if (data.contains("current_delay")) {
            this.currentDelay = data.getInt("current_delay");
        }
    }
}

