/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.halo;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.common.networking.AoANetworking;
import net.tslat.aoa3.common.networking.packets.SyncHaloDataPacket;
import net.tslat.aoa3.player.halo.HaloTypes;
import net.tslat.aoa3.player.halo.PlayerHaloContainer;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.Nullable;

public final class PlayerHaloManager {
    private static final Map<UUID, PlayerHaloContainer> PLAYER_HALOS = new Object2ObjectOpenHashMap();

    public static Map<UUID, PlayerHaloContainer> getHaloMap() {
        return ImmutableMap.copyOf(PLAYER_HALOS);
    }

    public static void updateSelectedHalo(UUID player, HaloTypes selected, boolean sync) {
        PLAYER_HALOS.computeIfAbsent(player, key -> PlayerHaloContainer.defaulted(selected)).updateSelectedHalo(player, selected, sync);
    }

    public static Optional<HaloTypes> getHaloForRender(UUID player) {
        return Optional.ofNullable(PLAYER_HALOS.get(player)).map(PlayerHaloManager::testAndCorrectHaloChoice);
    }

    @Nullable
    private static HaloTypes testAndCorrectHaloChoice(PlayerHaloContainer container) {
        HaloTypes selected = container.getSelected();
        if (container.isEmpty()) {
            return null;
        }
        if (container.hasHalo(selected)) {
            return selected;
        }
        for (int i = HaloTypes.values().length - 1; i >= 0; --i) {
            HaloTypes halo = HaloTypes.values()[i];
            if (!container.hasHalo(halo)) continue;
            return halo;
        }
        return null;
    }

    public static void syncFromServer(Map<UUID, PlayerHaloContainer> containers) {
        PLAYER_HALOS.clear();
        PLAYER_HALOS.putAll(containers);
    }

    public static void updateHalosFromWeb() {
        Object2ObjectOpenHashMap updatedHalos;
        block19: {
            Logging.logMessage(Level.DEBUG, "Updating player halos map");
            updatedHalos = new Object2ObjectOpenHashMap();
            try {
                HttpURLConnection connection = (HttpURLConnection)new URL("https://gist.githubusercontent.com/Tslat/2c2eb98dceeff18f05ed068982fb71a7/raw/").openConnection();
                connection.setConnectTimeout(1000);
                connection.connect();
                if (200 != connection.getResponseCode()) {
                    Logging.logMessage(Level.DEBUG, "Connection to cloud based halos map unavailable, response code " + connection.getResponseMessage());
                    break block19;
                }
                BufferedReader fileReader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                block11: while (true) {
                    String line;
                    while ((line = fileReader.readLine()) != null) {
                        String[] stringArray;
                        if (line.startsWith(" <!DOCTYPE") || (stringArray = line.split("\\|")).length <= 2) continue;
                        try {
                            UUID uuid = UUID.fromString(stringArray[1]);
                            EnumSet<HaloTypes> unlockedHalos = EnumSet.noneOf(HaloTypes.class);
                            for (int i = 2; i < stringArray.length; ++i) {
                                String type = stringArray[i];
                                try {
                                    unlockedHalos.add(HaloTypes.valueOf(type.toUpperCase(Locale.ROOT)));
                                    continue;
                                }
                                catch (IllegalArgumentException ex) {
                                    Logging.logMessage(Level.WARN, "Invalid halo type from web: " + type);
                                }
                            }
                            updatedHalos.put(uuid, PlayerHaloContainer.forUnlocked(unlockedHalos));
                            Logging.logMessage(Level.DEBUG, "Found player halo for " + String.valueOf(uuid));
                            continue block11;
                        }
                        catch (IllegalArgumentException ex) {
                            Logging.logMessage(Level.WARN, "Invalid UUID format from web: " + stringArray[1]);
                        }
                    }
                    break block19;
                    {
                        continue block11;
                        break;
                    }
                    break;
                }
                finally {
                    fileReader.close();
                }
            }
            catch (IOException ex) {
                Logging.logMessage(Level.DEBUG, "Connection to player halos map errored out, skipping", ex);
            }
        }
        long preUpdateHash = PLAYER_HALOS.hashCode();
        for (Map.Entry<UUID, PlayerHaloContainer> entry : PLAYER_HALOS.entrySet()) {
            entry.getValue().mergeUpdatedMap(updatedHalos.getOrDefault(entry.getKey(), PlayerHaloContainer.defaulted(entry.getValue().getSelected())));
        }
        if (PLAYER_HALOS.size() < updatedHalos.size()) {
            for (Map.Entry<UUID, PlayerHaloContainer> entry : updatedHalos.entrySet()) {
                if (PLAYER_HALOS.containsKey(entry.getKey())) continue;
                PLAYER_HALOS.put(entry.getKey(), entry.getValue());
            }
        }
        if (preUpdateHash != (long)PLAYER_HALOS.hashCode()) {
            AoANetworking.sendToAllPlayers(new SyncHaloDataPacket((Map<UUID, PlayerHaloContainer>)updatedHalos));
        }
    }
}

