/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability.innervation;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.tslat.aoa3.client.AoAKeybinds;
import net.tslat.aoa3.client.player.AoAPlayerKeybindListener;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.common.registration.custom.AoAResources;
import net.tslat.aoa3.event.dynamic.DynamicEventSubscriber;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.scheduling.AoAScheduler;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.effectslib.api.util.EffectBuilder;

public class StunStrike
extends AoAAbility.Instance {
    private final List<DynamicEventSubscriber<?>> eventSubscribers = List.of(this.afterAttacking(this.serverOnly(this::handleAfterAttacking)));
    private final float energyCost;
    private final int stunDuration;
    private boolean primedAttack = false;

    public StunStrike(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)AoAAbilities.STUN_STRIKE.get(), skill, data);
        this.energyCost = GsonHelper.getAsFloat((JsonObject)data, (String)"energy_cost");
        this.stunDuration = GsonHelper.getAsInt((JsonObject)data, (String)"stun_duration", (int)20);
    }

    public StunStrike(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)AoAAbilities.STUN_STRIKE.get(), skill, data);
        this.energyCost = data.getFloat("energy_cost");
        this.stunDuration = data.getInt("stun_duration");
    }

    @Override
    protected void updateDescription(MutableComponent defaultDescription) {
        super.updateDescription(Component.translatable((String)((TranslatableContents)defaultDescription.getContents()).getKey(), (Object[])new Object[]{NumberUtil.roundToNthDecimalPlace((float)this.stunDuration / 20.0f, 2), NumberUtil.roundToNthDecimalPlace(this.energyCost, 2)}));
    }

    public List<DynamicEventSubscriber<?>> getEventSubscribers() {
        return this.eventSubscribers;
    }

    @Override
    public void createKeybindListener(Consumer<AoAPlayerKeybindListener> consumer) {
        consumer.accept(new AoAPlayerKeybindListener(){

            @Override
            public AoAPlayerEventListener getEventListener() {
                return StunStrike.this;
            }

            @Override
            public int getKeycode() {
                return AoAKeybinds.ABILITY_ACTION.getKey().getValue();
            }

            @Override
            public boolean shouldSendKeyPress() {
                LocalPlayer pl = Minecraft.getInstance().player;
                return !pl.input.hasForwardImpulse() && pl.input.leftImpulse == 0.0f && !pl.getItemInHand(InteractionHand.OFF_HAND).isEmpty() && PlayerUtil.getResourceValue((Player)pl, (AoAResource)AoAResources.ENERGY.get()) >= StunStrike.this.energyCost;
            }
        });
    }

    @Override
    public void handleKeyInput() {
        Player player = this.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (!this.primedAttack && this.skill.getPlayerDataManager().getResource((AoAResource)AoAResources.ENERGY.get()).hasAmount(this.energyCost)) {
                this.primedAttack = true;
                this.activatedActionKey(player2);
            }
        }
    }

    private void handleAfterAttacking(LivingDamageEvent.Post ev) {
        if (ev.getNewDamage() > 0.0f && this.primedAttack && DamageUtil.isMeleeDamage(ev.getSource()) && !this.getPlayer().getItemInHand(InteractionHand.OFF_HAND).isEmpty()) {
            this.primedAttack = false;
            if (this.skill.getPlayerDataManager().getResource((AoAResource)AoAResources.ENERGY.get()).consume(this.energyCost, true)) {
                ServerPlayer player = (ServerPlayer)this.getPlayer();
                LivingEntity target = ev.getEntity();
                AoAScheduler.scheduleSyncronisedTask(() -> {
                    player.swing(InteractionHand.OFF_HAND, true);
                    if (target != null && target.isAlive() && player.distanceToSqr((Entity)target) < 36.0 && player.hasLineOfSight((Entity)target)) {
                        DamageUtil.doScaledKnockback(target, (LivingEntity)player, 0.3f, 1.0, 1.0, 1.0);
                        EntityUtil.applyPotions((Entity)target, new EffectBuilder(MobEffects.MOVEMENT_SLOWDOWN, this.stunDuration).level(127), new EffectBuilder(MobEffects.DIG_SLOWDOWN, this.stunDuration).level(127));
                        this.activatedActionKey(player);
                        if (this.skill.canGainXp(true)) {
                            PlayerUtil.giveTimeBasedXpToPlayer(player, this.skill.type(), 39, false);
                        }
                    }
                }, player.getCurrentSwingDuration() - 1);
            }
        }
    }

    @Override
    public CompoundTag getSyncData(boolean forClientSetup) {
        CompoundTag data = super.getSyncData(forClientSetup);
        if (forClientSetup) {
            data.putFloat("energy_cost", this.energyCost);
            data.putFloat("stun_duration", (float)this.stunDuration);
        }
        return data;
    }
}

