/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability.innervation;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.tslat.aoa3.client.AoAKeybinds;
import net.tslat.aoa3.client.player.AoAPlayerKeybindListener;
import net.tslat.aoa3.client.player.ClientPlayerDataManager;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.common.registration.custom.AoAResources;
import net.tslat.aoa3.event.dynamic.DynamicEventSubscriber;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.PlayerUtil;

public class InnervationDodge
extends AoAAbility.Instance {
    private final List<DynamicEventSubscriber<?>> eventSubscribers = List.of(this.whenTakingDamage(this.serverOnly(this::handleIncomingDamage)));
    private final float energyCost;
    private long activationTime;

    public InnervationDodge(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)AoAAbilities.INNERVATION_DODGE.get(), skill, data);
        this.energyCost = GsonHelper.getAsFloat((JsonObject)data, (String)"energy_cost");
    }

    public InnervationDodge(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)AoAAbilities.INNERVATION_DODGE.get(), skill, data);
        this.energyCost = data.getFloat("energy_cost");
    }

    @Override
    protected void updateDescription(MutableComponent defaultDescription) {
        super.updateDescription(Component.translatable((String)((TranslatableContents)defaultDescription.getContents()).getKey(), (Object[])new Object[]{NumberUtil.roundToNthDecimalPlace(this.energyCost, 2)}));
    }

    public List<DynamicEventSubscriber<?>> getEventSubscribers() {
        return this.eventSubscribers;
    }

    @Override
    public void createKeybindListener(Consumer<AoAPlayerKeybindListener> consumer) {
        consumer.accept(new AoAPlayerKeybindListener(){

            @Override
            public AoAPlayerEventListener getEventListener() {
                return InnervationDodge.this;
            }

            @Override
            public int getKeycode() {
                return AoAKeybinds.ABILITY_ACTION.getKey().getValue();
            }

            @Override
            public boolean shouldSendKeyPress() {
                Minecraft mc = Minecraft.getInstance();
                LocalPlayer player = mc.player;
                TickRateManager tickRateManager = mc.level.tickRateManager();
                float yRot = player.getViewYRot(mc.getTimer().getGameTimeDeltaPartialTick(!tickRateManager.isEntityFrozen((Entity)player)));
                if (player.input.leftImpulse == 0.0f || player.input.hasForwardImpulse() || player.level().getGameTime() <= InnervationDodge.this.activationTime + 5L || player.getAbilities().flying) {
                    return false;
                }
                if (ClientPlayerDataManager.get().getResource((AoAResource)AoAResources.ENERGY.get()).hasAmount(InnervationDodge.this.energyCost)) {
                    Vec3 movement = player.getDeltaMovement();
                    double limit = player.onGround() ? 2.5 : 0.9;
                    double velocityX = Mth.clamp((double)(movement.x() + (double)(Mth.cos((float)(yRot * ((float)Math.PI / 180))) * player.input.leftImpulse)), (double)(-limit), (double)limit);
                    double velocityZ = Mth.clamp((double)(movement.z() + (double)(Mth.sin((float)(yRot * ((float)Math.PI / 180))) * player.input.leftImpulse)), (double)(-limit), (double)limit);
                    player.setDeltaMovement(new Vec3(velocityX, movement.y(), velocityZ));
                    InnervationDodge.this.activationTime = player.level().getGameTime();
                }
                return true;
            }
        });
    }

    @Override
    public void handleKeyInput() {
        Player player = this.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (this.skill.getPlayerDataManager().getResource((AoAResource)AoAResources.ENERGY.get()).consume(this.energyCost, true)) {
                this.activatedActionKey(player2);
                if (this.skill.canGainXp(true)) {
                    PlayerUtil.giveTimeBasedXpToPlayer(player2, this.skill.type(), 20, false);
                }
            }
        }
    }

    private void handleIncomingDamage(LivingIncomingDamageEvent ev) {
        if (ev.getEntity().level().getGameTime() < this.activationTime + 5L && DamageUtil.isMeleeDamage(ev.getSource())) {
            ev.setCanceled(true);
        }
    }

    @Override
    public CompoundTag getSyncData(boolean forClientSetup) {
        CompoundTag data = super.getSyncData(forClientSetup);
        if (forClientSetup) {
            data.putFloat("energy_cost", this.energyCost);
        }
        return data;
    }
}

