/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability.innervation;

import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.event.custom.events.PlayerSkillsLootModificationEvent;
import net.tslat.aoa3.event.dynamic.DynamicEventSubscriber;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.ability.generic.ScalableModAbility;
import net.tslat.aoa3.player.skill.AoASkill;

public class DoubleDropsChance
extends ScalableModAbility {
    private final List<DynamicEventSubscriber<?>> eventSubscribers = List.of(this.listener(PlayerSkillsLootModificationEvent.class, this.serverOnly(this::handleLootModification)));

    public DoubleDropsChance(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)AoAAbilities.DOUBLE_DROPS_CHANCE.get(), skill, data);
    }

    public DoubleDropsChance(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)AoAAbilities.DOUBLE_DROPS_CHANCE.get(), skill, data);
    }

    public List<DynamicEventSubscriber<?>> getEventSubscribers() {
        return this.eventSubscribers;
    }

    private void handleLootModification(PlayerSkillsLootModificationEvent ev) {
        if (!ev.getLootContext().hasParam(LootContextParams.THIS_ENTITY)) {
            return;
        }
        ObjectArrayList<ItemStack> loot = ev.getGeneratedLoot();
        Entity killedEntity = (Entity)ev.getLootContext().getParamOrNull(LootContextParams.THIS_ENTITY);
        if (killedEntity instanceof Player) {
            return;
        }
        if (this.testAsChance()) {
            ObjectArrayList extras = null;
            for (ItemStack stack : loot) {
                if (stack.isStackable()) {
                    if (stack.getCount() <= stack.getMaxStackSize() / 2) {
                        stack.setCount(stack.getCount() * 2);
                        continue;
                    }
                    if (extras == null) {
                        extras = new ObjectArrayList();
                    }
                    ItemStack newStack = stack.copy();
                    newStack.setCount(stack.getCount() * 2 - newStack.getMaxStackSize());
                    stack.setCount(stack.getMaxStackSize());
                    extras.add(newStack);
                    continue;
                }
                if (extras == null) {
                    extras = new ObjectArrayList();
                }
                extras.add(stack.copy());
            }
            if (extras != null) {
                loot.addAll((Collection<ItemStack>)extras);
            }
        }
    }
}

