/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability.imbuing;

import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.Enchantment;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.content.recipe.ImbuingRecipe;
import net.tslat.aoa3.event.dynamic.DynamicEventSubscriber;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.EnchantmentUtil;

public class ImbuingLevelRestriction
extends AoAAbility.Instance {
    private final ResourceLocation recipeId;
    private Optional<ImbuingRecipe> cachedRecipe = null;

    public ImbuingLevelRestriction(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)AoAAbilities.IMBUING_LEVEL_RESTRICTION.get(), skill, data);
        this.recipeId = (ResourceLocation)ResourceLocation.read((String)GsonHelper.getAsString((JsonObject)data, (String)"recipe_id")).getOrThrow();
    }

    public ImbuingLevelRestriction(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)AoAAbilities.IMBUING_LEVEL_RESTRICTION.get(), skill, data);
        this.recipeId = (ResourceLocation)ResourceLocation.read((String)data.getString("recipe_id")).getOrThrow();
    }

    public List<DynamicEventSubscriber<?>> getEventSubscribers() {
        return Collections.emptyList();
    }

    @Override
    protected void updateDescription(MutableComponent defaultDescription) {
        if (this.cachedRecipe == null) {
            this.cachedRecipe = this.getPlayer().level().getRecipeManager().byKey(this.recipeId).filter(holder -> holder.value() instanceof ImbuingRecipe).map(RecipeHolder::value);
        }
        super.updateDescription(Component.translatable((String)((TranslatableContents)defaultDescription.getContents()).getKey(), (Object[])new Object[]{this.cachedRecipe.map(recipe -> EnchantmentUtil.getFormattedName((Holder<Enchantment>)((Holder)recipe.getEnchant().left()), recipe.getEnchant().rightInt())).orElseGet(() -> Component.literal((String)this.recipeId.getPath()))}));
    }

    @Override
    public CompoundTag getSyncData(boolean forClientSetup) {
        CompoundTag data = super.getSyncData(forClientSetup);
        if (forClientSetup) {
            data.putString("recipe_id", this.recipeId.toString());
        }
        return data;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean onGuiHover(int mouseX, int mouseY) {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean onGuiClick(int mouseX, int mouseY) {
        return false;
    }
}

