/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability.imbuing;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.content.item.misc.PowerStone;
import net.tslat.aoa3.event.dynamic.DynamicEventSubscriber;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.effectslib.api.particle.ParticleBuilder;
import net.tslat.effectslib.networking.packet.TELParticlePacket;

public class EnchantEntityEquipment
extends AoAAbility.Instance {
    private final List<DynamicEventSubscriber<?>> eventSubscribers = List.of(this.listener(PlayerInteractEvent.EntityInteractSpecific.class, PlayerEvent::getEntity, this.serverOnly(this::handleEntityInteraction)));

    public EnchantEntityEquipment(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)AoAAbilities.ENCHANT_ENTITY_EQUIPMENT.get(), skill, data);
    }

    public EnchantEntityEquipment(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)AoAAbilities.ENCHANT_ENTITY_EQUIPMENT.get(), skill, data);
    }

    public List<DynamicEventSubscriber<?>> getEventSubscribers() {
        return this.eventSubscribers;
    }

    private void handleEntityInteraction(PlayerInteractEvent.EntityInteractSpecific ev) {
        Item item = ev.getItemStack().getItem();
        if (item instanceof PowerStone) {
            PowerStone powerStone = (PowerStone)item;
            item = ev.getTarget();
            if (item instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)item;
                ServerPlayer player = (ServerPlayer)ev.getEntity();
                ServerLevel level = player.serverLevel();
                int enchantLevel = powerStone.getEnchantLevel();
                int totalEnchants = 0;
                for (ItemStack heldItem : target.getHandSlots()) {
                    if (!heldItem.isEnchantable() || heldItem.getItem() == Items.BOOK) continue;
                    EnchantmentHelper.enchantItem((RandomSource)player.getRandom(), (ItemStack)heldItem, (int)enchantLevel, (RegistryAccess)level.registryAccess(), Optional.empty());
                    ++totalEnchants;
                }
                for (ItemStack armourItem : target.getArmorSlots()) {
                    if (!armourItem.isEnchantable() || armourItem.getItem() == Items.BOOK) continue;
                    EnchantmentHelper.enchantItem((RandomSource)player.getRandom(), (ItemStack)armourItem, (int)enchantLevel, (RegistryAccess)level.registryAccess(), Optional.empty());
                    ++totalEnchants;
                }
                if (totalEnchants > 0) {
                    PlayerUtil.giveTimeBasedXpToPlayer(player, this.skill.type(), 100 * totalEnchants * enchantLevel, false);
                    if (!player.getAbilities().instabuild) {
                        ev.getItemStack().shrink(1);
                    }
                    level.playSound(null, target.blockPosition(), SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.PLAYERS, 1.0f, 1.0f);
                    TELParticlePacket packet = new TELParticlePacket();
                    for (int i = 0; i < 100; ++i) {
                        packet.particle(ParticleBuilder.forRandomPosInEntity((ParticleOptions)ParticleTypes.GLOW, (Entity)target).colourOverride(player.getRandom().nextIntBetweenInclusive(100, 220), 0, 255, 255));
                    }
                    packet.sendToAllPlayersTrackingEntity(level, (Entity)target);
                    ev.setCanceled(true);
                }
            }
        }
    }
}

