/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability.hauling;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.item.weapon.gun.BaseGun;
import net.tslat.aoa3.content.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.content.skill.hauling.HaulingEntity;
import net.tslat.aoa3.event.custom.events.HaulingSpawnEntityEvent;
import net.tslat.aoa3.event.dynamic.DynamicEventSubscriber;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.ability.generic.ScalableModAbility;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.InventoryUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.smartbrainlib.util.RandomUtil;

public class HaulingResupply
extends ScalableModAbility {
    private final List<DynamicEventSubscriber<?>> eventSubscribers = List.of(this.listener(HaulingSpawnEntityEvent.class, this.serverOnly(this::handleHaulingEntitySpawn)));

    public HaulingResupply(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)AoAAbilities.HAULING_RESUPPLY.get(), skill, data);
    }

    public HaulingResupply(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)AoAAbilities.HAULING_RESUPPLY.get(), skill, data);
    }

    public List<DynamicEventSubscriber<?>> getEventSubscribers() {
        return this.eventSubscribers;
    }

    @Override
    protected MutableComponent getScalingDescriptionComponent(int precision) {
        return LocaleUtil.getAbilityValueDesc(this.baseValue != 0.0f, this.perLevelMod != 0.0f, this.isPercent(), NumberUtil.roundToNthDecimalPlace(this.baseValue * (float)(this.isPercent() ? 100 : 1), precision), NumberUtil.roundToNthDecimalPlace(this.perLevelMod * (float)(this.isPercent() ? 100 : 1), precision), NumberUtil.roundToNthDecimalPlace(Math.max(0.0f, this.getScaledValue() * (float)(this.isPercent() ? 100 : 1)), precision));
    }

    private void handleHaulingEntitySpawn(HaulingSpawnEntityEvent ev) {
        if (ev.getSpawnPool() != null && this.testAsChance()) {
            ObjectArrayList repairIngredients = new ObjectArrayList();
            InventoryUtil.findItem((Player)ev.getEntity(), arg_0 -> HaulingResupply.lambda$handleHaulingEntitySpawn$0((List)repairIngredients, arg_0));
            if (!repairIngredients.isEmpty()) {
                repairIngredients.add(() -> new ItemStack((ItemLike)Items.EXPERIENCE_BOTTLE, RandomUtil.randomNumberBetween((int)1, (int)2)));
                repairIngredients.add(() -> new ItemStack((ItemLike)AoAItems.CHUM.get(), RandomUtil.randomNumberBetween((int)1, (int)3)));
                ev.setNewEntity(new HaulingEntity(Either.left((Object)((ItemStack)((Supplier)RandomUtil.getRandomSelection((List)repairIngredients)).get())), Optional.empty(), 0, 0, 0.0f).apply(ev.getEntity().level(), ev.getSpawnPool().getFluidType() == NeoForgeMod.LAVA_TYPE.value()));
            }
        }
    }

    private static void checkRepairable(ItemStack inventoryStack, Consumer<Supplier<ItemStack>> repairStackConsumer) {
        if (inventoryStack.isDamaged() && inventoryStack.isRepairable()) {
            Item item = inventoryStack.getItem();
            if (item instanceof TieredItem) {
                TieredItem tieredItem = (TieredItem)item;
                repairStackConsumer.accept(() -> (ItemStack)RandomUtil.getRandomSelection((Object[])tieredItem.getTier().getRepairIngredient().getItems()));
            } else {
                repairStackConsumer.accept(() -> AoAItems.MAGIC_REPAIR_DUST.toStack());
            }
        }
        Item item = inventoryStack.getItem();
        Objects.requireNonNull(item);
        Item item2 = item;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ProjectileWeaponItem.class, BaseGun.class, BaseStaff.class}, (Object)item2, n)) {
            case 0: {
                ProjectileWeaponItem projectileWeapon = (ProjectileWeaponItem)item2;
                repairStackConsumer.accept(() -> projectileWeapon.getDefaultCreativeAmmo(null, inventoryStack));
                break;
            }
            case 1: {
                BaseGun gun = (BaseGun)item2;
                repairStackConsumer.accept(() -> gun.getAmmoItem().getDefaultInstance());
                break;
            }
            case 2: {
                BaseStaff staff = (BaseStaff)item2;
                repairStackConsumer.accept(() -> {
                    Object2IntMap<Item> runes = staff.runeCost(inventoryStack).runeCosts();
                    Item rune = (Item)RandomUtil.getRandomSelection((Object[])((Item[])runes.keySet().toArray((Object[])new Item[0])));
                    return new ItemStack((ItemLike)rune, RandomUtil.randomNumberBetween((int)1, (int)(runes.getInt((Object)rune) * 2)));
                });
                break;
            }
        }
    }

    private static /* synthetic */ boolean lambda$handleHaulingEntitySpawn$0(List repairIngredients, ItemStack stack) {
        HaulingResupply.checkRepairable(stack, repairIngredients::add);
        return false;
    }
}

