/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability.generic;

import com.google.gson.JsonObject;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.smartbrainlib.util.RandomUtil;

public abstract class ScalableModAbility
extends AoAAbility.Instance {
    protected final float baseValue;
    protected final float perLevelMod;
    private int lastUpdateLevel = 0;

    public ScalableModAbility(AoAAbility ability, AoASkill.Instance skill, JsonObject data) {
        super(ability, skill, data);
        this.baseValue = GsonHelper.getAsFloat((JsonObject)data, (String)"base_value", (float)0.0f);
        this.perLevelMod = GsonHelper.getAsFloat((JsonObject)data, (String)"per_level_mod", (float)0.0f);
    }

    public ScalableModAbility(AoAAbility ability, AoASkill.Instance skill, CompoundTag data) {
        super(ability, skill, data);
        this.baseValue = data.getFloat("base_value");
        this.perLevelMod = data.getFloat("per_level_mod");
    }

    @Override
    protected void updateDescription(MutableComponent defaultDescription) {
        String defaultKey = Util.makeDescriptionId((String)"ability", (ResourceLocation)AoARegistries.AOA_ABILITIES.getKey(this.type())) + ".description";
        TranslatableContents contents = (TranslatableContents)defaultDescription.getContents();
        if (contents.getKey().equals(defaultKey) && contents.getArgs().length == 0) {
            MutableComponent component = Component.translatable((String)contents.getKey(), (Object[])new Object[]{this.getScalingDescriptionComponent(4)});
            for (Component child : defaultDescription.getSiblings()) {
                component.append(child);
            }
            super.updateDescription(component);
            return;
        }
        super.updateDescription(defaultDescription);
    }

    @Override
    public MutableComponent getDescription() {
        if (this.skill.getLevel(true) != this.lastUpdateLevel) {
            this.lastUpdateLevel = this.skill.getLevel(true);
            this.updateDescription(Component.translatable((String)(Util.makeDescriptionId((String)"ability", (ResourceLocation)AoARegistries.AOA_ABILITIES.getKey(this.type())) + ".description")));
        }
        return super.getDescription();
    }

    protected MutableComponent getScalingDescriptionComponent(int precision) {
        return LocaleUtil.getAbilityValueDesc(this.baseValue != 0.0f, this.perLevelMod != 0.0f, this.isPercent(), NumberUtil.roundToNthDecimalPlace(this.baseValue * (float)(this.isPercent() ? 100 : 1), precision), NumberUtil.roundToNthDecimalPlace(this.perLevelMod * (float)(this.isPercent() ? 100 : 1), precision), NumberUtil.roundToNthDecimalPlace(this.getScaledValue() * (float)(this.isPercent() ? 100 : 1), precision));
    }

    protected boolean isPercent() {
        return true;
    }

    protected boolean testAsChance() {
        return RandomUtil.percentChance((float)this.getScaledValue());
    }

    protected float getScaledValue() {
        if (this.perLevelMod == 0.0f) {
            return this.baseValue;
        }
        return this.baseValue + (float)Math.round((float)this.skill.getLevel(false) * 1.01f - 1.0f) * this.perLevelMod;
    }

    @Override
    public CompoundTag getSyncData(boolean forClientSetup) {
        CompoundTag data = super.getSyncData(forClientSetup);
        if (forClientSetup) {
            data.putFloat("base_value", this.baseValue);
            data.putFloat("per_level_mod", this.perLevelMod);
        }
        return data;
    }
}

