/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability.generic;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.event.custom.events.ItemCraftingEvent;
import net.tslat.aoa3.event.dynamic.DynamicEventSubscriber;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.ability.generic.ScalableModAbility;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.RegistryUtil;
import org.jetbrains.annotations.Nullable;

public class BonusCraftingOutput
extends ScalableModAbility {
    private final List<DynamicEventSubscriber<?>> eventSubscribers = List.of(this.listener(ItemCraftingEvent.class, this.serverOnly(this::handleItemCrafting)));
    @Nullable
    private final Item outputTarget;
    @Nullable
    private final TagKey<Item> outputTargetTag;

    public BonusCraftingOutput(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)AoAAbilities.BONUS_CRAFTING_OUTPUT.get(), skill, data);
        if (data.has("item")) {
            this.outputTargetTag = null;
            this.outputTarget = AoARegistries.ITEMS.getEntry((ResourceLocation)ResourceLocation.read((String)GsonHelper.getAsString((JsonObject)data, (String)"item")).getOrThrow());
        } else {
            this.outputTarget = null;
            this.outputTargetTag = ItemTags.create((ResourceLocation)((ResourceLocation)ResourceLocation.read((String)GsonHelper.getAsString((JsonObject)data, (String)"tag")).getOrThrow()));
        }
    }

    public BonusCraftingOutput(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)AoAAbilities.BONUS_CRAFTING_OUTPUT.get(), skill, data);
        if (data.contains("item")) {
            this.outputTargetTag = null;
            this.outputTarget = AoARegistries.ITEMS.getEntry((ResourceLocation)ResourceLocation.read((String)data.getString("item")).getOrThrow());
        } else {
            this.outputTarget = null;
            this.outputTargetTag = ItemTags.create((ResourceLocation)((ResourceLocation)ResourceLocation.read((String)data.getString("tag")).getOrThrow()));
        }
    }

    @Override
    protected void updateDescription(MutableComponent defaultDescription) {
        MutableComponent component = this.outputTarget != null ? Component.translatable((String)(((TranslatableContents)defaultDescription.getContents()).getKey() + ".item"), (Object[])new Object[]{this.getScalingDescriptionComponent(2), this.outputTarget.getDefaultInstance().getHoverName()}) : Component.translatable((String)(((TranslatableContents)defaultDescription.getContents()).getKey() + ".tag"), (Object[])new Object[]{this.getScalingDescriptionComponent(2), this.outputTargetTag.location().toString()});
        super.updateDescription(component);
    }

    public List<DynamicEventSubscriber<?>> getEventSubscribers() {
        return this.eventSubscribers;
    }

    private void handleItemCrafting(ItemCraftingEvent ev) {
        if (this.outputTarget != null) {
            if (ev.getOutputStack().getItem() == this.outputTarget) {
                ev.getOutputStack().setCount((int)Math.ceil((float)ev.getOutputStack().getCount() * (1.0f + this.getScaledValue())));
            }
        } else if (ev.getOutputStack().is(this.outputTargetTag)) {
            ev.getOutputStack().setCount((int)Math.ceil((float)ev.getOutputStack().getCount() * (1.0f + this.getScaledValue())));
        }
    }

    @Override
    public CompoundTag getSyncData(boolean forClientSetup) {
        CompoundTag data = super.getSyncData(forClientSetup);
        if (forClientSetup) {
            if (this.outputTarget != null) {
                data.putString("item", RegistryUtil.getId(this.outputTarget).toString());
            } else {
                data.putString("tag", this.outputTargetTag.location().toString());
            }
        }
        return data;
    }
}

