/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability.generic;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.event.dynamic.DynamicEventSubscriber;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.RegistryUtil;
import net.tslat.aoa3.util.WorldUtil;
import org.jetbrains.annotations.Nullable;

public class BlockConversion
extends AoAAbility.Instance {
    private final List<DynamicEventSubscriber<?>> eventSubscribers = List.of(this.listener(PlayerInteractEvent.RightClickBlock.class, this.serverOnly(this::handleBlockInteraction)));
    private final int radius;
    private final Block targetBlock;
    private final Block replacementBlock;
    @Nullable
    private final Item interactionItem;

    public BlockConversion(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)AoAAbilities.BLOCK_CONVERSION.get(), skill, data);
        this.radius = GsonHelper.getAsInt((JsonObject)data, (String)"radius", (int)1);
        this.targetBlock = AoARegistries.BLOCKS.getEntry((ResourceLocation)ResourceLocation.read((String)GsonHelper.getAsString((JsonObject)data, (String)"target_block")).getOrThrow());
        this.replacementBlock = AoARegistries.BLOCKS.getEntry((ResourceLocation)ResourceLocation.read((String)GsonHelper.getAsString((JsonObject)data, (String)"replacement_block")).getOrThrow());
        this.interactionItem = data.has("interaction_item") ? AoARegistries.ITEMS.getEntry((ResourceLocation)ResourceLocation.read((String)GsonHelper.getAsString((JsonObject)data, (String)"interaction_item")).getOrThrow()) : null;
        if (this.radius < 0) {
            throw new IllegalArgumentException("Invalid radius value for BlockConversion ability: '" + this.radius + "'. Must be at least 0");
        }
    }

    public BlockConversion(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)AoAAbilities.BLOCK_CONVERSION.get(), skill, data);
        this.radius = data.getInt("radius");
        this.targetBlock = AoARegistries.BLOCKS.getEntry((ResourceLocation)ResourceLocation.read((String)data.getString("target_block")).getOrThrow());
        this.replacementBlock = AoARegistries.BLOCKS.getEntry((ResourceLocation)ResourceLocation.read((String)data.getString("replacement_block")).getOrThrow());
        this.interactionItem = data.contains("interaction_item") ? AoARegistries.ITEMS.getEntry((ResourceLocation)ResourceLocation.read((String)data.getString("interaction_item")).getOrThrow()) : null;
    }

    @Override
    protected void updateDescription(MutableComponent defaultDescription) {
        String suffix = this.radius > 0 ? "" : ".single";
        MutableComponent description = this.interactionItem != null ? Component.translatable((String)(((TranslatableContents)defaultDescription.getContents()).getKey() + suffix), (Object[])new Object[]{this.radius, this.targetBlock.getName(), this.replacementBlock.getName(), this.interactionItem.getName(this.interactionItem.getDefaultInstance())}) : Component.translatable((String)(((TranslatableContents)defaultDescription.getContents()).getKey() + ".noItem" + suffix), (Object[])new Object[]{this.radius, this.targetBlock.getName(), this.replacementBlock.getName()});
        super.updateDescription(description);
    }

    public List<DynamicEventSubscriber<?>> getEventSubscribers() {
        return this.eventSubscribers;
    }

    private void handleBlockInteraction(PlayerInteractEvent.RightClickBlock ev) {
        if (ev.getLevel().getBlockState(ev.getPos()).getBlock() == this.targetBlock) {
            ItemStack heldStack = ev.getEntity().getItemInHand(ev.getHand());
            if (this.interactionItem == null || heldStack.getItem() == this.interactionItem) {
                Level world = ev.getLevel();
                BlockPos pos = ev.getPos();
                BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
                BlockState newState = this.replacementBlock.defaultBlockState();
                boolean success = false;
                switch (ev.getHitVec().getDirection()) {
                    case EAST: 
                    case WEST: {
                        for (int y = -this.radius; y <= this.radius; ++y) {
                            for (int z = -this.radius; z <= this.radius; ++z) {
                                mutablePos.set(pos.getX(), pos.getY() + y, pos.getZ() + z);
                                if (world.getBlockState((BlockPos)mutablePos).getBlock() != this.targetBlock || !WorldUtil.canModifyBlock((LevelAccessor)world, (BlockPos)mutablePos, (Entity)ev.getEntity(), heldStack)) continue;
                                world.setBlockAndUpdate((BlockPos)mutablePos, newState);
                                success = true;
                            }
                        }
                        break;
                    }
                    case NORTH: 
                    case SOUTH: {
                        for (int y = -this.radius; y <= this.radius; ++y) {
                            for (int x = -this.radius; x <= this.radius; ++x) {
                                mutablePos.set(pos.getX() + x, pos.getY() + y, pos.getZ());
                                if (world.getBlockState((BlockPos)mutablePos).getBlock() != this.targetBlock || !WorldUtil.canModifyBlock((LevelAccessor)world, (BlockPos)mutablePos, (Entity)ev.getEntity(), heldStack)) continue;
                                world.setBlockAndUpdate((BlockPos)mutablePos, newState);
                                success = true;
                            }
                        }
                        break;
                    }
                    case UP: 
                    case DOWN: {
                        for (int x = -this.radius; x <= this.radius; ++x) {
                            for (int z = -this.radius; z <= this.radius; ++z) {
                                mutablePos.set(pos.getX() + x, pos.getY(), pos.getZ() + z);
                                if (world.getBlockState((BlockPos)mutablePos).getBlock() != this.targetBlock || !WorldUtil.canModifyBlock((LevelAccessor)world, (BlockPos)mutablePos, (Entity)ev.getEntity(), heldStack)) continue;
                                world.setBlockAndUpdate((BlockPos)mutablePos, newState);
                                success = true;
                            }
                        }
                        break;
                    }
                }
                if (success && this.interactionItem != null && !ev.getEntity().isCreative()) {
                    heldStack.shrink(1);
                }
            }
        }
    }

    @Override
    public CompoundTag getSyncData(boolean forClientSetup) {
        CompoundTag data = super.getSyncData(forClientSetup);
        if (forClientSetup) {
            data.putInt("radius", this.radius);
            data.putString("target_block", RegistryUtil.getId(this.targetBlock).toString());
            data.putString("replacement_block", RegistryUtil.getId(this.replacementBlock).toString());
            if (this.interactionItem != null) {
                data.putString("interaction_item", RegistryUtil.getId(this.interactionItem).toString());
            }
        }
        return data;
    }
}

