/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability.generic;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.event.custom.events.ApplyDynamicAttributeModifiersEvent;
import net.tslat.aoa3.event.custom.events.PlayerLevelChangeEvent;
import net.tslat.aoa3.event.dynamic.DynamicEventSubscriber;
import net.tslat.aoa3.library.object.Text;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.ability.generic.ScalableModAbility;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.AttributeUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.RegistryUtil;

public class AttributeModification
extends ScalableModAbility {
    private final List<DynamicEventSubscriber<?>> eventSubscribers = List.of(this.listener(ApplyDynamicAttributeModifiersEvent.class, ApplyDynamicAttributeModifiersEvent::getEntity, this.serverOnly(this::applyAttributeModifiers)), this.listener(PlayerLevelChangeEvent.class, this.serverOnly(this::handleLevelChange)));
    private final Holder<Attribute> attribute;
    private AttributeModifier modifier;
    private float loginHealth = -1.0f;
    private int lastUpdateLevel = 0;

    public AttributeModification(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)AoAAbilities.ATTRIBUTE_MODIFICATION.get(), skill, data);
        this.attribute = AoARegistries.ENTITY_ATTRIBUTES.getHolder((ResourceLocation)ResourceLocation.read((String)GsonHelper.getAsString((JsonObject)data, (String)"attribute")).getOrThrow());
        this.modifier = new AttributeModifier(RegistryUtil.getId(this.type()).withSuffix(this.getUniqueIdentifier()), (double)this.getScaledValue(), (AttributeModifier.Operation)AttributeModifier.Operation.BY_ID.apply(GsonHelper.getAsInt((JsonObject)data, (String)"operation")));
    }

    public AttributeModification(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)AoAAbilities.ATTRIBUTE_MODIFICATION.get(), skill, data);
        this.attribute = AoARegistries.ENTITY_ATTRIBUTES.getHolder((ResourceLocation)ResourceLocation.read((String)data.getString("attribute")).getOrThrow());
        this.modifier = new AttributeModifier(RegistryUtil.getId(this.type()).withSuffix(this.getUniqueIdentifier()), (double)this.getScaledValue(), (AttributeModifier.Operation)AttributeModifier.Operation.BY_ID.apply(data.getInt("operation")));
    }

    protected AttributeModifier updateModifier() {
        this.modifier = new AttributeModifier(this.modifier.id(), (double)this.getScaledValue(), this.modifier.operation());
        if (!this.getPlayer().level().isClientSide) {
            if (this.isStillValid()) {
                this.applyAttributeModifiers(new ApplyDynamicAttributeModifiersEvent((LivingEntity)this.getPlayer()));
            }
            this.markForClientSync();
        }
        return this.modifier;
    }

    @Override
    protected void updateDescription(MutableComponent defaultDescription) {
        Object amount = "";
        String perLevel = "";
        switch (this.modifier.operation()) {
            case ADD_MULTIPLIED_BASE: 
            case ADD_MULTIPLIED_TOTAL: {
                if (this.baseValue != 0.0f) {
                    amount = "+" + NumberUtil.roundToNthDecimalPlace(this.baseValue * 100.0f, 3);
                }
                if (this.perLevelMod == 0.0f) break;
                perLevel = NumberUtil.roundToNthDecimalPlace(this.perLevelMod * 100.0f, 3);
                break;
            }
            default: {
                if (this.baseValue != 0.0f) {
                    amount = NumberUtil.roundToNthDecimalPlace(this.baseValue, 3);
                }
                if (this.perLevelMod == 0.0f) break;
                perLevel = NumberUtil.roundToNthDecimalPlace(this.perLevelMod, 3);
            }
        }
        super.updateDescription(Component.translatable((String)((TranslatableContents)defaultDescription.getContents()).getKey(), (Object[])new Object[]{Text.of(((Attribute)this.attribute.value()).getDescriptionId()), LocaleUtil.getAbilityValueDesc(this.baseValue != 0.0f, this.perLevelMod != 0.0f, this.modifier.operation() != AttributeModifier.Operation.ADD_VALUE, amount, perLevel, NumberUtil.roundToNthDecimalPlace((float)this.modifier.amount() * (float)(this.modifier.operation() == AttributeModifier.Operation.ADD_VALUE ? 1 : 100), 3))}));
    }

    @Override
    public MutableComponent getDescription() {
        if (this.skill.getLevel(true) != this.lastUpdateLevel) {
            this.lastUpdateLevel = this.skill.getLevel(true);
            this.updateDescription(Component.translatable((String)(Util.makeDescriptionId((String)"ability", (ResourceLocation)AoARegistries.AOA_ABILITIES.getKey(this.type())) + ".description")));
        }
        return super.getDescription();
    }

    public List<DynamicEventSubscriber<?>> getEventSubscribers() {
        return this.eventSubscribers;
    }

    private void applyAttributeModifiers(ApplyDynamicAttributeModifiersEvent ev) {
        ev.applyTransientModifier(this.attribute, this.modifier);
        if (this.loginHealth > 0.0f) {
            ev.getEntity().setHealth(this.loginHealth);
            this.loginHealth = -1.0f;
        }
    }

    @Override
    protected void onDisable() {
        super.onDisable();
        AttributeUtil.removeModifier((LivingEntity)this.getPlayer(), this.attribute, this.modifier.id());
    }

    private void handleLevelChange(PlayerLevelChangeEvent ev) {
        this.updateModifier();
    }

    @Override
    public CompoundTag getSyncData(boolean forClientSetup) {
        CompoundTag data = super.getSyncData(forClientSetup);
        if (forClientSetup) {
            data.putString("attribute", RegistryUtil.getId((Attribute)this.attribute.value()).toString());
            data.putInt("operation", this.modifier.operation().id());
        }
        return data;
    }

    @Override
    public CompoundTag saveToNbt() {
        CompoundTag data = super.saveToNbt();
        if (this.attribute == Attributes.MAX_HEALTH) {
            double health = this.getPlayer().getHealth();
            if (health == 0.0 && !this.getPlayer().isAlive()) {
                health = this.getPlayer().getMaxHealth();
            }
            if (health > 0.0) {
                data.putDouble("current_health", health);
            }
        }
        return data;
    }

    @Override
    public void receiveSyncData(CompoundTag data) {
        super.receiveSyncData(data);
        this.updateModifier();
    }

    @Override
    public void loadFromNbt(CompoundTag data) {
        super.loadFromNbt(data);
        this.updateModifier();
        if (this.attribute == Attributes.MAX_HEALTH && this.getListenerState() == AoAPlayerEventListener.ListenerState.ACTIVE && data.contains("current_health")) {
            if (this.getLevelReq() == 1) {
                this.loginHealth = (float)data.getDouble("current_health");
            } else {
                this.getPlayer().setHealth((float)data.getDouble("current_health"));
            }
        }
    }

    @Override
    protected void onReenable() {
        this.updateModifier();
    }
}

