/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability.farming;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.event.dynamic.DynamicEventSubscriber;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.WorldUtil;

public class HoeAreaHarvest
extends AoAAbility.Instance {
    private final List<DynamicEventSubscriber<?>> eventSubscribers = List.of(this.listener(PlayerInteractEvent.RightClickBlock.class, this.serverOnly(this::handleBlockInteraction)));
    private final int baseRadius;
    private final int levelsPerRadiusIncrease;
    private final int perBlockHoeDamage;

    public HoeAreaHarvest(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)AoAAbilities.HOE_AREA_HARVEST.get(), skill, data);
        this.baseRadius = GsonHelper.getAsInt((JsonObject)data, (String)"base_radius", (int)1);
        this.levelsPerRadiusIncrease = GsonHelper.getAsInt((JsonObject)data, (String)"levels_per_radius_increase", (int)0);
        this.perBlockHoeDamage = GsonHelper.getAsInt((JsonObject)data, (String)"per_block_hoe_damage", (int)1);
        if (this.baseRadius < 0) {
            throw new IllegalArgumentException("Invalid radius value for BlockConversion ability: '" + this.baseRadius + "'. Must be at least 0");
        }
    }

    public HoeAreaHarvest(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)AoAAbilities.HOE_AREA_HARVEST.get(), skill, data);
        this.baseRadius = data.getInt("base_radius");
        this.levelsPerRadiusIncrease = data.getInt("levels_per_radius_increase");
        this.perBlockHoeDamage = data.getInt("per_block_hoe_damage");
    }

    @Override
    protected void updateDescription(MutableComponent defaultDescription) {
        Object suffix = this.levelsPerRadiusIncrease > 0 ? "" : ".flat";
        suffix = (String)suffix + (this.perBlockHoeDamage <= 0 ? "" : ".noDamage");
        super.updateDescription(Component.translatable((String)(((TranslatableContents)defaultDescription.getContents()).getKey() + (String)suffix), (Object[])new Object[]{this.baseRadius, this.levelsPerRadiusIncrease, this.perBlockHoeDamage}));
    }

    public List<DynamicEventSubscriber<?>> getEventSubscribers() {
        return this.eventSubscribers;
    }

    private void handleBlockInteraction(PlayerInteractEvent.RightClickBlock ev) {
        Player player;
        ItemStack heldStack;
        if (ev.getLevel().getBlockState(ev.getPos()).is(BlockTags.CROPS) && (heldStack = (player = ev.getEntity()).getItemInHand(ev.getHand())).getItem() instanceof HoeItem) {
            int radius = this.levelsPerRadiusIncrease > 0 ? this.baseRadius + (this.skill.getLevel(false) - this.getLevelReq()) / this.levelsPerRadiusIncrease : this.baseRadius;
            Level world = ev.getLevel();
            BlockPos basePos = ev.getPos();
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    CropBlock crop;
                    BlockState state = world.getBlockState((BlockPos)pos.set(basePos.getX() + x, basePos.getY(), basePos.getZ() + z));
                    Block block = state.getBlock();
                    if (!(block instanceof CropBlock) || !(crop = (CropBlock)block).isMaxAge(state) || !WorldUtil.canModifyBlock((LevelAccessor)world, (BlockPos)pos, (Entity)player, heldStack)) continue;
                    WorldUtil.harvestAdditionalBlock(world, ev.getEntity(), pos.immutable(), true);
                    if (this.perBlockHoeDamage <= 0) continue;
                    ItemUtil.damageItemForUser(player, heldStack, this.perBlockHoeDamage, ev.getHand());
                    if (!heldStack.isEmpty()) continue;
                    return;
                }
            }
        }
    }

    @Override
    public CompoundTag getSyncData(boolean forClientSetup) {
        CompoundTag data = super.getSyncData(forClientSetup);
        if (forClientSetup) {
            data.putInt("base_radius", this.baseRadius);
            data.putInt("levels_per_radius_increase", this.levelsPerRadiusIncrease);
            data.putInt("per_block_hoe_damage", this.perBlockHoeDamage);
        }
        return data;
    }
}

