/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability.extraction;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.event.custom.events.PlayerSkillsLootModificationEvent;
import net.tslat.aoa3.event.dynamic.DynamicEventSubscriber;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.ability.generic.ScalableModAbility;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.player.skill.ExtractionSkill;
import net.tslat.aoa3.util.LootUtil;
import net.tslat.aoa3.util.PlayerUtil;

public class RareTableHarvestingChance
extends ScalableModAbility {
    private final List<DynamicEventSubscriber<?>> eventSubscribers = List.of(this.listener(PlayerSkillsLootModificationEvent.class, this.serverOnly(this::handleLootModification)));

    public RareTableHarvestingChance(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)AoAAbilities.RARE_TABLE_HARVESTING_CHANCE.get(), skill, data);
    }

    public RareTableHarvestingChance(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)AoAAbilities.RARE_TABLE_HARVESTING_CHANCE.get(), skill, data);
    }

    public List<DynamicEventSubscriber<?>> getEventSubscribers() {
        return this.eventSubscribers;
    }

    private void handleLootModification(PlayerSkillsLootModificationEvent ev) {
        if (!this.testAsChance()) {
            return;
        }
        LootContext context = ev.getLootContext();
        BlockState state = (BlockState)context.getParamOrNull(LootContextParams.BLOCK_STATE);
        if (state == null) {
            return;
        }
        Vec3 origin = (Vec3)context.getParamOrNull(LootContextParams.ORIGIN);
        if (origin == null) {
            return;
        }
        if (!Block.isShapeFullBlock((VoxelShape)state.getCollisionShape((BlockGetter)context.getLevel(), BlockPos.containing((Position)origin)))) {
            return;
        }
        if (!ExtractionSkill.isApplicableBlock(state)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)this.getPlayer();
        ServerLevel world = context.getLevel();
        ev.getGeneratedLoot().addAll(LootUtil.generateLoot(AdventOfAscension.id("misc/lotto_totem"), LootUtil.getGiftParameters(world, origin, player.getLuck(), (Entity)player)));
        PlayerUtil.giveXpToPlayer(player, this.getSkill().type(), PlayerUtil.getTimeBasedXpForLevel(PlayerUtil.getLevel((Player)player, this.getSkill().type()), 10.0f), false);
    }
}

