/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability.extraction;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.BlockGetter;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.event.dynamic.DynamicEventSubscriber;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.ability.generic.ScalableModAbility;
import net.tslat.aoa3.player.skill.AoASkill;

public class HardBlockSpeedIncrease
extends ScalableModAbility {
    private final List<DynamicEventSubscriber<?>> eventSubscribers = List.of(this.listener(PlayerEvent.BreakSpeed.class, this.serverOnly(this::handleHarvestSpeedCheck)));

    public HardBlockSpeedIncrease(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)AoAAbilities.HARD_BLOCK_SPEED_INCREASE.get(), skill, data);
    }

    public HardBlockSpeedIncrease(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)AoAAbilities.HARD_BLOCK_SPEED_INCREASE.get(), skill, data);
    }

    public List<DynamicEventSubscriber<?>> getEventSubscribers() {
        return this.eventSubscribers;
    }

    private void handleHarvestSpeedCheck(PlayerEvent.BreakSpeed ev) {
        if (ev.getPosition().isEmpty()) {
            return;
        }
        float hardness = ev.getState().getDestroySpeed((BlockGetter)ev.getEntity().level(), (BlockPos)ev.getPosition().get());
        if (hardness > 2.0f) {
            ev.setNewSpeed(ev.getNewSpeed() * (1.0f + this.getScaledValue() * ((hardness - 2.0f) / 48.0f)));
        }
    }
}

