/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability.dexterity;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.tslat.aoa3.common.networking.AoANetworking;
import net.tslat.aoa3.common.networking.packets.UpdateClientMovementPacket;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.event.custom.events.PlayerLevelChangeEvent;
import net.tslat.aoa3.event.dynamic.DynamicEventSubscriber;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.ability.generic.ScalableModAbility;
import net.tslat.aoa3.player.skill.AoASkill;

public class JumpBoost
extends ScalableModAbility {
    private final List<DynamicEventSubscriber<?>> eventSubscribers = List.of(this.listener(LivingFallEvent.class, LivingEvent::getEntity, this.serverOnly(this::handlePlayerFall)), this.listener(LivingEvent.LivingJumpEvent.class, LivingEvent::getEntity, this.serverOnly(this::handlePlayerJump)), this.listener(PlayerLevelChangeEvent.class, this.serverOnly(this::handleLevelChange)));
    private final boolean sprintJumpBoost;
    private double baseBoostMultiplier;
    private double launchMultiplier;

    public JumpBoost(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)AoAAbilities.JUMP_BOOST.get(), skill, data);
        this.sprintJumpBoost = GsonHelper.getAsBoolean((JsonObject)data, (String)"amplify_lateral_velocity", (boolean)false);
        this.updateMultipliers();
    }

    public JumpBoost(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)AoAAbilities.JUMP_BOOST.get(), skill, data);
        this.sprintJumpBoost = data.getBoolean("amplify_lateral_velocity");
    }

    @Override
    protected void updateDescription(MutableComponent defaultDescription) {
        super.updateDescription(Component.translatable((String)(((TranslatableContents)defaultDescription.getContents()).getKey() + (this.sprintJumpBoost ? ".lateral" : ".vertical")), (Object[])new Object[]{this.getScalingDescriptionComponent(2)}));
    }

    public List<DynamicEventSubscriber<?>> getEventSubscribers() {
        return this.eventSubscribers;
    }

    private void updateMultipliers() {
        this.baseBoostMultiplier = 1.0f + this.getScaledValue();
        this.launchMultiplier = -8.0E-4 * Math.pow(this.baseBoostMultiplier, 4.0) + 0.00332 * Math.pow(this.baseBoostMultiplier, 3.0) - 0.05499 * Math.pow(this.baseBoostMultiplier, 2.0) + 0.62043 * this.baseBoostMultiplier + 0.27697;
    }

    private void handleLevelChange(PlayerLevelChangeEvent ev) {
        this.updateMultipliers();
    }

    private void handlePlayerJump(LivingEvent.LivingJumpEvent ev) {
        Vec3 newMotion;
        LivingEntity entity = ev.getEntity();
        Vec3 oldMotion = entity.getDeltaMovement();
        if (!this.sprintJumpBoost) {
            newMotion = oldMotion.multiply(1.0, this.launchMultiplier / 1.02040814340536, 1.0);
            AoANetworking.sendToPlayer((ServerPlayer)this.getPlayer(), new UpdateClientMovementPacket(UpdateClientMovementPacket.Operation.SET, oldMotion.y() * this.launchMultiplier / 1.02040814340536));
        } else {
            newMotion = oldMotion.multiply(this.baseBoostMultiplier, 1.0, this.baseBoostMultiplier);
            AoANetworking.sendToPlayer((ServerPlayer)this.getPlayer(), new UpdateClientMovementPacket(UpdateClientMovementPacket.Operation.MULTIPLY, this.baseBoostMultiplier, this.baseBoostMultiplier));
        }
        entity.setDeltaMovement(newMotion);
    }

    private void handlePlayerFall(LivingFallEvent ev) {
        if ((double)ev.getDistance() - this.launchMultiplier * 0.75 < 3.0) {
            ev.setCanceled(true);
        }
    }

    @Override
    public void loadFromNbt(CompoundTag data) {
        super.loadFromNbt(data);
        this.updateMultipliers();
    }

    @Override
    public CompoundTag getSyncData(boolean forClientSetup) {
        CompoundTag data = super.getSyncData(forClientSetup);
        if (forClientSetup) {
            data.putBoolean("amplify_lateral_velocity", this.sprintJumpBoost);
        }
        return data;
    }
}

