/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability.dexterity;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.event.dynamic.DynamicEventSubscriber;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.ability.generic.ScalableModAbility;
import net.tslat.aoa3.player.skill.AoASkill;

public class FallDamageReduction
extends ScalableModAbility {
    private final List<DynamicEventSubscriber<?>> eventSubscribers = List.of(this.listener(LivingFallEvent.class, LivingEvent::getEntity, this.serverOnly(this::handlePlayerFall)));
    private final int minHeight;
    private final int maxHeight;

    public FallDamageReduction(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)AoAAbilities.FALL_DAMAGE_REDUCTION.get(), skill, data);
        this.minHeight = GsonHelper.getAsInt((JsonObject)data, (String)"min_height", (int)0);
        this.maxHeight = GsonHelper.getAsInt((JsonObject)data, (String)"max_height", (int)Integer.MAX_VALUE);
    }

    public FallDamageReduction(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)AoAAbilities.FALL_DAMAGE_REDUCTION.get(), skill, data);
        this.minHeight = data.getInt("min_height");
        this.maxHeight = data.getInt("max_height");
    }

    @Override
    protected void updateDescription(MutableComponent defaultDescription) {
        Object key = ((TranslatableContents)defaultDescription.getContents()).getKey();
        if (this.minHeight > 0) {
            if (this.maxHeight == Integer.MAX_VALUE) {
                key = (String)key + ".min";
            }
        } else if (this.maxHeight < Integer.MAX_VALUE) {
            key = (String)key + ".max";
        }
        super.updateDescription(Component.translatable((String)key, (Object[])new Object[]{this.minHeight - 1, this.maxHeight, this.getScalingDescriptionComponent(2)}));
    }

    public List<DynamicEventSubscriber<?>> getEventSubscribers() {
        return this.eventSubscribers;
    }

    private void handlePlayerFall(LivingFallEvent ev) {
        if (ev.getDistance() >= (float)this.minHeight && ev.getDistance() <= (float)this.maxHeight) {
            ev.setDamageMultiplier(Math.max(0.0f, ev.getDamageMultiplier() * (1.0f - Math.min(1.0f, this.getScaledValue()))));
            if (Mth.ceil((float)((ev.getDistance() - 3.0f) * ev.getDamageMultiplier())) < 1) {
                ev.setDamageMultiplier(0.0f);
            }
        }
    }

    @Override
    public CompoundTag getSyncData(boolean forClientSetup) {
        CompoundTag data = super.getSyncData(forClientSetup);
        if (forClientSetup) {
            data.putInt("min_height", this.minHeight);
            data.putInt("max_height", this.maxHeight);
        }
        return data;
    }
}

