/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability.dexterity;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.tslat.aoa3.client.player.AoAPlayerKeybindListener;
import net.tslat.aoa3.common.networking.AoANetworking;
import net.tslat.aoa3.common.networking.packets.UpdateClientMovementPacket;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.common.registration.custom.AoAResources;
import net.tslat.aoa3.event.dynamic.DynamicEventSubscriber;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.PlayerUtil;

public class DoubleJump
extends AoAAbility.Instance {
    private final List<DynamicEventSubscriber<?>> eventSubscribers = List.of(this.listener(LivingFallEvent.class, LivingEvent::getEntity, this.serverOnly(this::handlePlayerFall)));
    private final float energyConsumption;
    private boolean canJump = true;

    public DoubleJump(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)AoAAbilities.DOUBLE_JUMP.get(), skill, data);
        this.energyConsumption = Math.max(0.0f, GsonHelper.getAsFloat((JsonObject)data, (String)"energy_consumption"));
    }

    public DoubleJump(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)AoAAbilities.DOUBLE_JUMP.get(), skill, data);
        this.energyConsumption = data.getFloat("energy_consumption");
    }

    @Override
    protected void updateDescription(MutableComponent defaultDescription) {
        super.updateDescription(Component.translatable((String)((TranslatableContents)defaultDescription.getContents()).getKey(), (Object[])new Object[]{NumberUtil.roundToNthDecimalPlace(this.energyConsumption, 2)}));
    }

    public List<DynamicEventSubscriber<?>> getEventSubscribers() {
        return this.eventSubscribers;
    }

    @Override
    public void createKeybindListener(Consumer<AoAPlayerKeybindListener> consumer) {
        consumer.accept(new AoAPlayerKeybindListener(){

            @Override
            public AoAPlayerEventListener getEventListener() {
                return DoubleJump.this;
            }

            @Override
            public int getKeycode() {
                return Minecraft.getInstance().options.keyJump.getKey().getValue();
            }

            @Override
            public boolean shouldSendKeyPress() {
                Player player = DoubleJump.this.getPlayer();
                if (player.onGround() || player.jumpTriggerTime > 0) {
                    return false;
                }
                if (player.getItemBySlot(EquipmentSlot.CHEST).canElytraFly((LivingEntity)player)) {
                    return false;
                }
                if (!player.getAbilities().mayfly) {
                    player.jumpTriggerTime = 7;
                }
                return true;
            }
        });
    }

    @Override
    public void handleKeyInput() {
        Player player = this.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (this.canJump || player2.isCreative()) {
                if (player2.onGround()) {
                    return;
                }
                if (this.consumeResource((AoAResource)AoAResources.ENERGY.get(), this.energyConsumption, true)) {
                    this.canJump = false;
                    player2.jumpFromGround();
                    AoANetworking.sendToPlayer(player2, new UpdateClientMovementPacket(UpdateClientMovementPacket.Operation.SET, player2.getDeltaMovement().y()));
                    if (this.getSkill().canGainXp(true)) {
                        PlayerUtil.giveTimeBasedXpToPlayer(player2, this.getSkill().type(), 16, false);
                    }
                }
            }
        }
    }

    private void handlePlayerFall(LivingFallEvent ev) {
        if (!this.canJump) {
            ev.setDistance(ev.getDistance() - ev.getEntity().getJumpPower() * 10.0f);
        }
        this.canJump = true;
    }

    @Override
    public CompoundTag getSyncData(boolean forClientSetup) {
        CompoundTag syncData = super.getSyncData(forClientSetup);
        if (forClientSetup) {
            syncData.putFloat("energy_consumption", this.energyConsumption);
        }
        return syncData;
    }
}

