/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability;

import com.google.common.base.Suppliers;
import com.google.gson.JsonObject;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.event.custom.events.ApplyDynamicAttributeModifiersEvent;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.player.skill.AoASkill;

public class AoAAbility {
    private final Supplier<MutableComponent> name = Suppliers.memoize(() -> Component.translatable((String)Util.makeDescriptionId((String)"ability", (ResourceLocation)AoARegistries.AOA_ABILITIES.getKey(this))));
    private final BiFunction<AoASkill.Instance, JsonObject, Instance> jsonFactory;
    private final BiFunction<AoASkill.Instance, CompoundTag, Instance> nbtFactory;

    public AoAAbility(BiFunction<AoASkill.Instance, JsonObject, Instance> jsonFactory, BiFunction<AoASkill.Instance, CompoundTag, Instance> nbtFactory) {
        this.jsonFactory = jsonFactory;
        this.nbtFactory = nbtFactory;
    }

    public MutableComponent getName() {
        return this.name.get();
    }

    public Instance create(AoASkill.Instance skillInstance, JsonObject abilityData) {
        return this.jsonFactory.apply(skillInstance, abilityData);
    }

    public Instance loadFromNbt(AoASkill.Instance skillInstance, CompoundTag abilityData) {
        return this.nbtFactory.apply(skillInstance, abilityData);
    }

    public static abstract class Instance
    implements AoAPlayerEventListener {
        private final AoAAbility ability;
        protected AoASkill.Instance skill;
        private final int levelReq;
        private final String uniqueIdentifier;
        private MutableComponent description;
        public boolean needsSync = true;
        private AoAPlayerEventListener.ListenerState state;

        public Instance(AoAAbility ability, AoASkill.Instance skill, JsonObject data) {
            this.skill = skill;
            this.ability = ability;
            this.uniqueIdentifier = GsonHelper.getAsString((JsonObject)data, (String)"unique_id");
            this.levelReq = GsonHelper.getAsInt((JsonObject)data, (String)"level_req");
            this.state = AoAPlayerEventListener.ListenerState.fromId(GsonHelper.getAsString((JsonObject)data, (String)"state", (String)AoAPlayerEventListener.ListenerState.ACTIVE.getId()));
            this.description = data.has("description") ? Component.translatable((String)GsonHelper.getAsString((JsonObject)data, (String)"description")) : null;
            this.checkDeactivation(true, false);
        }

        public Instance(AoAAbility ability, AoASkill.Instance skill, CompoundTag data) {
            this.skill = skill;
            this.ability = ability;
            this.uniqueIdentifier = data.getString("unique_identifier");
            this.levelReq = data.getInt("level_req");
            this.state = AoAPlayerEventListener.ListenerState.fromId(data.getString("state"));
            this.description = data.contains("description") ? Component.translatable((String)data.getString("description")) : null;
        }

        protected void updateDescription(MutableComponent defaultDescription) {
            this.description = defaultDescription;
        }

        public AoAAbility type() {
            return this.ability;
        }

        public MutableComponent getName() {
            return this.type().getName();
        }

        public MutableComponent getDescription() {
            if (this.description == null) {
                this.updateDescription(Component.translatable((String)(Util.makeDescriptionId((String)"ability", (ResourceLocation)AoARegistries.AOA_ABILITIES.getKey(this.type())) + ".description")));
            }
            return this.description;
        }

        public String getUniqueIdentifier() {
            return this.uniqueIdentifier;
        }

        public int getLevelReq() {
            return this.levelReq;
        }

        public AoASkill.Instance getSkill() {
            return this.skill;
        }

        @Override
        public boolean isStillValid() {
            return AoAPlayerEventListener.super.isStillValid() && this.getSkill().isStillValid();
        }

        @Override
        public final void reenable(boolean isInit) {
            if (this.skill.hasLevel(this.getLevelReq())) {
                this.state = AoAPlayerEventListener.ListenerState.ACTIVE;
                if (!isInit) {
                    this.onReenable();
                }
                this.markForClientSync();
                this.registerEventSubscribers();
            }
        }

        @Override
        public final void disable(AoAPlayerEventListener.ListenerState reason, boolean isInit) {
            this.state = reason;
            if (!isInit) {
                this.onDisable();
            }
            if (reason != AoAPlayerEventListener.ListenerState.REMOVED) {
                this.markForClientSync();
            }
        }

        protected void onReenable() {
            this.getEventSubscriber(ApplyDynamicAttributeModifiersEvent.class).ifPresent(handler -> handler.accept(new ApplyDynamicAttributeModifiersEvent((LivingEntity)this.getPlayer())));
        }

        protected void onDisable() {
        }

        protected void markForClientSync() {
            this.needsSync = true;
            this.skill.needsSync = true;
        }

        @Override
        public AoAPlayerEventListener.ListenerState getListenerState() {
            return this.state;
        }

        @Override
        public Player getPlayer() {
            return this.skill.getPlayer();
        }

        protected boolean consumeResource(AoAResource resource, float amount, boolean consumeIfInsufficient) {
            return this.skill.getPlayerDataManager().getResource(resource).consume(amount, consumeIfInsufficient);
        }

        @Override
        public boolean meetsRequirements() {
            return this.skill.hasLevel(this.getLevelReq());
        }

        public void checkDeactivation(boolean isInit, boolean stateChanged) {
            if (this.state == AoAPlayerEventListener.ListenerState.ACTIVE) {
                if (!this.skill.hasLevel(this.levelReq)) {
                    this.disable(AoAPlayerEventListener.ListenerState.DEACTIVATED, isInit);
                } else if (stateChanged) {
                    this.reenable(isInit);
                }
            } else if (this.state == AoAPlayerEventListener.ListenerState.DEACTIVATED) {
                if (this.skill.hasLevel(this.levelReq)) {
                    this.reenable(isInit);
                } else {
                    this.disable(this.state, isInit);
                }
            }
        }

        public CompoundTag saveToNbt() {
            CompoundTag data = new CompoundTag();
            data.putString("state", this.state.getId());
            return data;
        }

        public void loadFromNbt(CompoundTag data) {
            AoAPlayerEventListener.ListenerState prevState = this.state;
            this.state = AoAPlayerEventListener.ListenerState.fromId(data.getString("state"));
            this.checkDeactivation(false, prevState != this.state);
        }

        public CompoundTag getSyncData(boolean forClientSetup) {
            CompoundTag data = new CompoundTag();
            data.putString("state", this.state.getId());
            if (forClientSetup) {
                data.putString("id", AoARegistries.AOA_ABILITIES.getKey(this.type()).toString());
                data.putString("unique_identifier", this.uniqueIdentifier);
                data.putInt("level_req", this.levelReq);
                if (this.description != null) {
                    data.putString("description", ((TranslatableContents)this.description.getContents()).getKey());
                }
            }
            return data;
        }

        public void receiveSyncData(CompoundTag data) {
            this.state = AoAPlayerEventListener.ListenerState.fromId(data.getString("state"));
        }

        public void receiveInteractionDataFromClient(String data) {
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean onGuiClick(int mouseX, int mouseY) {
            return this.getListenerState() == AoAPlayerEventListener.ListenerState.ACTIVE || this.getListenerState() == AoAPlayerEventListener.ListenerState.MANUALLY_DISABLED;
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean onGuiHover(int mouseX, int mouseY) {
            return this.getListenerState() == AoAPlayerEventListener.ListenerState.ACTIVE || this.getListenerState() == AoAPlayerEventListener.ListenerState.MANUALLY_DISABLED;
        }
    }
}

