/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player;

import com.google.common.base.Suppliers;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityEvent;
import net.neoforged.neoforge.event.entity.EntityInvulnerabilityCheckEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingEquipmentChangeEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.common.networking.AoANetworking;
import net.tslat.aoa3.common.networking.packets.adventplayer.PlayerDataSyncPacket;
import net.tslat.aoa3.common.networking.packets.adventplayer.PlayerDataUpdatePacket;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.common.registration.custom.AoAResources;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.common.registration.item.AoAEnchantments;
import net.tslat.aoa3.common.toast.AbilityUnlockToastData;
import net.tslat.aoa3.content.item.armour.AdventArmour;
import net.tslat.aoa3.data.server.AoAResourcesReloadListener;
import net.tslat.aoa3.data.server.AoASkillReqReloadListener;
import net.tslat.aoa3.data.server.AoASkillsReloadListener;
import net.tslat.aoa3.event.custom.events.PlayerLevelChangeEvent;
import net.tslat.aoa3.event.dynamic.DynamicEventSubscriber;
import net.tslat.aoa3.integration.IntegrationManager;
import net.tslat.aoa3.leaderboard.SkillsLeaderboard;
import net.tslat.aoa3.leaderboard.task.LeaderboardActions;
import net.tslat.aoa3.library.object.PartialNbtSerializable;
import net.tslat.aoa3.library.object.PositionAndRotation;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.PlayerDataManager;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.AdvancementUtil;
import net.tslat.aoa3.util.EnchantmentUtil;
import net.tslat.aoa3.util.InventoryUtil;
import net.tslat.aoa3.util.ObjectUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.aoa3.util.RegistryUtil;
import net.tslat.smartbrainlib.util.RandomUtil;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ServerPlayerDataManager
implements AoAPlayerEventListener,
PlayerDataManager,
PartialNbtSerializable {
    private final WeakReference<ServerPlayer> player;
    public final Equipment equipment;
    public final Stats stats;
    public final Storage storage;
    private final ObjectArrayList<WeakReference<AoAPlayerEventListener>> eventListeners = new ObjectArrayList();
    private final List<DynamicEventSubscriber<?>> eventSubscribers = List.of(this.listener(LivingDeathEvent.class, LivingEvent::getEntity, this::handlePlayerDeath), this.listener(PlayerEvent.PlayerRespawnEvent.class, this::handlePlayerRespawn), this.listener(PlayerLevelChangeEvent.class, this::handleLevelChange), this.listener(PlayerTickEvent.Pre.class, this::handlePlayerTick));

    public ServerPlayerDataManager(ServerPlayer player) {
        this.player = new WeakReference<ServerPlayer>(player);
        this.equipment = new Equipment();
        this.stats = new Stats();
        this.storage = new Storage();
        this.gatherListeners();
    }

    public ServerPlayer getPlayer() {
        return (ServerPlayer)this.player.get();
    }

    @Override
    public boolean isStillValid() {
        return this.getPlayer() != null && !this.getPlayer().isRemoved();
    }

    @Override
    public Collection<AoASkill.Instance> getSkills() {
        return this.stats.getSkills();
    }

    @Override
    @NotNull
    public AoASkill.Instance getSkill(AoASkill skill) {
        return this.stats.getSkill(skill);
    }

    @Override
    @Nullable
    public AoAAbility.Instance getAbility(String abilityId) {
        return this.stats.getAbility(abilityId);
    }

    @Override
    public Collection<AoAResource.Instance> getResources() {
        return this.stats.getResources();
    }

    @Override
    @NotNull
    public AoAResource.Instance getResource(AoAResource resource) {
        return this.stats.getResource(resource);
    }

    @Override
    public void load(CompoundTag nbt, HolderLookup.Provider holderLookup, boolean isPartial) {
        this.stats.load(nbt, holderLookup, isPartial);
        this.storage.load(nbt, holderLookup, isPartial);
        int hash = nbt.getInt("hash");
        if (hash == 0) {
            this.applyLegitimacyPenalties();
        } else {
            nbt.remove("hash");
            if (hash != nbt.hashCode()) {
                this.applyLegitimacyPenalties();
            }
            nbt.putInt("hash", nbt.hashCode());
        }
        this.checkAndUpdateLegitimacy();
    }

    @Override
    public void save(CompoundTag nbt, HolderLookup.Provider holderLookup, boolean isPartial) {
        this.stats.save(nbt, holderLookup, isPartial);
        this.storage.save(nbt, holderLookup, isPartial);
        nbt.putInt("hash", nbt.hashCode());
    }

    @Override
    public void addEventListener(AoAPlayerEventListener listener) {
        this.eventListeners.add(new WeakReference<AoAPlayerEventListener>(listener));
        listener.registerEventSubscribers();
    }

    @Override
    public List<DynamicEventSubscriber<? extends Event>> getEventSubscribers() {
        return this.eventSubscribers;
    }

    private void gatherListeners() {
        this.registerEventSubscribers();
        this.equipment.registerEventSubscribers();
        this.stats.registerEventSubscribers();
    }

    public void syncNewPlayer() {
        if (SkillsLeaderboard.isEnabled()) {
            LeaderboardActions.addNewPlayer(this);
        }
        CompoundTag data = new CompoundTag();
        this.save(data, (HolderLookup.Provider)this.getPlayer().level().registryAccess(), true);
        AoANetworking.sendToPlayer(this.getPlayer(), new PlayerDataSyncPacket(data));
    }

    private void handlePlayerTick(PlayerTickEvent.Pre ev) {
        if (this.getPlayer() == null || this.getPlayer().isSpectator()) {
            return;
        }
        com.google.common.base.Supplier syncData = Suppliers.memoize(CompoundTag::new);
        boolean sync = this.stats.getSyncData((Supplier<CompoundTag>)syncData);
        if (sync |= this.storage.getSyncData((Supplier<CompoundTag>)syncData)) {
            AoANetworking.sendToPlayer(this.getPlayer(), new PlayerDataUpdatePacket((CompoundTag)syncData.get()));
        }
    }

    public void storeInventoryContents() {
        this.storage.putItemsInStorage(stack -> true);
    }

    private void handlePlayerDeath(LivingDeathEvent ev) {
        ServerLevel level = this.getPlayer().serverLevel();
        this.storage.putItemsInStorage(stack -> {
            if (stack.isEmpty() || !EnchantmentUtil.hasEnchantment((net.minecraft.world.level.Level)level, stack, AoAEnchantments.INTERVENTION)) {
                return false;
            }
            if (RandomUtil.oneInNChance((int)5)) {
                EnchantmentUtil.removeEnchantment((net.minecraft.world.level.Level)level, stack, AoAEnchantments.INTERVENTION);
            }
            return true;
        });
    }

    private void handlePlayerRespawn(PlayerEvent.PlayerRespawnEvent ev) {
        this.storage.returnStoredItems();
    }

    private void handleLevelChange(PlayerLevelChangeEvent ev) {
        if (SkillsLeaderboard.isEnabled()) {
            LeaderboardActions.updatePlayer(this, ev.getSkill());
        }
        if (!this.stats.areAbilitiesRegionLocked()) {
            this.checkAndUpdateListeners();
        }
    }

    private void checkAndUpdateListeners() {
        for (WeakReference ref : this.eventListeners) {
            AoAPlayerEventListener listener = (AoAPlayerEventListener)ref.get();
            AoAPlayerEventListener.ListenerState state = listener.getListenerState();
            if (state == AoAPlayerEventListener.ListenerState.ACTIVE) {
                if (listener.meetsRequirements()) continue;
                listener.disable(AoAPlayerEventListener.ListenerState.DEACTIVATED, false);
                continue;
            }
            if (state != AoAPlayerEventListener.ListenerState.DEACTIVATED && (state != AoAPlayerEventListener.ListenerState.REGION_LOCKED || this.stats.areAbilitiesRegionLocked()) || !listener.meetsRequirements()) continue;
            listener.reenable(false);
            if (state != AoAPlayerEventListener.ListenerState.DEACTIVATED || !(listener instanceof AoAAbility.Instance)) continue;
            AoAAbility.Instance ability = (AoAAbility.Instance)listener;
            AbilityUnlockToastData.sendToastPopupTo(this.getPlayer(), ability);
        }
    }

    public void checkAndUpdateLegitimacy() {
        if (this.player != null) {
            AdvancementUtil.getAdvancement(this.getPlayer().serverLevel(), AdventOfAscension.id("completionist/by_the_books")).ifPresent(adv -> {
                PlayerAdvancements plAdv = this.getPlayer().getAdvancements();
                boolean hasAdvancement = plAdv.getOrStartProgress(adv).isDone();
                if (hasAdvancement && !this.stats.isLegitimate()) {
                    plAdv.revoke(adv, "legitimate");
                }
            });
        }
    }

    public void applyLegitimacyPenalties() {
        this.stats.isLegitimate = false;
        this.checkAndUpdateLegitimacy();
    }

    @Override
    public boolean isLegitimate() {
        return this.stats.isLegitimate();
    }

    @Override
    public int getTotalLevel() {
        return this.stats.getTotalLevel();
    }

    public static void handlePlayerDataClone(PlayerEvent.Clone ev) {
        ServerPlayerDataManager newData = PlayerUtil.getAdventPlayer((ServerPlayer)ev.getEntity());
        ServerPlayerDataManager sourceData = PlayerUtil.getAdventPlayer((ServerPlayer)ev.getOriginal());
        newData.stats.clone(sourceData.stats);
        newData.storage.clone(sourceData.storage);
    }

    static {
        NeoForge.EVENT_BUS.addListener(PlayerEvent.Clone.class, ServerPlayerDataManager::handlePlayerDataClone);
    }

    public final class Equipment
    implements AoAPlayerEventListener {
        private final Map<Holder<ArmorMaterial>, AdventArmourSetContainer> equippedByMaterial = new Object2ObjectOpenHashMap(4);
        private final EnumMap<AdventArmour.Piece, AdventArmour> equippedByPiece = new EnumMap(AdventArmour.Piece.class);
        private final List<DynamicEventSubscriber<?>> eventSubscribers = List.of(this.listener(LivingEquipmentChangeEvent.class, LivingEvent::getEntity, this.serverOnly(this::handleArmourChange)), this.listener(PlayerTickEvent.Pre.class, this.serverOnly(this::handlePlayerTick)), this.listener(EntityInvulnerabilityCheckEvent.class, EntityEvent::getEntity, this.serverOnly(this::handleEntityInvulnerability)), this.listener(MobEffectEvent.Applicable.class, LivingEvent::getEntity, this.serverOnly(this::handleEffectApplicability)), this.listener(LivingDamageEvent.Pre.class, LivingEvent::getEntity, this.serverOnly(this::handlePreDamageApplication)), this.whenTakingDamage(this.serverOnly(this::handleIncomingDamage)), this.afterTakingDamage(this.serverOnly(this::handleAfterDamaged)), this.whenAttacking(this.serverOnly(this::handleOutgoingAttack)), this.afterAttacking(this.serverOnly(this::handleAfterAttacking)), this.listener(LivingDeathEvent.class, LivingEvent::getEntity, this.serverOnly(this::handlePlayerDeath)));
        private boolean checkNewArmour = false;

        private Equipment() {
        }

        @Override
        public Player getPlayer() {
            return ServerPlayerDataManager.this.getPlayer();
        }

        @Override
        public boolean isStillValid() {
            return ServerPlayerDataManager.this.isStillValid();
        }

        @Override
        public List<DynamicEventSubscriber<? extends Event>> getEventSubscribers() {
            return this.eventSubscribers;
        }

        @Nullable
        public Holder<ArmorMaterial> getCurrentFullArmourSet() {
            AdventArmour setArmour = this.equippedByPiece.get((Object)AdventArmour.Piece.FULL_SET);
            return setArmour != null ? setArmour.getMaterial() : null;
        }

        private void handleEntityInvulnerability(EntityInvulnerabilityCheckEvent ev) {
            for (AdventArmourSetContainer wrapper : this.equippedByMaterial.values()) {
                wrapper.armour.checkDamageInvulnerability((LivingEntity)this.getPlayer(), wrapper.equippedPieces(), ev);
            }
        }

        private void handleIncomingDamage(LivingIncomingDamageEvent ev) {
            for (AdventArmourSetContainer wrapper : this.equippedByMaterial.values()) {
                wrapper.armour.handleIncomingDamage((LivingEntity)this.getPlayer(), wrapper.equippedPieces(), ev);
            }
        }

        private void handleOutgoingAttack(LivingIncomingDamageEvent ev) {
            for (AdventArmourSetContainer wrapper : this.equippedByMaterial.values()) {
                wrapper.armour.handleOutgoingAttack((LivingEntity)this.getPlayer(), wrapper.equippedPieces(), ev);
            }
        }

        private void handlePreDamageApplication(LivingDamageEvent.Pre ev) {
            for (AdventArmourSetContainer wrapper : this.equippedByMaterial.values()) {
                wrapper.armour.beforeTakingDamage((LivingEntity)this.getPlayer(), wrapper.equippedPieces(), ev);
            }
        }

        private void handleAfterDamaged(LivingDamageEvent.Post ev) {
            for (AdventArmourSetContainer wrapper : this.equippedByMaterial.values()) {
                wrapper.armour.afterTakingDamage((LivingEntity)this.getPlayer(), wrapper.equippedPieces(), ev);
            }
        }

        private void handleAfterAttacking(LivingDamageEvent.Post ev) {
            for (AdventArmourSetContainer wrapper : this.equippedByMaterial.values()) {
                wrapper.armour.afterOutgoingAttack((LivingEntity)this.getPlayer(), wrapper.equippedPieces(), ev);
            }
        }

        private void handlePlayerDeath(LivingDeathEvent ev) {
            for (AdventArmourSetContainer wrapper : this.equippedByMaterial.values()) {
                wrapper.armour.onEntityDeath((LivingEntity)this.getPlayer(), wrapper.equippedPieces(), ev);
            }
        }

        private void handleArmourChange(LivingEquipmentChangeEvent ev) {
            if (ev.getSlot().isArmor()) {
                this.checkNewArmour = true;
            }
        }

        private void handleEffectApplicability(MobEffectEvent.Applicable ev) {
            for (AdventArmourSetContainer wrapper : this.equippedByMaterial.values()) {
                wrapper.armour.onEffectApplication((LivingEntity)this.getPlayer(), wrapper.equippedPieces(), ev);
            }
        }

        private void handlePlayerTick(PlayerTickEvent.Pre ev) {
            if (!this.getPlayer().isAlive() || this.getPlayer().isSpectator()) {
                return;
            }
            if (this.checkNewArmour) {
                this.checkNewArmour();
            }
            if (!this.checkEquippedItems()) {
                return;
            }
            for (AdventArmourSetContainer container : this.equippedByMaterial.values()) {
                container.armour().onArmourTick((LivingEntity)this.getPlayer(), container.equippedPieces());
            }
        }

        private void checkNewArmour() {
            boolean armourChanged = false;
            for (AdventArmour.Piece piece : AdventArmour.Piece.values()) {
                AdventArmour adventArmour;
                Item wornItem;
                AdventArmour existingArmour;
                EquipmentSlot slot = piece.toVanillaSlot();
                if (slot == null || (existingArmour = this.equippedByPiece.get((Object)piece)) == (wornItem = this.getPlayer().getItemBySlot(slot).getItem())) continue;
                armourChanged = true;
                if (existingArmour != null) {
                    this.unequipAdventArmour(existingArmour, piece);
                }
                AdventArmour newArmour = wornItem instanceof AdventArmour ? (adventArmour = (AdventArmour)wornItem) : null;
                this.equippedByPiece.put(piece, newArmour);
                if (newArmour == null || !this.getPlayer().getAbilities().instabuild && !AoASkillReqReloadListener.canEquip(ServerPlayerDataManager.this, (Item)newArmour, false)) continue;
                this.equipAdventArmour(newArmour, piece);
            }
            if (armourChanged) {
                AdventArmour oldSet = this.equippedByPiece.remove((Object)AdventArmour.Piece.FULL_SET);
                AdventArmour newSet = null;
                if (ObjectUtil.allEquivalent((piece1, piece2) -> piece1 != null && piece2 != null && (piece1.getMaterial().is(piece2.getMaterial()) || piece1.isCompatibleWithAnySet() || piece2.isCompatibleWithAnySet()), this.equippedByPiece.values().toArray(new AdventArmour[0]))) {
                    for (AdventArmour armour : this.equippedByPiece.values()) {
                        if (armour.isCompatibleWithAnySet()) continue;
                        newSet = armour;
                        break;
                    }
                }
                if (newSet != null) {
                    this.equippedByPiece.put(AdventArmour.Piece.FULL_SET, newSet);
                }
                if (newSet != oldSet) {
                    if (oldSet != null) {
                        this.unequipAdventArmour(oldSet, AdventArmour.Piece.FULL_SET);
                    }
                    if (newSet != null) {
                        this.equipAdventArmour(newSet, AdventArmour.Piece.FULL_SET);
                    }
                }
            }
        }

        private boolean checkEquippedItems() {
            if (this.getPlayer().getAbilities().instabuild) {
                return true;
            }
            boolean updateInventory = false;
            boolean doArmourTick = true;
            for (InteractionHand interactionHand : InteractionHand.values()) {
                ItemStack heldStack = this.getPlayer().getItemInHand(interactionHand);
                if (AoASkillReqReloadListener.canEquip(ServerPlayerDataManager.this, heldStack.getItem(), true)) continue;
                updateInventory = true;
                ItemHandlerHelper.giveItemToPlayer((Player)this.getPlayer(), (ItemStack)heldStack);
                this.getPlayer().setItemInHand(interactionHand, ItemStack.EMPTY);
            }
            for (AdventArmour.Piece piece : AdventArmour.Piece.values()) {
                AdventArmour armour;
                if (piece == AdventArmour.Piece.FULL_SET || (armour = this.equippedByPiece.get((Object)piece)) == null || AoASkillReqReloadListener.canEquip(ServerPlayerDataManager.this, (Item)armour, true)) continue;
                updateInventory = true;
                doArmourTick = false;
                EquipmentSlot slot = armour.getEquipmentSlot();
                ItemHandlerHelper.giveItemToPlayer((Player)this.getPlayer(), (ItemStack)this.getPlayer().getItemBySlot(slot));
                this.getPlayer().setItemSlot(slot, ItemStack.EMPTY);
                this.unequipAdventArmour(armour, piece);
            }
            if (updateInventory) {
                this.getPlayer().inventoryMenu.broadcastChanges();
            }
            return doArmourTick;
        }

        private void equipAdventArmour(AdventArmour item, AdventArmour.Piece piece) {
            AdventArmourSetContainer pieceContainer = this.equippedByMaterial.computeIfAbsent((Holder<ArmorMaterial>)item.getMaterial(), material -> new AdventArmourSetContainer(item));
            item.onEquip((LivingEntity)this.getPlayer(), piece, pieceContainer.equippedPieces);
            pieceContainer.equippedPieces().add(piece);
        }

        private void unequipAdventArmour(AdventArmour item, AdventArmour.Piece piece) {
            AdventArmourSetContainer pieceContainer = this.equippedByMaterial.get(item.getMaterial());
            if (pieceContainer != null) {
                item.onUnequip((LivingEntity)this.getPlayer(), piece, pieceContainer.equippedPieces());
                pieceContainer.equippedPieces().remove((Object)piece);
                if (pieceContainer.equippedPieces().isEmpty()) {
                    this.equippedByMaterial.remove(item.getMaterial());
                }
            }
        }

        private record AdventArmourSetContainer(AdventArmour armour, EnumSet<AdventArmour.Piece> equippedPieces) {
            private AdventArmourSetContainer(AdventArmour armour) {
                this(armour, EnumSet.noneOf(AdventArmour.Piece.class));
            }
        }
    }

    public final class Stats
    implements PartialNbtSerializable {
        private final Object2ObjectOpenHashMap<AoASkill, AoASkill.Instance> skills;
        private final Object2ObjectOpenHashMap<AoAResource, AoAResource.Instance> resources;
        private boolean isLegitimate;
        private boolean abilitiesRegionLocked;

        private Stats() {
            this.skills = AoASkillsReloadListener.generateSkillsMap(ServerPlayerDataManager.this);
            this.resources = AoAResourcesReloadListener.generateResourcesMap(ServerPlayerDataManager.this);
            this.isLegitimate = true;
            this.abilitiesRegionLocked = false;
        }

        public Collection<AoASkill.Instance> getSkills() {
            return this.skills.values();
        }

        public Collection<AoAResource.Instance> getResources() {
            return this.resources.values();
        }

        public boolean isLegitimate() {
            return this.isLegitimate;
        }

        public boolean areAbilitiesRegionLocked() {
            return this.abilitiesRegionLocked;
        }

        @NotNull
        public AoASkill.Instance getSkill(AoASkill skill) {
            return (AoASkill.Instance)this.skills.getOrDefault((Object)skill, (Object)AoASkills.DEFAULT);
        }

        @Nullable
        public AoAAbility.Instance getAbility(String abilityId) {
            for (AoASkill.Instance skill : this.getSkills()) {
                if (!skill.getAbilityMap().containsKey(abilityId)) continue;
                return skill.getAbilityMap().get(abilityId);
            }
            return null;
        }

        public int getLevel(AoASkill skill) {
            return this.getLevel(skill, true);
        }

        public int getLevel(AoASkill skill, boolean includeVanity) {
            return this.getSkill(skill).getLevel(includeVanity);
        }

        public int getTotalLevel() {
            int i = 0;
            for (AoASkill.Instance skill : this.getSkills()) {
                i += skill.getLevel(true);
            }
            return i;
        }

        public boolean hasLevel(AoASkill skill, int level) {
            return this.getLevel(skill) >= level;
        }

        @NotNull
        public AoAResource.Instance getResource(AoAResource resource) {
            return (AoAResource.Instance)this.resources.getOrDefault((Object)resource, (Object)AoAResources.DEFAULT);
        }

        public float getResourceAmount(AoAResource resource) {
            return this.getResource(resource).getCurrentValue();
        }

        public boolean hasResourceAmount(AoAResource resource, float amount) {
            return this.getResourceAmount(resource) >= amount;
        }

        public void setInAbilityLockRegion() {
            for (WeakReference listener : ServerPlayerDataManager.this.eventListeners) {
                ((AoAPlayerEventListener)listener.get()).disable(AoAPlayerEventListener.ListenerState.REGION_LOCKED, false);
            }
            this.abilitiesRegionLocked = true;
        }

        public void leaveAbilityLockRegion() {
            if (!this.areAbilitiesRegionLocked()) {
                return;
            }
            this.abilitiesRegionLocked = false;
            ServerPlayerDataManager.this.checkAndUpdateListeners();
        }

        void registerEventSubscribers() {
            this.resources.values().forEach(ServerPlayerDataManager.this::addEventListener);
            for (AoASkill.Instance skill : this.skills.values()) {
                ServerPlayerDataManager.this.addEventListener(skill);
                skill.getAbilityMap().values().forEach(ServerPlayerDataManager.this::addEventListener);
            }
        }

        private void clone(Stats oldStats) {
            AoAPlayerEventListener newInstance;
            this.isLegitimate = oldStats.isLegitimate;
            for (Map.Entry entry : oldStats.skills.entrySet()) {
                newInstance = (AoASkill.Instance)this.skills.get(entry.getKey());
                if (newInstance == null) continue;
                ((AoASkill.Instance)newInstance).loadFromNbt(((AoASkill.Instance)entry.getValue()).saveToNbt());
            }
            for (Map.Entry entry : oldStats.resources.entrySet()) {
                newInstance = (AoAResource.Instance)this.resources.get(entry.getKey());
                if (newInstance == null) continue;
                ((AoAResource.Instance)newInstance).loadFromNbt(((AoAResource.Instance)entry.getValue()).saveToNbt());
            }
        }

        boolean getSyncData(Supplier<CompoundTag> syncData) {
            CompoundTag skillData = null;
            CompoundTag resourceData = null;
            for (AoASkill.Instance skill : this.getSkills()) {
                if (!skill.needsSync) continue;
                if (skillData == null) {
                    skillData = new CompoundTag();
                }
                skillData.put(RegistryUtil.getId(skill.type()).toString(), (Tag)skill.getSyncData(false));
            }
            for (AoAResource.Instance resource : this.getResources()) {
                if (!resource.needsSync) continue;
                if (resourceData == null) {
                    resourceData = new CompoundTag();
                }
                resourceData.put(RegistryUtil.getId(resource.type()).toString(), (Tag)resource.getSyncData(false));
            }
            if (skillData != null) {
                syncData.get().put("skills", (Tag)skillData);
            }
            if (resourceData != null) {
                syncData.get().put("resources", resourceData);
            }
            if (skillData == null && resourceData == null) {
                return false;
            }
            syncData.get().putBoolean("legitimate", this.isLegitimate());
            return true;
        }

        @Override
        public void load(CompoundTag nbt, HolderLookup.Provider holderLookup, boolean isPartial) {
            String id;
            this.isLegitimate = nbt.getBoolean("legitimate");
            if (nbt.contains("skills")) {
                CompoundTag skillsNbt = nbt.getCompound("skills");
                for (AoASkill.Instance skill : this.skills.values()) {
                    id = AoARegistries.AOA_SKILLS.getKey(skill.type()).toString();
                    if (!skillsNbt.contains(id)) continue;
                    skill.loadFromNbt(skillsNbt.getCompound(id));
                }
            }
            if (nbt.contains("resources")) {
                CompoundTag resourcesNbt = nbt.getCompound("resources");
                for (AoAResource.Instance resource : this.resources.values()) {
                    id = AoARegistries.AOA_RESOURCES.getKey(resource.type()).toString();
                    if (!resourcesNbt.contains(id)) continue;
                    resource.loadFromNbt(resourcesNbt.getCompound(id));
                }
            }
        }

        @Override
        public void save(CompoundTag nbt, HolderLookup.Provider holderLookup, boolean forClientSync) {
            nbt.putBoolean("legitimate", this.isLegitimate());
            if (!this.skills.isEmpty()) {
                CompoundTag skillsData = new CompoundTag();
                for (AoASkill.Instance skill : this.skills.values()) {
                    skillsData.put(AoARegistries.AOA_SKILLS.getKey(skill.type()).toString(), (Tag)(forClientSync ? skill.getSyncData(true) : skill.saveToNbt()));
                }
                nbt.put("skills", (Tag)skillsData);
            }
            if (!this.resources.isEmpty()) {
                CompoundTag resourcesNbt = new CompoundTag();
                for (AoAResource.Instance resource : this.resources.values()) {
                    resourcesNbt.put(AoARegistries.AOA_RESOURCES.getKey(resource.type()).toString(), (Tag)(forClientSync ? resource.getSyncData(true) : resource.saveToNbt()));
                }
                nbt.put("resources", (Tag)resourcesNbt);
            }
        }
    }

    public final class Storage
    implements PartialNbtSerializable {
        private final Object2ObjectOpenHashMap<ResourceKey<net.minecraft.world.level.Level>, GlobalPos> portalCoordinatesMap = new Object2ObjectOpenHashMap();
        private final CopyOnWriteArraySet<ResourceLocation> patchouliBooks = new CopyOnWriteArraySet();
        private final Int2ObjectMap<ItemStack> itemStorage = new Int2ObjectArrayMap();
        @Nullable
        private PositionAndRotation activeCheckpoint = null;
        @Nullable
        private CompoundTag foodDataStorage = null;
        private boolean needsPatchouliSync = false;

        private Storage() {
            if (IntegrationManager.isPatchouliActive()) {
                this.patchouliBooks.add(AdventOfAscension.id("aoa_essentia"));
            }
        }

        public Map<ResourceKey<net.minecraft.world.level.Level>, GlobalPos> getPortalReturnLocations() {
            return this.portalCoordinatesMap;
        }

        @Nullable
        public GlobalPos getPortalReturnFor(ResourceKey<net.minecraft.world.level.Level> toDimension) {
            return this.getPortalReturnLocations().get(toDimension);
        }

        public void setPortalReturnLocation(ResourceKey<net.minecraft.world.level.Level> toDimension, ResourceKey<net.minecraft.world.level.Level> fromDim, BlockPos posInFromDim) {
            this.setPortalReturnLocation(toDimension, new GlobalPos(fromDim, posInFromDim));
        }

        public void setPortalReturnLocation(ResourceKey<net.minecraft.world.level.Level> toDimension, GlobalPos pos) {
            this.getPortalReturnLocations().put(toDimension, pos);
        }

        public void removePortalReturnLocation(ResourceKey<net.minecraft.world.level.Level> toDimension) {
            this.getPortalReturnLocations().remove(toDimension);
        }

        public void addPatchouliBook(ResourceLocation book) {
            if (this.patchouliBooks.add(book)) {
                this.needsPatchouliSync = true;
            }
        }

        public boolean hasPatchouliBook(ResourceLocation book) {
            return this.patchouliBooks.contains(book);
        }

        @Nullable
        public PositionAndRotation getActiveCheckpoint() {
            return this.activeCheckpoint;
        }

        public void clearActiveCheckpoint() {
            this.setActiveCheckpoint(null);
        }

        public void setActiveCheckpoint(@Nullable PositionAndRotation checkpoint) {
            this.activeCheckpoint = checkpoint;
        }

        public void putItemsInStorage(Predicate<ItemStack> shouldStore) {
            this.putItemsInStorage(shouldStore, () -> true);
        }

        public void putItemsInStorage(Predicate<ItemStack> shouldStore, BooleanSupplier keepLooking) {
            this.itemStorage.clear();
            ServerPlayer player = ServerPlayerDataManager.this.getPlayer();
            int slotIndex = 0;
            for (NonNullList compartment : player.getInventory().compartments) {
                for (int i = 0; i < compartment.size(); ++i) {
                    ItemStack stack = (ItemStack)compartment.get(i);
                    if (!stack.isEmpty() && shouldStore.test(stack)) {
                        int position = slotIndex + i;
                        ItemStack prevStack = (ItemStack)this.itemStorage.put(position, (Object)stack.copy());
                        if (prevStack != null) {
                            this.itemStorage.put(-position, (Object)prevStack);
                        }
                        compartment.set(i, (Object)ItemStack.EMPTY);
                    }
                    if (keepLooking.getAsBoolean()) continue;
                    return;
                }
                slotIndex += compartment.size();
            }
        }

        public void returnStoredItems() {
            if (this.itemStorage.isEmpty()) {
                return;
            }
            Inventory inventory = ServerPlayerDataManager.this.getPlayer().getInventory();
            this.itemStorage.int2ObjectEntrySet().removeIf(entry -> {
                int slotIndex = entry.getIntKey();
                if (slotIndex > inventory.getContainerSize() || slotIndex < 0) {
                    return false;
                }
                ItemStack slotItem = inventory.getItem(slotIndex);
                ItemStack storageItem = (ItemStack)entry.getValue();
                if (slotItem.isEmpty()) {
                    inventory.setItem(slotIndex, storageItem);
                    return true;
                }
                if (ItemStack.isSameItemSameComponents((ItemStack)slotItem, (ItemStack)storageItem)) {
                    int growSize = Math.min(slotItem.getMaxStackSize(), slotItem.getCount() + storageItem.getCount()) - slotItem.getCount();
                    if (growSize > 0) {
                        slotItem.grow(growSize);
                        slotItem.setPopTime(5);
                    }
                    if (growSize < storageItem.getCount()) {
                        storageItem.setCount(storageItem.getCount() - growSize);
                    } else {
                        return true;
                    }
                }
                return false;
            });
            if (!this.itemStorage.isEmpty()) {
                InventoryUtil.giveItemsTo(ServerPlayerDataManager.this.getPlayer(), (Collection<ItemStack>)this.itemStorage.values());
                this.itemStorage.clear();
            }
        }

        public void saveFoodData() {
            this.foodDataStorage = new CompoundTag();
            ServerPlayerDataManager.this.getPlayer().getFoodData().addAdditionalSaveData(this.foodDataStorage);
        }

        public void restoreFoodData() {
            if (this.foodDataStorage == null) {
                return;
            }
            ServerPlayerDataManager.this.getPlayer().getFoodData().readAdditionalSaveData(this.foodDataStorage);
            this.foodDataStorage = null;
        }

        boolean getSyncData(Supplier<CompoundTag> syncData) {
            if (!this.needsPatchouliSync) {
                return false;
            }
            ListTag booksNbt = new ListTag();
            for (ResourceLocation id : this.patchouliBooks) {
                booksNbt.add((Object)StringTag.valueOf((String)id.toString()));
            }
            syncData.get().put("PatchouliBooks", (Tag)booksNbt);
            return true;
        }

        private void clone(Storage oldStorage) {
            this.portalCoordinatesMap.putAll(oldStorage.portalCoordinatesMap);
            this.patchouliBooks.addAll(oldStorage.patchouliBooks);
            this.itemStorage.putAll(oldStorage.itemStorage);
            this.activeCheckpoint = oldStorage.activeCheckpoint;
            this.foodDataStorage = oldStorage.foodDataStorage;
        }

        @Override
        public void load(CompoundTag nbt, HolderLookup.Provider holderLookup, boolean isPartial) {
            CompoundTag data;
            if (nbt.contains("ItemStorage", 10) && !(data = nbt.getCompound("ItemStorage")).isEmpty()) {
                this.itemStorage.clear();
                for (String key : data.getAllKeys()) {
                    try {
                        this.itemStorage.put(Integer.parseInt(key), (Object)ItemStack.parseOptional((HolderLookup.Provider)holderLookup, (CompoundTag)data.getCompound(key)));
                    }
                    catch (Exception ex) {
                        Logging.logMessage(Level.WARN, "Invalid key in ItemStorage NBT data for player. Stop messing with player NBT!", ex);
                    }
                }
            }
            if (nbt.contains("PortalMap", 10) && !(data = nbt.getCompound("PortalMap")).isEmpty()) {
                this.portalCoordinatesMap.clear();
                for (String entry : data.getAllKeys()) {
                    try {
                        CompoundTag portalReturnTag = data.getCompound(entry);
                        ResourceLocation fromDim = (ResourceLocation)ResourceLocation.read((String)portalReturnTag.getString("FromDim")).getOrThrow();
                        BlockPos portalPos = NbtUtils.readBlockPos((CompoundTag)portalReturnTag, (String)"PortalPos").orElseGet(() -> ServerPlayerDataManager.this.getPlayer().level().getSharedSpawnPos());
                        ResourceKey toDimKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)((ResourceLocation)ResourceLocation.read((String)entry).getOrThrow()));
                        ResourceKey fromDimKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)fromDim);
                        this.portalCoordinatesMap.put((Object)toDimKey, (Object)new GlobalPos(fromDimKey, portalPos));
                    }
                    catch (Exception e) {
                        Logging.logMessage(Level.WARN, "Found invalid portal map data, has someone been tampering with files? Data: " + entry);
                    }
                }
            }
            if (nbt.contains("Checkpoint", 10)) {
                try {
                    CompoundTag checkpointTag = nbt.getCompound("Checkpoint");
                    double x = checkpointTag.getDouble("x");
                    double y = checkpointTag.getDouble("y");
                    double z = checkpointTag.getDouble("z");
                    float pitch = checkpointTag.getFloat("pitch");
                    float yaw = checkpointTag.getFloat("yaw");
                    this.activeCheckpoint = new PositionAndRotation(x, y, z, pitch, yaw);
                }
                catch (NumberFormatException e) {
                    Logging.logMessage(Level.WARN, "Found invalid checkpoint data, has someone been tampering with files?");
                }
            }
            if (nbt.contains("PatchouliBooks")) {
                data = nbt.getList("PatchouliBooks", 8);
                this.needsPatchouliSync = true;
                if (!this.patchouliBooks.isEmpty()) {
                    this.patchouliBooks.clear();
                }
                for (Tag book : data) {
                    ResourceLocation.read((String)book.getAsString()).resultOrPartial(err -> Logging.logMessage(Level.WARN, err)).ifPresent(this.patchouliBooks::add);
                }
            }
        }

        @Override
        public void save(CompoundTag nbt, HolderLookup.Provider holderLookup, boolean isPartial) {
            ListTag data;
            if (!this.patchouliBooks.isEmpty()) {
                data = new ListTag();
                for (ResourceLocation id : this.patchouliBooks) {
                    data.add((Object)StringTag.valueOf((String)id.toString()));
                }
                nbt.put("PatchouliBooks", (Tag)data);
            }
            if (isPartial) {
                return;
            }
            if (!this.itemStorage.isEmpty()) {
                data = new CompoundTag();
                for (Object entry : this.itemStorage.int2ObjectEntrySet()) {
                    data.put(String.valueOf(entry.getIntKey()), ((ItemStack)entry.getValue()).save(holderLookup));
                }
                nbt.put("ItemStorage", (Tag)data);
            }
            if (!this.portalCoordinatesMap.isEmpty()) {
                data = new CompoundTag();
                for (Object entry : this.portalCoordinatesMap.entrySet()) {
                    CompoundTag portalReturnTag = new CompoundTag();
                    GlobalPos container = (GlobalPos)entry.getValue();
                    portalReturnTag.putString("FromDim", container.dimension().location().toString());
                    portalReturnTag.put("PortalPos", NbtUtils.writeBlockPos((BlockPos)container.pos()));
                    data.put(((ResourceKey)entry.getKey()).location().toString(), (Tag)portalReturnTag);
                }
                nbt.put("PortalMap", (Tag)data);
            }
            if (this.activeCheckpoint != null) {
                data = new CompoundTag();
                data.putDouble("x", this.activeCheckpoint.x());
                data.putDouble("y", this.activeCheckpoint.y());
                data.putDouble("z", this.activeCheckpoint.z());
                data.putFloat("pitch", this.activeCheckpoint.pitch());
                data.putFloat("yaw", this.activeCheckpoint.yaw());
                nbt.put("Checkpoint", (Tag)data);
            }
        }
    }
}

