/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.object.explosion;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EntityBasedExplosionDamageCalculator;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import net.tslat.aoa3.common.registration.AoAGameRules;
import net.tslat.aoa3.library.object.explosion.ExplosionInfo;
import net.tslat.aoa3.scheduling.AoAScheduler;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;
import net.tslat.smartbrainlib.util.RandomUtil;
import org.jetbrains.annotations.Nullable;

public class ExtendedExplosion
extends Explosion {
    protected final ExplosionInfo info;
    protected final RandomUtil.EasyRandom random = new RandomUtil.EasyRandom();
    protected List<Entity> affectedEntities;
    protected Object2ObjectOpenHashMap<BlockPos, BlockState> affectedBlocks = new Object2ObjectOpenHashMap();
    protected ObjectArrayList<Pair<ItemStack, BlockPos>> blockDrops = new ObjectArrayList();
    @Nullable
    protected Entity indirectExploder;
    protected Vec3 origin;
    protected boolean shouldDamageBlocks = true;
    protected int explodeTick;
    protected Predicate<Vec3> boundsPredicate = null;

    public ExtendedExplosion(ExplosionInfo explosionInfo, ServerLevel level, Entity exploder, Entity indirectExploder) {
        this(explosionInfo, level, exploder, indirectExploder, null, exploder.getX(0.5), exploder.getY(0.5), exploder.getZ(0.5));
    }

    public ExtendedExplosion(ExplosionInfo explosionInfo, ServerLevel level, Entity exploder) {
        this(explosionInfo, level, exploder, null, null, exploder.getX(0.5), exploder.getY(0.5), exploder.getZ(0.5));
    }

    public ExtendedExplosion(ExplosionInfo explosionInfo, ServerLevel level, Entity exploder, Entity indirectExploder, Vec3 position) {
        this(explosionInfo, level, exploder, indirectExploder, null, position.x, position.y, position.z);
    }

    public ExtendedExplosion(ExplosionInfo explosionInfo, ServerLevel level, Entity exploder, Vec3 position) {
        this(explosionInfo, level, exploder, null, null, position.x, position.y, position.z);
    }

    public ExtendedExplosion(ExplosionInfo explosionInfo, ServerLevel level, Entity exploder, double x, double y, double z) {
        this(explosionInfo, level, exploder, null, null, x, y, z);
    }

    public ExtendedExplosion(ExplosionInfo explosionInfo, ServerLevel level, double x, double y, double z) {
        this(explosionInfo, level, null, null, null, x, y, z);
    }

    public ExtendedExplosion(ExplosionInfo explosionInfo, ServerLevel level, DamageSource damageSource, double x, double y, double z) {
        this(explosionInfo, level, null, null, damageSource, x, y, z);
    }

    public ExtendedExplosion(ExplosionInfo explosionInfo, ServerLevel level, @Nullable Entity exploder, @Nullable Entity indirectExploder, @Nullable DamageSource damageSource, double x, double y, double z) {
        super((Level)level, exploder, damageSource, null, x, y, z, 0.0f, false, Explosion.BlockInteraction.KEEP, (ParticleOptions)ParticleTypes.EXPLOSION, (ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, (Holder)SoundEvents.GENERIC_EXPLODE);
        this.info = explosionInfo;
        this.origin = this.center();
        this.indirectExploder = indirectExploder;
    }

    public ExplosionInfo getExplosionInfo() {
        return this.info;
    }

    public Level getLevel() {
        return this.level;
    }

    public RandomUtil.EasyRandom rand() {
        return this.random;
    }

    public int getExplodeTick() {
        return this.explodeTick;
    }

    public boolean shouldDamageBlocks() {
        return this.shouldDamageBlocks;
    }

    public int stepsPerTick() {
        return 1000;
    }

    public void explode() {
        this.sanityCheck();
        this.shouldDamageBlocks = this.griefingCheck();
        this.damageCalculator = this.source != null ? new EntityBasedExplosionDamageCalculator(this.source) : new ExplosionDamageCalculator();
        this.level.gameEvent(this.source, (Holder)GameEvent.EXPLODE, this.origin);
        this.boundsPredicate = (Predicate)this.info.getRadius().map(radius -> pos -> pos.closerThan((Position)this.origin, (double)radius.floatValue()), squareRadius -> {
            AABB bounds = squareRadius.inflateAABB(new AABB(this.origin.x, this.origin.y, this.origin.z, this.origin.x, this.origin.y, this.origin.z));
            return arg_0 -> ((AABB)bounds).contains(arg_0);
        });
        this.doPreExplosionWork();
        this.toBlow = this.getAffectedBlocks();
        this.affectedEntities = this.getAffectedEntities();
        this.filterAffectedBlocksAndEntities();
        EventHooks.onExplosionDetonate((Level)this.level, (Explosion)this, this.affectedEntities, (double)((this.info.getBaseDamage() + this.info.getEffectiveRadius()) / 2.0f));
        this.level.playSound(null, this.origin.x, this.origin.y, this.origin.z, (SoundEvent)this.info.getExplosionSound().value(), SoundSource.BLOCKS, 4.0f, (1.0f + (this.level.random.nextFloat() - this.level.random.nextFloat()) * 0.2f) * 0.7f);
        if (this.info.isSingleTickExplosion()) {
            this.info.doParticles(this, -1);
            for (BlockPos pos : this.toBlow) {
                BlockState state = (BlockState)this.affectedBlocks.get((Object)pos);
                if (state == null) continue;
                this.captureDropsForBlock(state, pos, this.blockDrops);
                state.onBlockExploded(this.level, pos, (Explosion)this);
                this.info.blockBroken(this, state, pos);
            }
            this.impactEntities();
            this.finishExplosion();
        } else {
            this.doExplosionTick(this.stepsPerTick());
        }
    }

    protected void sanityCheck() {
        if (!NumberUtil.numberIsBetween(this.info.getEffectiveRadius(), 0.0, 256.0)) {
            throw new IllegalArgumentException("Invalid radius provided, must be between 1 and 255 blocks (inclusive)");
        }
        if (!(this.info.isBlockDamaging() || this.info.isEntityDamaging() || this.info.isKnockbackEntities())) {
            throw new IllegalArgumentException("Provided ExplosionInfo has all functional effects disabled. What are you even doing?");
        }
    }

    protected void doPreExplosionWork() {
    }

    protected boolean griefingCheck() {
        if (!this.info.isBlockDamaging()) {
            return false;
        }
        if (this.indirectExploder != null) {
            if (this.indirectExploder instanceof Player) {
                return AoAGameRules.checkDestructiveWeaponPhysics(this.level);
            }
            return EventHooks.canEntityGrief((Level)this.level, (Entity)this.indirectExploder);
        }
        if (this.source != null) {
            OwnableEntity ownable;
            if (this.source instanceof Player || !(this.source instanceof LivingEntity)) {
                return AoAGameRules.checkDestructiveWeaponPhysics(this.level);
            }
            Entity entity = this.source;
            if (entity instanceof OwnableEntity && (ownable = (OwnableEntity)entity).getOwner() instanceof Player) {
                return AoAGameRules.checkDestructiveWeaponPhysics(this.level);
            }
            return EventHooks.canEntityGrief((Level)this.level, (Entity)this.source);
        }
        return true;
    }

    protected ObjectArrayList<BlockPos> getAffectedBlocks() {
        return new ObjectArrayList();
    }

    protected List<Entity> getAffectedEntities() {
        Predicate<Entity> predicate = this.info.getAffectsOwner() ? entity -> !entity.ignoreExplosion((Explosion)this) && this.info.shouldAffectEntity(this, (Entity)entity) : entity -> entity != this.source && entity != this.indirectExploder && !entity.ignoreExplosion((Explosion)this) && this.info.shouldAffectEntity(this, (Entity)entity);
        return (List)this.info.getRadius().map(radius -> EntityRetrievalUtil.getEntities((Level)this.level, (AABB)AABB.ofSize((Vec3)this.origin, (double)(radius.floatValue() * 2.0f), (double)(radius.floatValue() * 2.0f), (double)(radius.floatValue() * 2.0f)), (Predicate)predicate), squareRadius -> EntityRetrievalUtil.getEntities((Level)this.level, (AABB)squareRadius.inflateAABB(new AABB(this.origin.x, this.origin.y, this.origin.z, this.origin.x, this.origin.y, this.origin.z)), (Predicate)predicate));
    }

    protected void filterAffectedBlocksAndEntities() {
    }

    protected void finishExplosion() {
        this.spawnDrops((List<Pair<ItemStack, BlockPos>>)this.blockDrops);
        this.info.postExplosionCallback(this);
    }

    protected void doExplosionTick(int steps) {
        this.info.doParticles(this, this.explodeTick);
        if (this.shouldDamageBlocks()) {
            int step = 0;
            ObjectListIterator iterator = this.toBlow.iterator();
            while (step++ <= steps && iterator.hasNext()) {
                BlockPos pos = (BlockPos)iterator.next();
                BlockState state = (BlockState)this.affectedBlocks.get((Object)pos);
                this.captureDropsForBlock(state, pos, this.blockDrops);
                state.onBlockExploded(this.level, pos, (Explosion)this);
                this.info.blockBroken(this, state, pos);
                iterator.remove();
            }
            if (this.explodeTick++ < 600 && !this.toBlow.isEmpty()) {
                AoAScheduler.scheduleSyncronisedTask(() -> this.doExplosionTick(steps), 1);
                return;
            }
        }
        this.impactEntities();
        this.finishExplosion();
    }

    protected void impactEntities() {
    }

    protected void captureDropsForBlock(BlockState state, BlockPos pos, ObjectArrayList<Pair<ItemStack, BlockPos>> loot) {
        if (state.canDropFromExplosion((BlockGetter)this.level, pos, (Explosion)this) && RandomUtil.percentChance((double)this.info.getBlockDropChance())) {
            ServerLevel serverLevel = (ServerLevel)this.level;
            LootParams.Builder params = new LootParams.Builder(serverLevel).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos)).withParameter(LootContextParams.TOOL, (Object)ItemStack.EMPTY).withParameter(LootContextParams.EXPLOSION_RADIUS, (Object)Float.valueOf((this.info.getBaseDamage() + this.info.getEffectiveRadius()) / 2.0f)).withOptionalParameter(LootContextParams.BLOCK_ENTITY, state.hasBlockEntity() ? this.level.getBlockEntity(pos) : null).withOptionalParameter(LootContextParams.THIS_ENTITY, (Object)this.source);
            state.spawnAfterBreak(serverLevel, pos, ItemStack.EMPTY, this.source instanceof Player || this.indirectExploder instanceof Player);
            state.getDrops(params).forEach(stack -> ExtendedExplosion.addOrAppendStack((List)loot, (ItemStack)stack, (BlockPos)pos));
        }
    }

    protected void spawnDrops(List<Pair<ItemStack, BlockPos>> loot) {
        for (Pair<ItemStack, BlockPos> lootDrop : loot) {
            Block.popResource((Level)this.level, (BlockPos)((BlockPos)lootDrop.getSecond()), (ItemStack)((ItemStack)lootDrop.getFirst()));
        }
    }
}

