/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.object;

import com.google.common.collect.Lists;
import com.mojang.brigadier.Message;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.UUID;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.tslat.aoa3.util.LocaleUtil;
import org.jetbrains.annotations.ApiStatus;

public final class Text
extends MutableComponent {
    private static final ChatFormatting[] NO_FORMAT = new ChatFormatting[0];

    private Text(ComponentContents contents) {
        super(contents, (List)Lists.newArrayList(), Style.EMPTY);
    }

    public static Text of(String langKey) {
        return Text.of(langKey, NO_FORMAT);
    }

    public static Text of(String langKey, ChatFormatting ... styles) {
        return Text.of(langKey, Text.formatting(styles), TranslatableContents.NO_ARGS);
    }

    public static Text of(String langKey, Object ... args) {
        return Text.of(langKey, Text.formatting(NO_FORMAT), args);
    }

    public static Text of(String langKey, int colour, ChatFormatting ... styles) {
        return Text.of(langKey, Text.colourAndFormatting(colour, styles), TranslatableContents.NO_ARGS);
    }

    public static Text of(String langKey, UnaryOperator<Style> style, Object ... args) {
        return new Text((ComponentContents)new TranslatableContents(langKey, null, Text.transformArgs(args))).withStyle((UnaryOperator)style);
    }

    public static Text ofLiteral(String text) {
        return Text.ofLiteral(text, NO_FORMAT);
    }

    public static Text ofLiteral(String text, ChatFormatting ... styles) {
        return Text.ofLiteral(text, Text.formatting(styles));
    }

    public static Text ofLiteral(String text, int colour, ChatFormatting ... styles) {
        return Text.ofLiteral(text, Text.colourAndFormatting(colour, styles));
    }

    public static Text ofLiteral(String text, UnaryOperator<Style> style) {
        return new Text((ComponentContents)new PlainTextContents.LiteralContents(text)).withStyle((UnaryOperator)style);
    }

    public static Text formatAsBeneficial(String langKey, Object ... args) {
        return Text.ofFixedFormat(langKey, LocaleUtil.ItemDescriptionType.BENEFICIAL, args);
    }

    public static Text formatAsNegative(String langKey, Object ... args) {
        return Text.ofFixedFormat(langKey, LocaleUtil.ItemDescriptionType.HARMFUL, args);
    }

    public static Text formatAsNeutral(String langKey, Object ... args) {
        return Text.ofFixedFormat(langKey, LocaleUtil.ItemDescriptionType.NEUTRAL, args);
    }

    public static Text formatAsUnique(String langKey, Object ... args) {
        return Text.ofFixedFormat(langKey, LocaleUtil.ItemDescriptionType.UNIQUE, args);
    }

    public static Text formatAsSpecial(String langKey, Object ... args) {
        return Text.ofFixedFormat(langKey, LocaleUtil.ItemDescriptionType.SPECIAL, args);
    }

    public static Text formatAsItemTypeInfo(String langKey, Object ... args) {
        return Text.ofFixedFormat(langKey, LocaleUtil.ItemDescriptionType.ITEM_TYPE_INFO, args);
    }

    public static Text formatAsDamageValue(String langKey, Object ... args) {
        return Text.ofFixedFormat(langKey, LocaleUtil.ItemDescriptionType.ITEM_DAMAGE, args);
    }

    public static Text formatAsAmmoCost(String langKey, Object ... args) {
        return Text.ofFixedFormat(langKey, LocaleUtil.ItemDescriptionType.ITEM_AMMO_COST, args);
    }

    public static Text ofFixedFormat(String langKey, LocaleUtil.ItemDescriptionType type, Object ... args) {
        return Text.of(langKey, Text.formatting(type.format), args);
    }

    public Text then(String langKey) {
        return this.then(langKey, NO_FORMAT);
    }

    public Text then(String langKey, ChatFormatting ... styles) {
        return this.then(langKey, Text.formatting(styles), TranslatableContents.NO_ARGS);
    }

    public Text then(String langKey, int colour, ChatFormatting ... styles) {
        return this.then(langKey, Text.colourAndFormatting(colour, styles), TranslatableContents.NO_ARGS);
    }

    public Text then(String langKey, UnaryOperator<Style> style, Object ... args) {
        this.append((Component)Component.translatable((String)langKey, (Object[])Text.transformArgs(args)).withStyle(style));
        return this;
    }

    public Text thenLiteral(String text) {
        return this.thenLiteral(text, NO_FORMAT);
    }

    public Text thenLiteral(String text, ChatFormatting ... styles) {
        return this.thenLiteral(text, Text.formatting(styles));
    }

    public Text thenLiteral(String text, int colour, ChatFormatting ... styles) {
        return this.thenLiteral(text, Text.colourAndFormatting(colour, styles));
    }

    public Text thenLiteral(String text, UnaryOperator<Style> style) {
        this.append((Component)Component.literal((String)text).withStyle(style));
        return this;
    }

    private static UnaryOperator<Style> formatting(ChatFormatting ... styles) {
        if (styles.length == 0) {
            return UnaryOperator.identity();
        }
        return style -> style.applyFormats(styles);
    }

    private static UnaryOperator<Style> colourInt(int colour) {
        return style -> style.withColor(colour);
    }

    private static UnaryOperator<Style> colourAndFormatting(int colour, ChatFormatting ... styles) {
        if (styles.length == 0) {
            return Text.colourInt(colour);
        }
        return style -> style.withColor(colour).applyFormats(styles);
    }

    private static Object[] transformArgs(Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            Object object;
            Object object2 = args[i];
            int n = 0;
            block15: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Component.class, String.class, Number.class, Boolean.class, ResourceLocation.class, BlockPos.class, ChunkPos.class, UUID.class, Message.class, Message.class, Item.class, ItemStack.class}, (Object)object2, n)) {
                    case 0: {
                        Component component = (Component)object2;
                        object = component;
                        break block15;
                    }
                    case 1: {
                        String text = (String)object2;
                        object = Text.ofLiteral(text);
                        break block15;
                    }
                    case 2: {
                        Number number = (Number)object2;
                        object = Text.ofLiteral(number.toString());
                        break block15;
                    }
                    case 3: {
                        Boolean bool = (Boolean)object2;
                        object = Text.ofLiteral(bool.toString());
                        break block15;
                    }
                    case 4: {
                        ResourceLocation path = (ResourceLocation)object2;
                        object = Text.ofLiteral(path.toString());
                        break block15;
                    }
                    case 5: {
                        BlockPos pos = (BlockPos)object2;
                        object = Text.ofLiteral(pos.toString());
                        break block15;
                    }
                    case 6: {
                        ChunkPos pos = (ChunkPos)object2;
                        object = Text.ofLiteral(pos.toString());
                        break block15;
                    }
                    case 7: {
                        UUID uuid = (UUID)object2;
                        object = Text.ofLiteral(uuid.toString());
                        break block15;
                    }
                    case 8: {
                        Message message = (Message)object2;
                        if (!(message instanceof Component)) {
                            n = 9;
                            continue block15;
                        }
                        Component component = (Component)message;
                        object = component;
                        break block15;
                    }
                    case 9: {
                        Message message = (Message)object2;
                        object = Text.ofLiteral(message.toString());
                        break block15;
                    }
                    case 10: {
                        Item item = (Item)object2;
                        object = item.getDefaultInstance().getHoverName();
                        break block15;
                    }
                    case 11: {
                        ItemStack stack = (ItemStack)object2;
                        object = stack.getHoverName();
                        break block15;
                    }
                    default: {
                        object = TranslatableContents.TEXT_NULL;
                        break block15;
                    }
                }
                break;
            }
            args[i] = object;
        }
        return args;
    }

    @ApiStatus.Internal
    public Text setStyle(Style style) {
        return (Text)super.setStyle(style);
    }

    @ApiStatus.Internal
    public Text append(String text) {
        return this.append((Component)Component.literal((String)text));
    }

    @ApiStatus.Internal
    public Text append(Component sibling) {
        return (Text)super.append(sibling);
    }

    @ApiStatus.Internal
    public Text withStyle(UnaryOperator<Style> style) {
        return (Text)super.withStyle(style);
    }

    @ApiStatus.Internal
    public Text withStyle(Style style) {
        return (Text)super.withStyle(style);
    }

    @ApiStatus.Internal
    public Text withStyle(ChatFormatting ... formatting) {
        return (Text)super.withStyle(formatting);
    }

    @ApiStatus.Internal
    public Text withStyle(ChatFormatting format) {
        return (Text)super.withStyle(format);
    }

    @ApiStatus.Internal
    public Text withColor(int colour) {
        return (Text)super.withColor(colour);
    }
}

