/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.object;

import java.util.Iterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.core.Vec3i;
import org.jetbrains.annotations.NotNull;

public final class PositionTableSet
implements Iterable<Vec3i> {
    private final boolean[] table;
    private final int width;
    private final int height;
    private final int depth;

    private PositionTableSet(int xWidth, int yHeight, int zDepth) {
        this.table = new boolean[xWidth * yHeight * zDepth];
        this.width = xWidth;
        this.height = yHeight;
        this.depth = zDepth;
    }

    public static PositionTableSet of(int diameter) {
        return PositionTableSet.of(diameter, diameter);
    }

    public static PositionTableSet of(int width, int height) {
        return PositionTableSet.of(width, height, width);
    }

    public static PositionTableSet of(int xWidth, int yHeight, int zDepth) {
        return new PositionTableSet(xWidth, yHeight, zDepth);
    }

    public static PositionTableSet of(Vec3i from, Vec3i to) {
        int minX = Math.min(from.getX(), to.getX());
        int minY = Math.min(from.getY(), to.getY());
        int minZ = Math.min(from.getZ(), to.getZ());
        int maxX = Math.max(from.getX(), to.getX());
        int maxY = Math.max(from.getY(), to.getY());
        int maxZ = Math.max(from.getZ(), to.getZ());
        return PositionTableSet.of(maxX - minX, maxY - minY, maxZ - minZ);
    }

    public boolean isFilledAt(int x, int y, int z) {
        return this.table[this.pack(x, y, z)];
    }

    public boolean isFilledAt(Vec3i position) {
        return this.isFilledAt(position.getX(), position.getY(), position.getZ());
    }

    public void add(int x, int y, int z) {
        this.table[this.pack((int)x, (int)y, (int)z)] = true;
    }

    public void add(Vec3i position) {
        this.add(position.getX(), position.getY(), position.getZ());
    }

    public void remove(int x, int y, int z) {
        this.table[this.pack((int)x, (int)y, (int)z)] = false;
    }

    public void remove(Vec3i position) {
        this.remove(position.getX(), position.getY(), position.getZ());
    }

    public boolean isAtEdgeOfRegion(int x, int y, int z) {
        return x == 0 || x == this.width - 1 || y == 0 || y == this.height - 1 || z == 0 || z == this.depth - 1;
    }

    public boolean isAdjacentFilled(int x, int y, int z) {
        if (this.isFilledAt(x - 1, y, z) || this.isFilledAt(x + 1, y, z)) {
            return true;
        }
        if (this.isFilledAt(x, y - 1, z) || this.isFilledAt(x, y + 1, z)) {
            return true;
        }
        return this.isFilledAt(x, y, z - 1) || this.isFilledAt(x, y, z + 1);
    }

    private int pack(int x, int y, int z) {
        return z * this.height * this.width + y * this.width + x;
    }

    private Vec3i unpack(int index) {
        int x = index % this.width;
        int y = index / this.width % this.height;
        int z = index / (this.width * this.height);
        return new Vec3i(x, y, z);
    }

    @NotNull
    public Iterable<Vec3i> emptyPositions() {
        return new Iterable<Vec3i>(){

            @Override
            @NotNull
            public Iterator<Vec3i> iterator() {
                return new Iterator<Vec3i>(){
                    int seekIndex = this.findNextIndex(0);
                    int index = 0;

                    @Override
                    public boolean hasNext() {
                        if (this.index >= this.seekIndex || PositionTableSet.this.table[this.seekIndex]) {
                            this.seekIndex = this.findNextIndex(this.index + 1);
                        }
                        return this.seekIndex != -1;
                    }

                    @Override
                    public Vec3i next() {
                        if (this.index >= this.seekIndex) {
                            this.seekIndex = this.findNextIndex(this.index + 1);
                        }
                        this.index = this.seekIndex;
                        if (this.index < 0) {
                            throw new IllegalStateException("Iterator did not have another element to proceed to! Check hasNext() before calling next");
                        }
                        return PositionTableSet.this.unpack(this.index);
                    }

                    private int findNextIndex(int nextIndex) {
                        for (int i = nextIndex; i < PositionTableSet.this.table.length; ++i) {
                            if (PositionTableSet.this.table[i]) continue;
                            return i;
                        }
                        return -1;
                    }
                };
            }
        };
    }

    public Stream<Vec3i> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    @Override
    @NotNull
    public Iterator<Vec3i> iterator() {
        return new Iterator<Vec3i>(){
            int seekIndex = this.findNextIndex(0);
            int index = 0;

            @Override
            public boolean hasNext() {
                if (this.index >= this.seekIndex || !PositionTableSet.this.table[this.seekIndex]) {
                    this.seekIndex = this.findNextIndex(this.index + 1);
                }
                return this.seekIndex != -1;
            }

            @Override
            public Vec3i next() {
                if (this.index >= this.seekIndex) {
                    this.seekIndex = this.findNextIndex(this.index + 1);
                }
                this.index = this.seekIndex;
                if (this.index < 0) {
                    throw new IllegalStateException("Iterator did not have another element to proceed to! Check hasNext() before calling next");
                }
                return PositionTableSet.this.unpack(this.index);
            }

            private int findNextIndex(int nextIndex) {
                for (int i = nextIndex; i < PositionTableSet.this.table.length; ++i) {
                    if (!PositionTableSet.this.table[i]) continue;
                    return i;
                }
                return -1;
            }
        };
    }
}

