/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.object;

import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface CachedFunction<T, R>
extends Function<T, R> {
    public static <T, R> CachedFunction<T, R> of(final @NotNull Function<T, R> inputFunction) {
        return new CachedFunction<T, R>(){
            private Function<T, R> function;
            private R cached;
            {
                this.function = inputFunction;
                this.cached = null;
            }

            @Override
            public R apply(T t) {
                if (this.cached != null) {
                    return this.cached;
                }
                this.cached = this.function.apply(t);
                this.function = null;
                return this.cached;
            }
        };
    }
}

