/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.builder;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public final class EntityPredicate<T extends Entity>
implements Predicate<T> {
    public static final Immutable<Entity> TARGETABLE_HOSTILE_MOB = new EntityPredicate().isAlive().isHostileMob().immutable();
    public static final Immutable<Entity> SURVIVAL_PLAYER = new EntityPredicate().isAlive().isSurvival().immutable();
    public static final Immutable<Entity> DAMAGEABLE_ENTITIES = new EntityPredicate().isAlive().isDamageable().immutable();
    public static final Immutable<Entity> TARGETABLE_ENTITIES = ((EntityPredicate)new EntityPredicate().isAlive().and(entity -> {
        Player pl;
        return !(entity instanceof Player) || !(pl = (Player)entity).isCreative() && !pl.isSpectator();
    })).immutable();
    private Predicate<T> predicate;

    public EntityPredicate() {
        this.predicate = Objects::nonNull;
    }

    public EntityPredicate(Entity excluding) {
        this.predicate = checkingEntity -> checkingEntity != excluding;
    }

    public EntityPredicate(Predicate<T> basePredicate) {
        this.predicate = basePredicate;
    }

    @Override
    public boolean test(T t) {
        return this.predicate.test(t);
    }

    @Override
    @NotNull
    public EntityPredicate<T> and(@NotNull Predicate<? super T> other) {
        Predicate predicate = this.predicate;
        this.predicate = entity -> predicate.test(entity) && other.test(entity);
        return this;
    }

    @Override
    @NotNull
    public EntityPredicate<T> or(@NotNull Predicate<? super T> other) {
        Predicate predicate = this.predicate;
        this.predicate = entity -> predicate.test(entity) || other.test(entity);
        return this;
    }

    public EntityPredicate<T> isSubtypeOf(Class<? extends Entity> clazz) {
        return this.and(clazz::isInstance);
    }

    public EntityPredicate<T> isNotSubtypeOf(Class<? extends Entity> clazz) {
        return this.and((T entity) -> !clazz.isInstance(entity));
    }

    public EntityPredicate<T> isAlive() {
        return this.and(Entity::isAlive);
    }

    public EntityPredicate<T> isDead() {
        return this.and((T entity) -> !entity.isAlive());
    }

    public EntityPredicate<T> isCreative() {
        return this.and((T entity) -> {
            Player pl;
            return entity instanceof Player && (pl = (Player)entity).isCreative();
        });
    }

    public EntityPredicate<T> isSpectator() {
        return this.and(Entity::isSpectator);
    }

    public EntityPredicate<T> isSurvival() {
        return this.and((T entity) -> {
            Player pl;
            return entity instanceof Player && !(pl = (Player)entity).isSpectator() && !pl.isCreative();
        });
    }

    public EntityPredicate<T> isHostileMob() {
        return this.and(Enemy.class::isInstance);
    }

    public EntityPredicate<T> isFriendlyMob() {
        return this.and((T entity) -> !(entity instanceof Enemy));
    }

    public EntityPredicate<T> isPlayer() {
        return this.isSubtypeOf(Player.class);
    }

    public EntityPredicate<T> isNonPlayer() {
        return this.and((T entity) -> !(entity instanceof Player));
    }

    public EntityPredicate<T> isDamageable() {
        return this.and((T entity) -> {
            Player pl;
            return !entity.isInvulnerable() && (!(entity instanceof Player) || !(pl = (Player)entity).isCreative() && !pl.isSpectator());
        });
    }

    public EntityPredicate<T> is(EntityType<?> entityType) {
        return this.and((T entity) -> entity.getType() == entityType);
    }

    public EntityPredicate<T> isNot(EntityType<?> entityType) {
        return this.and((T entity) -> entity.getType() != entityType);
    }

    public EntityPredicate<T> isInCollection(Collection<T> collection) {
        return this.and(collection::contains);
    }

    public EntityPredicate<T> notInCollection(Collection<T> collection) {
        return this.and((T entity) -> !collection.contains(entity));
    }

    private Immutable<T> immutable() {
        return new Immutable(this);
    }

    public static class Immutable<T extends Entity>
    implements Predicate<T> {
        private final Predicate<T> predicate;

        Immutable(EntityPredicate<T> predicate) {
            this.predicate = predicate;
        }

        @Override
        public boolean test(T entity) {
            return this.predicate.test(entity);
        }

        @Override
        @NotNull
        public EntityPredicate<T> and(@NotNull Predicate<? super T> other) {
            return new EntityPredicate<T>(this.predicate).and((Predicate)other);
        }

        @Override
        @NotNull
        public EntityPredicate<T> or(@NotNull Predicate<? super T> other) {
            return new EntityPredicate<T>(this.predicate).or((Predicate)other);
        }
    }
}

