/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.integration.jei.recipe.staffcharging;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.OptionalInt;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.item.AoADataComponents;
import net.tslat.aoa3.content.item.datacomponent.StaffRuneCost;
import net.tslat.aoa3.content.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.content.recipe.StaffChargingRecipe;

public class JEIStaffChargingRecipe
extends StaffChargingRecipe {
    private final NonNullList<Ingredient> ingredients;
    private final ItemStack output;

    public JEIStaffChargingRecipe(Item staff) {
        super("", CraftingBookCategory.MISC, true);
        Object2IntMap<Item> runeCost = ((StaffRuneCost)staff.components().get((DataComponentType)AoADataComponents.STAFF_RUNE_COST.get())).runeCosts();
        this.ingredients = NonNullList.withSize((int)(runeCost.size() + 1), (Object)Ingredient.EMPTY);
        int i = 1;
        ItemStack chargedStaff = staff.getDefaultInstance();
        this.ingredients.set(0, (Object)Ingredient.of((ItemStack[])new ItemStack[]{staff.getDefaultInstance()}));
        chargedStaff.set(AoADataComponents.STORED_SPELL_CASTS, (Object)new BaseStaff.StoredCasts(1, OptionalInt.empty()));
        this.output = chargedStaff;
        for (Item item : runeCost.keySet()) {
            this.ingredients.set(i++, (Object)Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)item, runeCost.getInt((Object)item))}));
        }
    }

    @Override
    public boolean matches(CraftingInput input, Level level) {
        return super.matches(input, level);
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public ItemStack getResultItem(HolderLookup.Provider holderLookup) {
        return this.output;
    }

    @Override
    public ItemStack assemble(CraftingInput inventory, HolderLookup.Provider holderLookup) {
        return this.getResultItem(holderLookup).copy();
    }
}

