/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.integration.jei.recipe.infusion;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.library.util.RecipeUtil;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.content.recipe.InfusionRecipe;
import net.tslat.aoa3.util.LocaleUtil;

public class InfusionRecipeCategory
implements IRecipeCategory<InfusionRecipe> {
    public static final RecipeType<InfusionRecipe> RECIPE_TYPE = RecipeType.create((String)"aoa3", (String)"infusion", InfusionRecipe.class);
    public static final ResourceLocation ID = AdventOfAscension.id("infusion");
    private final Component title = LocaleUtil.getLocaleMessage("recipe.aoa3.infusion");
    private final IDrawable background;
    private final IDrawable icon;

    public InfusionRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation texture = AdventOfAscension.id("textures/gui/containers/infusion_table.png");
        this.background = guiHelper.createDrawable(texture, 10, 10, 156, 66);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)AoABlocks.INFUSION_TABLE.get()));
    }

    public RecipeType<InfusionRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, InfusionRecipe recipe, IFocusGroup focuses) {
        NonNullList<Ingredient> ingredients = recipe.getIngredients();
        builder.addSlot(RecipeIngredientRole.OUTPUT, 128, 25).addItemStack(RecipeUtil.getResultItem((Recipe)recipe));
        builder.addSlot(RecipeIngredientRole.INPUT, 7, 25).addIngredients(recipe.getInput());
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                IRecipeSlotBuilder slotBuilder = builder.addSlot(RecipeIngredientRole.INPUT, 35 + x * 18, 7 + y * 18);
                if (x + y * 3 >= ingredients.size()) continue;
                slotBuilder.addIngredients((Ingredient)ingredients.get(x + y * 3));
            }
        }
        builder.setShapeless();
    }
}

