/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.integration.jei.ingredient.type.imbuing;

import com.google.common.base.MoreObjects;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.common.util.RegistryUtil;
import mezz.jei.common.util.TagUtil;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ImbuingIngredientHelper(IIngredientType<EnchantmentInstance> ingredientType) implements IIngredientHelper<EnchantmentInstance>
{
    public IIngredientType<EnchantmentInstance> getIngredientType() {
        return this.ingredientType;
    }

    @NotNull
    public String getDisplayName(EnchantmentInstance ingredient) {
        return Enchantment.getFullname((Holder)ingredient.enchantment, (int)ingredient.level).getString();
    }

    public String getUniqueId(EnchantmentInstance ingredient, UidContext context) {
        return "enchantment:" + String.valueOf(this.getResourceLocation(ingredient)) + "_" + ingredient.level;
    }

    @NotNull
    public ResourceLocation getResourceLocation(EnchantmentInstance ingredient) {
        ResourceLocation id = RegistryUtil.getRegistry((ResourceKey)Registries.ENCHANTMENT).getKey((Object)((Enchantment)ingredient.enchantment.value()));
        if (id == null) {
            String ingredientInfo = this.getErrorInfo(ingredient);
            throw new IllegalStateException("Found unregistered enchantment: " + ingredientInfo);
        }
        return id;
    }

    @NotNull
    public ItemStack getCheatItemStack(EnchantmentInstance ingredient) {
        return EnchantedBookItem.createForEnchantment((EnchantmentInstance)ingredient);
    }

    @NotNull
    public EnchantmentInstance copyIngredient(EnchantmentInstance ingredient) {
        return new EnchantmentInstance(ingredient.enchantment, ingredient.level);
    }

    @NotNull
    public EnchantmentInstance normalizeIngredient(EnchantmentInstance ingredient) {
        return new EnchantmentInstance(ingredient.enchantment, 1);
    }

    @NotNull
    public Stream<ResourceLocation> getTagStream(EnchantmentInstance ingredient) {
        Registry registry = RegistryUtil.getRegistry((ResourceKey)Registries.ENCHANTMENT);
        return registry.getResourceKey((Object)((Enchantment)ingredient.enchantment.value())).flatMap(arg_0 -> ((Registry)registry).getHolder(arg_0)).map(Holder::tags).orElse(Stream.of(new TagKey[0])).map(TagKey::location);
    }

    @NotNull
    public Optional<TagKey<?>> getTagKeyEquivalent(Collection<EnchantmentInstance> ingredients) {
        return TagUtil.getTagEquivalent(ingredients, instance -> (Enchantment)instance.enchantment.value(), () -> ((Registry)RegistryUtil.getRegistry((ResourceKey)Registries.ENCHANTMENT)).getTags());
    }

    @NotNull
    public String getErrorInfo(@Nullable EnchantmentInstance ingredient) {
        if (ingredient == null) {
            return "null";
        }
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper(ingredient.getClass());
        Enchantment enchant = (Enchantment)ingredient.enchantment.value();
        if (enchant != null) {
            toStringHelper.add("Enchantment", (Object)this.getDisplayName(ingredient));
        } else {
            toStringHelper.add("Enchantment", (Object)"null");
        }
        toStringHelper.add("Level", ingredient.level);
        return toStringHelper.toString();
    }
}

