/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.integration.jei;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.AoARecipes;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.common.registration.entity.AoAMonsters;
import net.tslat.aoa3.common.registration.item.AoADataComponents;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.common.registration.item.AoATools;
import net.tslat.aoa3.content.recipe.ArcanumBatteryAttachRecipe;
import net.tslat.aoa3.content.recipe.AshfernCookingRecipe;
import net.tslat.aoa3.content.recipe.FrameBenchRecipe;
import net.tslat.aoa3.content.recipe.ImbuingRecipe;
import net.tslat.aoa3.content.recipe.InfusionRecipe;
import net.tslat.aoa3.content.recipe.StaffChargingRecipe;
import net.tslat.aoa3.content.recipe.ToolInteractionRecipe;
import net.tslat.aoa3.content.recipe.UpgradeKitRecipe;
import net.tslat.aoa3.content.recipe.WhitewashingRecipe;
import net.tslat.aoa3.integration.IntegrationManager;
import net.tslat.aoa3.integration.jei.ingredient.subtype.TornPagesSubtypeInterpreter;
import net.tslat.aoa3.integration.jei.ingredient.subtype.TrophySubtypeInterpreter;
import net.tslat.aoa3.integration.jei.ingredient.type.imbuing.ImbuingIngredientHelper;
import net.tslat.aoa3.integration.jei.ingredient.type.imbuing.ImbuingIngredientRenderer;
import net.tslat.aoa3.integration.jei.ingredient.type.imbuing.ImbuingIngredientType;
import net.tslat.aoa3.integration.jei.recipe.arcanumbatteryattach.ArcanumBatteryAttachRecipeExtension;
import net.tslat.aoa3.integration.jei.recipe.ashferncooking.AshfernCookingRecipeExtension;
import net.tslat.aoa3.integration.jei.recipe.framebench.FrameBenchRecipeCategory;
import net.tslat.aoa3.integration.jei.recipe.framebench.FrameBenchRecipeTransferInfo;
import net.tslat.aoa3.integration.jei.recipe.imbuing.ImbuingRecipeCategory;
import net.tslat.aoa3.integration.jei.recipe.imbuing.ImbuingRecipeTransferInfo;
import net.tslat.aoa3.integration.jei.recipe.infusion.InfusionRecipeCategory;
import net.tslat.aoa3.integration.jei.recipe.infusion.InfusionRecipeTransferInfo;
import net.tslat.aoa3.integration.jei.recipe.staffcharging.JEIStaffChargingRecipe;
import net.tslat.aoa3.integration.jei.recipe.staffcharging.StaffChargingRecipeExtension;
import net.tslat.aoa3.integration.jei.recipe.toolinteraction.ToolInteractionRecipeExtension;
import net.tslat.aoa3.integration.jei.recipe.upgradekit.UpgradeKitRecipeCategory;
import net.tslat.aoa3.integration.jei.recipe.upgradekit.UpgradeKitRecipeTransferInfo;
import net.tslat.aoa3.integration.jei.recipe.whitewashing.WhitewashingRecipeCategory;
import net.tslat.aoa3.integration.jei.recipe.whitewashing.WhitewashingRecipeTransferInfo;
import net.tslat.aoa3.integration.patchouli.PatchouliIntegration;
import net.tslat.aoa3.util.CodecUtil;
import net.tslat.aoa3.util.LocaleUtil;

@JeiPlugin
public class JEIIntegration
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return AdventOfAscension.id("core");
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        registration.register((IIngredientType)new ImbuingIngredientType(), List.of(), (IIngredientHelper)new ImbuingIngredientHelper((IIngredientType<EnchantmentInstance>)ImbuingIngredientType.INSTANCE), (IIngredientRenderer)new ImbuingIngredientRenderer(), CodecUtil.ENCHANTMENT_INSTANCE);
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
        registration.getCraftingCategory().addExtension(ToolInteractionRecipe.class, (ICraftingCategoryExtension)new ToolInteractionRecipeExtension());
        registration.getCraftingCategory().addExtension(AshfernCookingRecipe.class, (ICraftingCategoryExtension)new AshfernCookingRecipeExtension());
        registration.getCraftingCategory().addExtension(StaffChargingRecipe.class, (ICraftingCategoryExtension)new StaffChargingRecipeExtension());
        registration.getCraftingCategory().addExtension(ArcanumBatteryAttachRecipe.class, (ICraftingCategoryExtension)new ArcanumBatteryAttachRecipeExtension());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        if (!IntegrationManager.isJEIActive()) {
            return;
        }
        registration.addRecipeCatalyst((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)AoABlocks.DIVINE_STATION.get()), new RecipeType[]{UpgradeKitRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)AoABlocks.INFUSION_TABLE.get()), new RecipeType[]{InfusionRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)AoABlocks.IMBUING_CHAMBER.get()), new RecipeType[]{ImbuingRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)AoABlocks.FRAME_BENCH.get()), new RecipeType[]{FrameBenchRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)AoABlocks.WHITEWASHING_TABLE.get()), new RecipeType[]{WhitewashingRecipeCategory.RECIPE_TYPE});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        if (!IntegrationManager.isJEIActive()) {
            return;
        }
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new UpgradeKitRecipeTransferInfo());
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new ImbuingRecipeTransferInfo());
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new InfusionRecipeTransferInfo());
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new FrameBenchRecipeTransferInfo());
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new WhitewashingRecipeTransferInfo());
    }

    public void registerRecipes(IRecipeRegistration registration) {
        if (Minecraft.getInstance().getConnection() == null || !IntegrationManager.isJEIActive()) {
            return;
        }
        RecipeManager recipeManager = Minecraft.getInstance().getConnection().getRecipeManager();
        registration.addRecipes(UpgradeKitRecipeCategory.RECIPE_TYPE, this.compileUpgradeKitRecipes(recipeManager));
        registration.addRecipes(ImbuingRecipeCategory.RECIPE_TYPE, this.compileImbuingRecipes(recipeManager));
        registration.addRecipes(InfusionRecipeCategory.RECIPE_TYPE, this.compileInfusionRecipes(recipeManager));
        registration.addRecipes(FrameBenchRecipeCategory.RECIPE_TYPE, this.compileFrameBenchRecipes(recipeManager));
        registration.addRecipes(WhitewashingRecipeCategory.RECIPE_TYPE, this.compileWhitewashingRecipes(recipeManager));
        JEIIntegration.addInfoRecipes(registration);
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        jeiRuntime.getIngredientManager().addIngredientsAtRuntime((IIngredientType)ImbuingIngredientType.INSTANCE, jeiRuntime.getRecipeManager().createRecipeLookup(ImbuingRecipeCategory.RECIPE_TYPE).get().map(recipe -> new EnchantmentInstance((Holder)recipe.getEnchant().left(), recipe.getEnchant().rightInt())).toList());
        if (IntegrationManager.isPatchouliActive()) {
            jeiRuntime.getIngredientManager().addIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, PatchouliIntegration.getAoAPatchouliBooks());
        }
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        if (!IntegrationManager.isJEIActive()) {
            return;
        }
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        IModIdHelper idHelper = registration.getJeiHelpers().getModIdHelper();
        IIngredientManager ingredientHelper = registration.getJeiHelpers().getIngredientManager();
        registration.addRecipeCategories(new IRecipeCategory[]{new UpgradeKitRecipeCategory(guiHelper), new ImbuingRecipeCategory(guiHelper, idHelper, ingredientHelper), new InfusionRecipeCategory(guiHelper), new FrameBenchRecipeCategory(guiHelper), new WhitewashingRecipeCategory(guiHelper)});
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        if (!IntegrationManager.isJEIActive()) {
            return;
        }
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Block)AoABlocks.TROPHY.get()).asItem(), (ISubtypeInterpreter)TrophySubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Block)AoABlocks.GOLD_TROPHY.get()).asItem(), (ISubtypeInterpreter)TrophySubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Block)AoABlocks.ORNATE_TROPHY.get()).asItem(), (ISubtypeInterpreter)TrophySubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)AoAItems.TORN_PAGES.asItem(), (ISubtypeInterpreter)TornPagesSubtypeInterpreter.INSTANCE);
    }

    private List<UpgradeKitRecipe> compileUpgradeKitRecipes(RecipeManager recipeManager) {
        return recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)AoARecipes.UPGRADE_KIT.type().get()).stream().map(RecipeHolder::value).toList();
    }

    private List<WhitewashingRecipe> compileWhitewashingRecipes(RecipeManager recipeManager) {
        return recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)AoARecipes.WHITEWASHING.type().get()).stream().map(RecipeHolder::value).toList();
    }

    private List<StaffChargingRecipe> compileStaffChargingRecipes(RecipeManager recipeManager) {
        return BuiltInRegistries.ITEM.stream().filter(item -> item.components().has((DataComponentType)AoADataComponents.STORED_SPELL_CASTS.get()) && item.components().has((DataComponentType)AoADataComponents.STAFF_RUNE_COST.get())).map(JEIStaffChargingRecipe::new).map(StaffChargingRecipe.class::cast).toList();
    }

    private ArrayList<FrameBenchRecipe> compileFrameBenchRecipes(RecipeManager recipeManager) {
        ArrayList<FrameBenchRecipe> frameRecipes = new ArrayList<FrameBenchRecipe>(10);
        frameRecipes.add(new FrameBenchRecipe((ItemLike)AoAItems.CROSSBOW_FRAME));
        frameRecipes.add(new FrameBenchRecipe((ItemLike)AoAItems.BLASTER_FRAME));
        frameRecipes.add(new FrameBenchRecipe((ItemLike)AoAItems.CANNON_FRAME));
        frameRecipes.add(new FrameBenchRecipe((ItemLike)AoAItems.HELMET_FRAME));
        frameRecipes.add(new FrameBenchRecipe((ItemLike)AoAItems.CHESTPLATE_FRAME));
        frameRecipes.add(new FrameBenchRecipe((ItemLike)AoAItems.LEGGINGS_FRAME));
        frameRecipes.add(new FrameBenchRecipe((ItemLike)AoAItems.BOOTS_FRAME));
        frameRecipes.add(new FrameBenchRecipe((ItemLike)AoAItems.GUN_FRAME));
        frameRecipes.add(new FrameBenchRecipe((ItemLike)AoAItems.SHOTGUN_FRAME));
        frameRecipes.add(new FrameBenchRecipe((ItemLike)AoAItems.SNIPER_FRAME));
        return frameRecipes;
    }

    private List<ImbuingRecipe> compileImbuingRecipes(RecipeManager recipeManager) {
        return recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)AoARecipes.IMBUING.type().get()).stream().sorted(Comparator.comparing(RecipeHolder::id)).map(RecipeHolder::value).toList();
    }

    private List<InfusionRecipe> compileInfusionRecipes(RecipeManager recipeManager) {
        return recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)AoARecipes.INFUSION.type().get()).stream().map(RecipeHolder::value).toList();
    }

    private static void addInfoRecipes(IRecipeRegistration registration) {
        BiConsumer<Supplier, Component[]> infoRecipes = (item, entries) -> JEIIntegration.addItemDescription(registration, item, entries);
        infoRecipes.accept((Supplier)AoAItems.BARATHOS_REALMSTONE, new Component[]{Component.translatable((String)JEIIntegration.jeiInfoLocaleKey("realmstone.1")), Component.translatable((String)JEIIntegration.jeiInfoLocaleKey("realmstone.2"))});
        infoRecipes.accept((Supplier)AoAItems.PRECASIA_REALMSTONE, new Component[]{Component.translatable((String)JEIIntegration.jeiInfoLocaleKey("realmstone.1")), Component.translatable((String)JEIIntegration.jeiInfoLocaleKey("realmstone.2"))});
        infoRecipes.accept((Supplier)AoAItems.NOWHERE_REALMSTONE, new Component[]{Component.translatable((String)JEIIntegration.jeiInfoLocaleKey("realmstone.1")), Component.translatable((String)JEIIntegration.jeiInfoLocaleKey("realmstone.2"))});
        infoRecipes.accept((Supplier)AoAItems.NETHER_REALMSTONE, new Component[]{Component.translatable((String)JEIIntegration.jeiInfoLocaleKey("realmstone.1")), Component.translatable((String)JEIIntegration.jeiInfoLocaleKey("realmstone.2"))});
        infoRecipes.accept((Supplier)AoAItems.TROLL_IDOL, new Component[]{Component.translatable((String)JEIIntegration.jeiInfoLocaleKey("boss_totem.1"), (Object[])new Object[]{((EntityType)AoAMonsters.SMASH.get()).getDescription()}), Component.translatable((String)JEIIntegration.jeiInfoLocaleKey("troll_idol")), Component.translatable((String)JEIIntegration.jeiInfoLocaleKey("boss_totem.2"))});
        infoRecipes.accept((Supplier)AoAItems.BONE_HORN, new Component[]{Component.translatable((String)JEIIntegration.jeiInfoLocaleKey("boss_totem.1"), (Object[])new Object[]{((EntityType)AoAMonsters.TYROSAUR.get()).getDescription()}), Component.translatable((String)JEIIntegration.jeiInfoLocaleKey("bone_horn")), Component.translatable((String)JEIIntegration.jeiInfoLocaleKey("boss_totem.2"))});
        infoRecipes.accept((Supplier)AoAItems.WARPED_HORN, new Component[]{Component.translatable((String)JEIIntegration.jeiInfoLocaleKey("boss_totem.1"), (Object[])new Object[]{((EntityType)AoAMonsters.SKELETRON.get()).getDescription()}), Component.translatable((String)JEIIntegration.jeiInfoLocaleKey("boss_totem.2"))});
        infoRecipes.accept((Supplier)AoAItems.EXPLOSIVE_IDOL, new Component[]{Component.translatable((String)JEIIntegration.jeiInfoLocaleKey("boss_totem.1"), (Object[])new Object[]{((EntityType)AoAMonsters.KING_BAMBAMBAM.get()).getDescription()}), Component.translatable((String)JEIIntegration.jeiInfoLocaleKey("boss_totem.2"))});
        infoRecipes.accept((Supplier)AoAItems.NETHENGEIC_CALLSTONE, new Component[]{Component.translatable((String)JEIIntegration.jeiInfoLocaleKey("boss_totem.1"), (Object[])new Object[]{((EntityType)AoAMonsters.NETHENGEIC_WITHER.get()).getDescription()}), Component.translatable((String)JEIIntegration.jeiInfoLocaleKey("nethengeic_callstone")), Component.translatable((String)JEIIntegration.jeiInfoLocaleKey("boss_totem.2"))});
        infoRecipes.accept(() -> ((Block)((Block)AoABlocks.GOLD_TROPHY.get())).asItem(), new Component[]{Component.translatable((String)JEIIntegration.jeiInfoLocaleKey("trophy"))});
        infoRecipes.accept(() -> ((Block)((Block)AoABlocks.CARVED_RUNE_OF_DIRECTION.get())).asItem(), new Component[]{Component.translatable((String)JEIIntegration.jeiInfoLocaleKey("portal_frame_block"))});
        infoRecipes.accept(() -> ((Block)((Block)AoABlocks.TEA_SINK.get())).asItem(), new Component[]{Component.translatable((String)JEIIntegration.jeiInfoLocaleKey("tea_sink"))});
        infoRecipes.accept(() -> ((Block)((Block)AoABlocks.RUNE_RANDOMIZER.get())).asItem(), new Component[]{Component.translatable((String)JEIIntegration.jeiInfoLocaleKey("rune_randomizer"))});
        infoRecipes.accept(() -> ((Block)((Block)AoABlocks.INFUSED_PRESS.get())).asItem(), new Component[]{Component.translatable((String)JEIIntegration.jeiInfoLocaleKey("infused_press"))});
        infoRecipes.accept(() -> ((Block)((Block)AoABlocks.TINKERERS_TABLE.get())).asItem(), new Component[]{Component.translatable((String)JEIIntegration.jeiInfoLocaleKey("tinkerers_table"))});
        infoRecipes.accept(() -> ((Block)((Block)AoABlocks.LUNAR_CREATION_TABLE.get())).asItem(), new Component[]{Component.translatable((String)JEIIntegration.jeiInfoLocaleKey("lunar_creation_table"))});
        infoRecipes.accept(() -> ((Block)((Block)AoABlocks.MENDING_TABLE.get())).asItem(), new Component[]{Component.translatable((String)JEIIntegration.jeiInfoLocaleKey("mending_table"))});
        infoRecipes.accept((Supplier)AoAItems.MAGIC_REPAIR_DUST, new Component[]{Component.translatable((String)JEIIntegration.jeiInfoLocaleKey("magic_repair_dust"))});
        infoRecipes.accept((Supplier)AoAItems.MAGIC_MENDING_COMPOUND, new Component[]{Component.translatable((String)JEIIntegration.jeiInfoLocaleKey("magic_mending_compound"))});
        infoRecipes.accept(() -> ((Block)((Block)AoABlocks.BOSS_ALTAR.get())).asItem(), new Component[]{Component.translatable((String)JEIIntegration.jeiInfoLocaleKey("boss_altar"))});
        infoRecipes.accept((Supplier)AoATools.ATTUNING_BOWL, new Component[]{Component.translatable((String)JEIIntegration.jeiInfoLocaleKey("attuning_bowl"))});
        infoRecipes.accept((Supplier)AoAItems.AMBIENT_ENERGY_STONE, new Component[]{Component.translatable((String)JEIIntegration.jeiInfoLocaleKey("energy_stone"))});
        infoRecipes.accept((Supplier)AoAItems.GLISTENING_ENERGY_STONE, new Component[]{Component.translatable((String)JEIIntegration.jeiInfoLocaleKey("energy_stone"))});
        infoRecipes.accept((Supplier)AoAItems.BLOOMING_ENERGY_STONE, new Component[]{Component.translatable((String)JEIIntegration.jeiInfoLocaleKey("energy_stone"))});
        infoRecipes.accept((Supplier)AoAItems.SHINING_ENERGY_STONE, new Component[]{Component.translatable((String)JEIIntegration.jeiInfoLocaleKey("energy_stone"))});
        infoRecipes.accept((Supplier)AoAItems.GLEAMING_ENERGY_STONE, new Component[]{Component.translatable((String)JEIIntegration.jeiInfoLocaleKey("energy_stone"))});
        infoRecipes.accept((Supplier)AoAItems.GLOWING_ENERGY_STONE, new Component[]{Component.translatable((String)JEIIntegration.jeiInfoLocaleKey("energy_stone"))});
        infoRecipes.accept((Supplier)AoAItems.GLARING_ENERGY_STONE, new Component[]{Component.translatable((String)JEIIntegration.jeiInfoLocaleKey("energy_stone"))});
        infoRecipes.accept((Supplier)AoAItems.RADIANT_ENERGY_STONE, new Component[]{Component.translatable((String)JEIIntegration.jeiInfoLocaleKey("energy_stone"))});
        infoRecipes.accept((Supplier)AoAItems.CHUM, new Component[]{Component.translatable((String)JEIIntegration.jeiInfoLocaleKey("chum"))});
    }

    private static void addItemDescription(IRecipeRegistration registration, Supplier<Item> item, Component ... description) {
        registration.addItemStackInfo(item.get().getDefaultInstance(), description);
    }

    public static String jeiInfoLocaleKey(String subPath) {
        return LocaleUtil.createGenericLocaleKey("description.jei", subPath);
    }
}

