/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.integration;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import net.minecraft.Util;
import net.neoforged.fml.ModList;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.integration.patchouli.PatchouliIntegration;
import net.tslat.aoa3.integration.tes.TESIntegration;

public class IntegrationManager {
    public static final String JEI = "jei";
    public static final String PATCHOULI = "patchouli";
    public static final String TES = "tslatentitystatus";
    private static final Map<String, CallableIntegration> INTEGRATIONS = (Map)Util.make((Object)new Object2ObjectOpenHashMap(), map -> {
        map.put((Object)JEI, (Object)new CallableIntegration(JEI, () -> {}, () -> {}, () -> {}));
        map.put((Object)PATCHOULI, (Object)new CallableIntegration(PATCHOULI, PatchouliIntegration::preInit, () -> {}, () -> {}));
        map.put((Object)TES, (Object)new CallableIntegration(TES, () -> {}, () -> {}, TESIntegration::clientInit));
    });

    public static boolean isModPresent(String modId) {
        return ModList.get().isLoaded(modId);
    }

    public static boolean isJEIActive() {
        return INTEGRATIONS.get(JEI).enabled();
    }

    public static boolean isPatchouliActive() {
        return INTEGRATIONS.get(PATCHOULI).enabled();
    }

    public static boolean isTESActive() {
        return INTEGRATIONS.get(TES).enabled();
    }

    public static void init() {
        Logging.logStatusMessage("Checking for third-party integrations");
        IntegrationManager.callSetupStage(integration -> {
            Logging.logStatusMessage("Found '" + integration.modId() + "', integrating");
            return integration.init();
        });
    }

    public static void lateInit() {
        IntegrationManager.callSetupStage(CallableIntegration::postInit);
    }

    public static void clientInit() {
        IntegrationManager.callSetupStage(CallableIntegration::clientInit);
    }

    private static void callSetupStage(Function<CallableIntegration, Runnable> stageTask) {
        for (Map.Entry<String, CallableIntegration> entry : INTEGRATIONS.entrySet()) {
            if (!entry.getValue().enabled()) continue;
            Logging.logStatusMessage("Found '" + entry.getKey() + "', integrating");
            stageTask.apply(entry.getValue()).run();
        }
    }

    public record CallableIntegration(String modId, BooleanSupplier isActive, Runnable init, Runnable postInit, Runnable clientInit) {
        public CallableIntegration(String modId, Runnable init, Runnable postInit, Runnable clientInit) {
            this(modId, () -> IntegrationManager.isModPresent(modId), init, postInit, clientInit);
        }

        public boolean enabled() {
            return this.isActive.getAsBoolean();
        }
    }
}

