/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.event.dimension;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MinecartItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.AoAConfigs;
import net.tslat.aoa3.common.registration.AoATags;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.common.registration.worldgen.AoADimensions;
import net.tslat.aoa3.content.block.functional.misc.CheckpointBlock;
import net.tslat.aoa3.content.block.functional.portal.NowhereActivityPortal;
import net.tslat.aoa3.content.block.functional.utility.TeaSink;
import net.tslat.aoa3.content.entity.boss.AoABoss;
import net.tslat.aoa3.library.builder.SoundBuilder;
import net.tslat.aoa3.library.constant.BossDropsScheme;
import net.tslat.aoa3.library.object.PositionAndRotation;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.scheduling.AoAScheduler;
import net.tslat.aoa3.util.AdvancementUtil;
import net.tslat.aoa3.util.InventoryUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;

public final class NowhereEvents {
    public static boolean isInParkourRegion(BlockPos pos) {
        return pos.getX() > 900 && pos.getZ() > 900;
    }

    public static boolean isInBossRegion(BlockPos pos) {
        return pos.getX() < -500 && pos.getZ() < -500;
    }

    public static boolean isInFoodFreeRegion(BlockPos pos) {
        return pos.getX() > 0 && pos.getZ() > 0;
    }

    public static boolean isInLobbyRegion(BlockPos pos) {
        return pos.getX() < 250 && pos.getZ() < 250 && pos.getX() > -250 && pos.getZ() > -250;
    }

    public static void doPlayerTick(PlayerTickEvent ev) {
        Player pl = ev.getEntity();
        if (ev instanceof PlayerTickEvent.Pre) {
            AoABoss boss;
            List bosses;
            if (pl instanceof ServerPlayer) {
                ServerPlayer serverPl = (ServerPlayer)pl;
                if (NowhereEvents.isInParkourRegion(serverPl.blockPosition())) {
                    if (PlayerUtil.shouldPlayerBeAffected((Player)serverPl)) {
                        PlayerUtil.getAdventPlayer((ServerPlayer)serverPl).stats.setInAbilityLockRegion();
                    }
                } else {
                    PlayerUtil.getAdventPlayer((ServerPlayer)serverPl).stats.leaveAbilityLockRegion();
                }
            } else if (NowhereEvents.isInBossRegion(pl.blockPosition()) && !(bosses = EntityRetrievalUtil.getEntities((Entity)pl, (double)80.0, entity -> entity instanceof AoABoss)).isEmpty() && (boss = (AoABoss)bosses.getFirst()).getMusic() != null) {
                new SoundBuilder(boss.getMusic()).isMusic().include(pl).execute();
            }
        } else {
            pl.getAbilities().mayBuild = pl.isCreative();
            if (PlayerUtil.shouldPlayerBeAffected(pl)) {
                if (pl.getY() < (double)pl.level().getMinBuildHeight()) {
                    pl.fallDistance = -1.0f;
                    if (pl instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)pl;
                        if (!AdvancementUtil.isAdvancementCompleted(serverPlayer, AdventOfAscension.id("nowhere/root"))) {
                            AoAScheduler.scheduleSyncronisedTask(() -> {
                                PlayerUtil.resetToDefaultStatus(serverPlayer);
                                InventoryUtil.clearItems(serverPlayer, new ItemLike[]{AoAItems.RETURN_CRYSTAL});
                                serverPlayer.sendSystemMessage((Component)LocaleUtil.getLocaleMessage("deathScreen.title", ChatFormatting.DARK_RED, new Component[0]));
                                serverPlayer.connection.teleport(17.5, 452.5, 3.5, 0.0f, serverPlayer.getXRot());
                            }, 1);
                        } else {
                            ServerPlayerDataManager plData = PlayerUtil.getAdventPlayer(serverPlayer);
                            PositionAndRotation checkpoint = plData.storage.getActiveCheckpoint();
                            if (checkpoint != null) {
                                if (CheckpointBlock.isValidCheckpoint(serverPlayer.level(), checkpoint)) {
                                    AoAScheduler.scheduleSyncronisedTask(() -> {
                                        if (NowhereEvents.isInBossRegion(serverPlayer.blockPosition())) {
                                            InventoryUtil.clearItems(serverPlayer, new ItemLike[]{AoAItems.RETURN_CRYSTAL});
                                        }
                                        PlayerUtil.resetToDefaultStatus(serverPlayer);
                                        if (!NowhereEvents.isInParkourRegion(serverPlayer.blockPosition())) {
                                            serverPlayer.sendSystemMessage((Component)LocaleUtil.getLocaleMessage("deathScreen.title", ChatFormatting.DARK_RED, new Component[0]));
                                        }
                                        serverPlayer.sendSystemMessage((Component)LocaleUtil.getLocaleMessage(LocaleUtil.createFeedbackLocaleKey("checkpoint.respawn"), ChatFormatting.GREEN, new Component[0]), true);
                                        checkpoint.applyToEntity((Entity)serverPlayer);
                                    }, 1);
                                    return;
                                }
                                plData.storage.clearActiveCheckpoint();
                                serverPlayer.sendSystemMessage((Component)LocaleUtil.getLocaleMessage(LocaleUtil.createFeedbackLocaleKey("checkpoint.invalid"), ChatFormatting.RED, new Component[0]));
                            } else {
                                NowhereActivityPortal.Activity.RETURN.activate((ServerPlayer)pl);
                            }
                        }
                    }
                }
                if (pl.isFallFlying()) {
                    pl.stopFallFlying();
                }
                if (NowhereEvents.isInFoodFreeRegion(pl.blockPosition())) {
                    FoodData foodData = pl.getFoodData();
                    foodData.setExhaustion(-4.0f);
                    foodData.setFoodLevel(20);
                    foodData.setSaturation(20.0f);
                }
            }
        }
    }

    public static void doDimensionChange(PlayerEvent.PlayerChangedDimensionEvent ev) {
        Player player = ev.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer pl = (ServerPlayer)player;
            ServerPlayerDataManager plData = PlayerUtil.getAdventPlayer(pl);
            if (ev.getFrom() == AoADimensions.NOWHERE) {
                plData.storage.restoreFoodData();
                plData.storage.returnStoredItems();
                plData.storage.clearActiveCheckpoint();
                InventoryUtil.clearItems(pl, new ItemLike[]{AoAItems.RETURN_CRYSTAL});
                pl.gameMode.getGameModeForPlayer().updatePlayerAbilities(pl.getAbilities());
            } else {
                plData.storage.saveFoodData();
            }
        }
    }

    public static void doDeathPrevention(LivingDamageEvent.Pre ev, ServerPlayerDataManager plData) {
        ServerPlayer player = plData.getPlayer();
        LivingEntity killer = player.getKillCredit();
        player.getScoreboard().forAllObjectives(ObjectiveCriteria.DEATH_COUNT, (ScoreHolder)player, ScoreAccess::increment);
        if (killer != null) {
            player.awardStat(Stats.ENTITY_KILLED_BY.get((Object)killer.getType()));
            killer.awardKillScore((Entity)player, 1, ev.getContainer().getSource());
        }
        player.awardStat(Stats.DEATHS);
        player.resetStat(Stats.CUSTOM.get((Object)Stats.TIME_SINCE_DEATH));
        player.resetStat(Stats.CUSTOM.get((Object)Stats.TIME_SINCE_REST));
        if (!AdvancementUtil.isAdvancementCompleted(player, AdventOfAscension.id("nowhere/root"))) {
            AoAScheduler.scheduleSyncronisedTask(() -> {
                PlayerUtil.resetToDefaultStatus(player);
                player.connection.teleport(17.5, 452.5, 3.5, 0.0f, player.getXRot());
                InventoryUtil.clearItems(player, new ItemLike[]{AoAItems.RETURN_CRYSTAL});
                PlayerUtil.getAdventPlayer((ServerPlayer)player).storage.returnStoredItems();
            }, 1);
        } else {
            NowhereActivityPortal.Activity.RETURN.activate(plData.getPlayer());
        }
        player.sendSystemMessage((Component)LocaleUtil.getLocaleMessage("deathScreen.title", ChatFormatting.DARK_RED, new Component[0]));
        ev.getContainer().setNewDamage(0.0f);
    }

    public static void handleNowhereRightClickItem(PlayerInteractEvent.RightClickItem ev) {
        Item item = ev.getItemStack().getItem();
        if (item instanceof MinecartItem || item instanceof BoatItem) {
            ev.setCanceled(true);
        }
    }

    public static void handleNowhereRightClickEntity(PlayerInteractEvent.EntityInteract ev) {
        if (ev.getTarget() instanceof ItemFrame) {
            ev.setCanceled(true);
        }
    }

    public static void handleNowhereLeftClickEntity(AttackEntityEvent ev) {
        if (ev.getTarget() instanceof ItemFrame) {
            ev.setCanceled(true);
        }
    }

    public static void handleNowhereRightClickBlock(PlayerInteractEvent.RightClickBlock ev) {
        BlockState blockState = ev.getLevel().getBlockState(ev.getPos());
        Block block = blockState.getBlock();
        ItemStack heldStack = ev.getEntity().getItemInHand(ev.getHand());
        Item heldItem = heldStack.getItem();
        if (block == Blocks.JUKEBOX) {
            if (heldItem == Items.AIR || heldStack.has(DataComponents.JUKEBOX_PLAYABLE)) {
                ev.setUseItem(TriState.TRUE);
                ev.setUseBlock(TriState.TRUE);
                ev.getEntity().getAbilities().mayBuild = true;
            }
        } else if (blockState.is(AoATags.Blocks.NOWHERE_SAFE_GUI_BLOCK)) {
            ev.setUseItem(TriState.FALSE);
        } else if (block == Blocks.WATER_CAULDRON) {
            ev.setUseItem(TriState.FALSE);
            AoAScheduler.scheduleSyncronisedTask(() -> ev.getLevel().setBlock(ev.getPos(), (BlockState)blockState.setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(3)), 2), 1);
        } else if (block == AoABlocks.TEA_SINK.get()) {
            ev.setUseItem(TriState.FALSE);
            AoAScheduler.scheduleSyncronisedTask(() -> ev.getLevel().setBlock(ev.getPos(), (BlockState)blockState.setValue((Property)TeaSink.FILLED, (Comparable)Boolean.valueOf(true)), 2), 1);
        } else if (heldItem == AoAItems.LOTTO_TOTEM.get()) {
            ev.setUseItem(TriState.TRUE);
            ev.setUseBlock(TriState.FALSE);
            ev.getEntity().getAbilities().mayBuild = true;
        } else {
            ev.setCanceled(true);
        }
    }

    public static void handleLoot(LivingDropsEvent ev) {
        if (!(ev.getEntity() instanceof AoABoss) || ev.isCanceled()) {
            ev.setCanceled(true);
            return;
        }
        ((BossDropsScheme)((Object)AoAConfigs.SERVER.bossDropsScheme.get())).handleDrops(ev);
    }
}

