/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.event;

import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.entity.EntityMobGriefingEvent;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;
import net.neoforged.neoforge.event.entity.living.LivingConversionEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;
import net.tslat.aoa3.common.registration.worldgen.AoADimensions;
import net.tslat.aoa3.content.entity.base.AoATrader;
import net.tslat.aoa3.data.server.AoASkillReqReloadListener;
import net.tslat.aoa3.event.dimension.NowhereEvents;
import net.tslat.aoa3.player.PlayerDataManager;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.aoa3.util.WorldUtil;

public final class RestrictionEventHandler {
    public static void preInit() {
        RestrictionEventHandler.cancelEventIf(EntityTeleportEvent.EnderPearl.class, ev -> ev.getTargetY() >= (double)ev.getEntity().level().dimensionType().logicalHeight(), new Predicate[0]);
        RestrictionEventHandler.cancelEventIf(LivingConversionEvent.Pre.class, ev -> ev.getEntity() instanceof AoATrader, new Predicate[0]);
        RestrictionEventHandler.cancelEventIf(PlayerEvent.BreakSpeed.class, ev -> WorldUtil.isWorld(ev.getEntity().level(), AoADimensions.NOWHERE), new Predicate[0]);
        RestrictionEventHandler.cancelEventIf(BlockEvent.FluidPlaceBlockEvent.class, ev -> WorldUtil.isWorld((Level)ev.getLevel(), AoADimensions.NOWHERE), new Predicate[0]);
        RestrictionEventHandler.cancelEventIf(PlayerInteractEvent.RightClickItem.class, ev -> WorldUtil.isWorld(ev.getLevel(), AoADimensions.NOWHERE) && !ev.getEntity().getAbilities().instabuild && ev.getItemStack().is(Tags.Items.BUCKETS), new Predicate[0]);
        RestrictionEventHandler.cancelEventIf(BlockEvent.BreakEvent.class, ev -> !ev.getPlayer().getAbilities().instabuild && (WorldUtil.isWorld((Level)ev.getLevel(), AoADimensions.NOWHERE) || !AoASkillReqReloadListener.canBreakBlock(PlayerUtil.getAdventPlayer(ev.getPlayer()), ev.getState().getBlock(), true)), new Predicate[0]);
        RestrictionEventHandler.cancelEventIf(BlockEvent.EntityPlaceEvent.class, ev -> {
            Entity patt0$temp = ev.getEntity();
            if (!(patt0$temp instanceof Player)) return false;
            Player pl = (Player)patt0$temp;
            if (pl.getAbilities().instabuild) return false;
            if (WorldUtil.isWorld((Level)ev.getLevel(), AoADimensions.NOWHERE)) return true;
            if (AoASkillReqReloadListener.canPlaceBlock(PlayerUtil.getAdventPlayer((Player)ev.getEntity()), ev.getState().getBlock(), true)) return false;
            return true;
        }, new Predicate[0]);
        RestrictionEventHandler.handleEventIf(EntityMobGriefingEvent.class, ev -> ev.setCanGrief(false), ev -> WorldUtil.isWorld(ev.getEntity().level(), AoADimensions.NOWHERE), new Predicate[0]);
        RestrictionEventHandler.handleEventIf(PlayerInteractEvent.RightClickBlock.class, RestrictionEventHandler::handleRightClickBlock, ev -> !WorldUtil.isWorld(ev.getEntity().level(), AoADimensions.NOWHERE) && !ev.getEntity().getAbilities().instabuild, new Predicate[0]);
        RestrictionEventHandler.handleEventIf(PlayerInteractEvent.RightClickBlock.class, NowhereEvents::handleNowhereRightClickBlock, ev -> WorldUtil.isWorld(ev.getEntity().level(), AoADimensions.NOWHERE) && !ev.getEntity().getAbilities().instabuild, new Predicate[0]);
        RestrictionEventHandler.handleEventIf(PlayerInteractEvent.EntityInteract.class, NowhereEvents::handleNowhereRightClickEntity, ev -> WorldUtil.isWorld(ev.getEntity().level(), AoADimensions.NOWHERE) && !ev.getEntity().getAbilities().instabuild, new Predicate[0]);
        RestrictionEventHandler.handleEventIf(AttackEntityEvent.class, NowhereEvents::handleNowhereLeftClickEntity, ev -> WorldUtil.isWorld(ev.getEntity().level(), AoADimensions.NOWHERE) && !ev.getEntity().getAbilities().instabuild, new Predicate[0]);
        RestrictionEventHandler.handleEventIf(PlayerInteractEvent.RightClickItem.class, NowhereEvents::handleNowhereRightClickItem, ev -> WorldUtil.isWorld(ev.getEntity().level(), AoADimensions.NOWHERE) && !ev.getEntity().getAbilities().instabuild, new Predicate[0]);
        RestrictionEventHandler.handleEventIf(EntityTeleportEvent.class, ev -> {
            RestrictionEventHandler.cancelEvent(ev);
            PlayerUtil.notifyPlayer((Player)ev.getEntity(), (Component)Component.translatable((String)LocaleUtil.createFeedbackLocaleKey("nowhere.teleport")));
        }, ev -> {
            if (!WorldUtil.isWorld(ev.getEntity().level(), AoADimensions.NOWHERE)) return false;
            Entity patt0$temp = ev.getEntity();
            if (!(patt0$temp instanceof Player)) return false;
            Player pl = (Player)patt0$temp;
            if (pl.getAbilities().instabuild) return false;
            if (ev instanceof EntityTeleportEvent.TeleportCommand) return false;
            if (ev instanceof EntityTeleportEvent.SpreadPlayersCommand) return false;
            return true;
        }, new Predicate[0]);
        RestrictionEventHandler.handleEventIf(ExplosionEvent.Detonate.class, ev -> ev.getAffectedBlocks().clear(), ev -> WorldUtil.isWorld(ev.getLevel(), AoADimensions.NOWHERE), new Predicate[0]);
        RestrictionEventHandler.handleEventIf(LivingDropsEvent.class, NowhereEvents::handleLoot, ev -> WorldUtil.isWorld(ev.getEntity().level(), AoADimensions.NOWHERE), new Predicate[0]);
    }

    private static void handleRightClickBlock(PlayerInteractEvent.RightClickBlock ev) {
        Item item;
        Level world = ev.getLevel();
        PlayerDataManager plData = PlayerUtil.getAdventPlayer(ev.getEntity());
        if (!AoASkillReqReloadListener.canInteractWith(plData, world.getBlockState(ev.getPos()).getBlock(), true)) {
            ev.setUseBlock(TriState.FALSE);
        }
        if ((item = ev.getItemStack().getItem()) instanceof BlockItem && !AoASkillReqReloadListener.canPlaceBlock(plData, ((BlockItem)item).getBlock(), true)) {
            ev.setUseItem(TriState.FALSE);
        }
    }

    private static <T extends Event> void handleEvent(Class<T> eventClass, Consumer<T> handler) {
        NeoForge.EVENT_BUS.addListener(EventPriority.HIGHEST, false, eventClass, handler);
    }

    private static <T extends Event> void handleEventIf(Class<T> eventClass, Consumer<T> handler, Predicate<T> basePredicate, Predicate<T> ... predicates) {
        RestrictionEventHandler.handleEvent(eventClass, RestrictionEventHandler.wrapEventConditionally(RestrictionEventHandler.or(basePredicate, predicates), handler));
    }

    private static <T extends Event> void cancelEventIf(Class<T> eventClass, Predicate<T> basePredicate, Predicate<T> ... predicates) {
        RestrictionEventHandler.handleEvent(eventClass, RestrictionEventHandler.wrapEventConditionally(RestrictionEventHandler.or(basePredicate, predicates), x$0 -> RestrictionEventHandler.cancelEvent((Event)x$0)));
    }

    private static <T extends Event> void cancelEvent(T ev) {
        if (ev instanceof ICancellableEvent) {
            ICancellableEvent cancellableEvent = (ICancellableEvent)ev;
            cancellableEvent.setCanceled(true);
        }
    }

    private static <T extends Event> Predicate<T> and(Predicate<T> basePredicate, Predicate<T> ... predicates) {
        for (Predicate<T> predicate : predicates) {
            basePredicate = basePredicate.and(predicate);
        }
        return basePredicate;
    }

    private static <T extends Event> Predicate<T> or(Predicate<T> basePredicate, Predicate<T> ... predicates) {
        for (Predicate<T> predicate : predicates) {
            basePredicate = basePredicate.or(predicate);
        }
        return basePredicate;
    }

    private static <T extends Event> Consumer<T> wrapEventConditionally(Predicate<T> predicate, Consumer<T> handler) {
        return t -> {
            if (predicate.test(t)) {
                handler.accept(t);
            }
        };
    }
}

