/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.event;

import it.unimi.dsi.fastutil.Pair;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.entity.item.ItemTossEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.CriticalHitEvent;
import net.neoforged.neoforge.event.entity.player.ItemFishedEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.entity.player.PlayerXpEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.fluids.FluidType;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.common.registration.AoAAttributes;
import net.tslat.aoa3.common.registration.item.AoAArmourMaterials;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.common.registration.worldgen.AoADimensions;
import net.tslat.aoa3.content.block.functional.misc.CheckpointBlock;
import net.tslat.aoa3.content.entity.boss.AoABoss;
import net.tslat.aoa3.content.item.misc.ReservedItem;
import net.tslat.aoa3.content.item.tool.artifice.ExpFlask;
import net.tslat.aoa3.content.item.weapon.sword.BaseSword;
import net.tslat.aoa3.content.world.event.AoAWorldEventManager;
import net.tslat.aoa3.event.dimension.LelyetiaEvents;
import net.tslat.aoa3.event.dimension.LunalusEvents;
import net.tslat.aoa3.event.dimension.NowhereEvents;
import net.tslat.aoa3.event.dimension.VoxPondsEvents;
import net.tslat.aoa3.library.object.PositionAndRotation;
import net.tslat.aoa3.library.object.Text;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.scheduling.AoAScheduler;
import net.tslat.aoa3.util.AdvancementUtil;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.InventoryUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.aoa3.util.WorldUtil;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;
import net.tslat.smartbrainlib.util.RandomUtil;

public class PlayerEvents {
    public static void preInit() {
        IEventBus forgeBus = NeoForge.EVENT_BUS;
        forgeBus.addListener(EventPriority.NORMAL, false, PlayerTickEvent.Pre.class, PlayerEvents::onPlayerTickStart);
        forgeBus.addListener(EventPriority.NORMAL, false, PlayerTickEvent.Post.class, PlayerEvents::onPlayerTickEnd);
        forgeBus.addListener(EventPriority.NORMAL, false, LivingEvent.LivingJumpEvent.class, PlayerEvents::onPlayerJump);
        forgeBus.addListener(EventPriority.NORMAL, false, LivingIncomingDamageEvent.class, PlayerEvents::onPlayerDamage);
        forgeBus.addListener(EventPriority.LOWEST, false, LivingDamageEvent.Pre.class, PlayerEvents::onPlayerDamagedPre);
        forgeBus.addListener(EventPriority.NORMAL, false, LivingDamageEvent.Post.class, PlayerEvents::onPlayerDamagedPost);
        forgeBus.addListener(EventPriority.NORMAL, false, CriticalHitEvent.class, PlayerEvents::onCriticalHit);
        forgeBus.addListener(EventPriority.LOWEST, false, LivingDeathEvent.class, PlayerEvents::onEntityDeath);
        forgeBus.addListener(EventPriority.NORMAL, false, LivingFallEvent.class, PlayerEvents::onPlayerFall);
        forgeBus.addListener(EventPriority.NORMAL, false, BlockEvent.BreakEvent.class, PlayerEvents::onBlockBreak);
        forgeBus.addListener(EventPriority.NORMAL, false, BlockEvent.EntityPlaceEvent.class, PlayerEvents::onBlockPlace);
        forgeBus.addListener(EventPriority.NORMAL, false, PlayerInteractEvent.RightClickBlock.class, PlayerEvents::onBlockInteract);
        forgeBus.addListener(EventPriority.NORMAL, false, PlayerEvent.PlayerLoggedInEvent.class, PlayerEvents::onPlayerLogin);
        forgeBus.addListener(EventPriority.NORMAL, false, ItemTossEvent.class, PlayerEvents::onItemToss);
        forgeBus.addListener(EventPriority.NORMAL, false, PlayerXpEvent.PickupXp.class, PlayerEvents::onPlayerPickupXp);
        forgeBus.addListener(EventPriority.NORMAL, false, ItemFishedEvent.class, PlayerEvents::onPlayerFishing);
        forgeBus.addListener(EventPriority.NORMAL, false, PlayerEvent.PlayerChangedDimensionEvent.class, PlayerEvents::onDimensionChange);
    }

    private static void onPlayerTickStart(PlayerTickEvent.Pre ev) {
        if (WorldUtil.isWorld(ev.getEntity().level(), AoADimensions.NOWHERE)) {
            NowhereEvents.doPlayerTick((PlayerTickEvent)ev);
        }
    }

    private static void onPlayerTickEnd(PlayerTickEvent.Post ev) {
        if (WorldUtil.isWorld(ev.getEntity().level(), AoADimensions.LELYETIA)) {
            LelyetiaEvents.doPlayerTick(ev.getEntity());
        } else if (WorldUtil.isWorld(ev.getEntity().level(), AoADimensions.VOX_PONDS)) {
            VoxPondsEvents.doPlayerTick(ev.getEntity());
        } else if (WorldUtil.isWorld(ev.getEntity().level(), AoADimensions.LUNALUS)) {
            LunalusEvents.doPlayerTick(ev.getEntity());
        }
        if (WorldUtil.isWorld(ev.getEntity().level(), AoADimensions.NOWHERE)) {
            NowhereEvents.doPlayerTick((PlayerTickEvent)ev);
        }
    }

    private static void onPlayerJump(LivingEvent.LivingJumpEvent ev) {
        if (WorldUtil.isWorld(ev.getEntity().level(), AoADimensions.LUNALUS) && ev.getEntity() instanceof Player) {
            LunalusEvents.doPlayerJump((Player)ev.getEntity());
        }
    }

    private static void onCriticalHit(CriticalHitEvent ev) {
        if (ev.isCriticalHit()) {
            ev.setDamageMultiplier(ev.getDamageMultiplier() * (float)ev.getEntity().getAttributeValue(AoAAttributes.CRITICAL_HIT_MULTIPLIER));
        }
    }

    private static void onPlayerDamagedPost(LivingDamageEvent.Post ev) {
        LivingEntity livingEntity = ev.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            Entity entity;
            ServerPlayer pl = (ServerPlayer)livingEntity;
            if (ev.getEntity().getHealth() - ev.getNewDamage() <= 0.0f && ev.getEntity().level().getLevelData().isHardcore()) {
                ReservedItem.handlePlayerDeath((Player)pl);
            }
            if (pl.getHealth() > 0.0f && ev.getSource().is(DamageTypeTags.IS_EXPLOSION) && (entity = ev.getSource().getDirectEntity()) instanceof Creeper) {
                livingEntity = (Creeper)entity;
            }
        }
    }

    private static void onPlayerDamage(LivingIncomingDamageEvent ev) {
        Entity entity = ev.getSource().getEntity();
        if (entity instanceof LivingEntity) {
            ItemStack weapon;
            Item item;
            LivingEntity attacker = (LivingEntity)entity;
            if (DamageUtil.isMeleeDamage(ev.getSource()) && (item = (weapon = attacker.getItemInHand(InteractionHand.MAIN_HAND)).getItem()) instanceof BaseSword) {
                BaseSword baseSword = (BaseSword)item;
                ev.setAmount(baseSword.getDamageForAttack(ev.getEntity(), attacker, weapon, ev.getSource(), ev.getAmount()));
            }
        }
    }

    private static void onPlayerDamagedPre(LivingDamageEvent.Pre ev) {
        ServerPlayer pl;
        LivingEntity livingEntity = ev.getEntity();
        if (livingEntity instanceof ServerPlayer && (pl = (ServerPlayer)livingEntity).getHealth() <= ev.getContainer().getNewDamage()) {
            ServerPlayerDataManager plData = PlayerUtil.getAdventPlayer(pl);
            PositionAndRotation checkpoint = plData.storage.getActiveCheckpoint();
            if (checkpoint != null) {
                if (CheckpointBlock.isValidCheckpoint(pl.level(), checkpoint)) {
                    AoAScheduler.scheduleSyncronisedTask(() -> {
                        if (NowhereEvents.isInBossRegion(pl.blockPosition())) {
                            InventoryUtil.clearItems(pl, new ItemLike[]{AoAItems.RETURN_CRYSTAL});
                            if (EntityRetrievalUtil.getPlayers((Entity)pl, (double)100.0).isEmpty()) {
                                EntityRetrievalUtil.getEntities((Entity)pl, (double)100.0, AoABoss.class).forEach(Entity::discard);
                            }
                        }
                        PlayerUtil.resetToDefaultStatus(pl);
                        pl.sendSystemMessage((Component)LocaleUtil.getLocaleMessage("deathScreen.title", ChatFormatting.DARK_RED, new Component[0]));
                        pl.sendSystemMessage((Component)LocaleUtil.getLocaleMessage(LocaleUtil.createFeedbackLocaleKey("checkpoint.respawn"), ChatFormatting.GREEN, new Component[0]), true);
                        checkpoint.applyToEntity((Entity)pl);
                    }, 1);
                    ev.getContainer().setNewDamage(0.0f);
                    return;
                }
                plData.storage.clearActiveCheckpoint();
                pl.sendSystemMessage((Component)LocaleUtil.getLocaleMessage(LocaleUtil.createFeedbackLocaleKey("checkpoint.invalid"), ChatFormatting.RED, new Component[0]));
            }
            if (ev.getEntity().level().dimension() == AoADimensions.NOWHERE) {
                NowhereEvents.doDeathPrevention(ev, plData);
            }
        }
    }

    private static void onPlayerFall(LivingFallEvent ev) {
        LivingEntity livingEntity = ev.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (ev.getDistance() > 25.0f && ev.getDamageMultiplier() > 0.0f && InventoryUtil.findItemForConsumption((Player)player, AoAItems.BLANK_REALMSTONE, 1, true)) {
                InventoryUtil.giveItemTo(player, AoAItems.LELYETIA_REALMSTONE);
            }
            if (WorldUtil.isWorld(player.level(), AoADimensions.LUNALUS)) {
                LunalusEvents.doPlayerLanding((Player)player, ev);
            }
        }
    }

    private static void onEntityDeath(LivingDeathEvent ev) {
        if (!ev.getEntity().level().isClientSide) {
            if (ev.getEntity() instanceof ServerPlayer) {
                ReservedItem.handlePlayerDeath((Player)((ServerPlayer)ev.getEntity()));
            } else if (ev.getSource().getEntity() instanceof ServerPlayer && WorldUtil.isWorld(ev.getEntity().level(), AoADimensions.DEEPLANDS) && ev.getEntity() instanceof FlyingMob) {
                ev.getEntity().spawnAtLocation(new ItemStack((ItemLike)AoAItems.MUSIC_DISC_CAVERNS.get()), 0.5f);
            }
        }
    }

    private static void onBlockBreak(BlockEvent.BreakEvent ev) {
        Player player = ev.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer pl = (ServerPlayer)player;
            BlockPos pos = ev.getPos();
            if (!pl.getAbilities().instabuild && ev.getState().is(Tags.Blocks.ORES) && pos.getY() <= pl.level().getMinBuildHeight() + 5 && InventoryUtil.findItemForConsumption((Player)pl, AoAItems.BLANK_REALMSTONE, 1, true)) {
                InventoryUtil.giveItemTo(pl, AoAItems.DEEPLANDS_REALMSTONE);
            }
        }
    }

    private static void onBlockPlace(BlockEvent.EntityPlaceEvent ev) {
        Entity entity = ev.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (PlayerUtil.isWearingFullSet((Player)player, AoAArmourMaterials.HYDRANGIC) && ev.getPlacedBlock().getBlock() instanceof CropBlock && BoneMealItem.applyBonemeal((ItemStack)new ItemStack((ItemLike)Items.BONE_MEAL), (Level)ev.getEntity().level(), (BlockPos)ev.getPos(), (Player)player)) {
            ev.getLevel().levelEvent(1505, ev.getPos(), 0);
            player.hurtArmor(player.level().damageSources().generic(), 16.0f);
        }
    }

    private static void onBlockInteract(PlayerInteractEvent.RightClickBlock ev) {
        BlockState state;
        Level level = ev.getLevel();
        if (!level.isClientSide && (state = level.getBlockState(ev.getPos())).getBlock() == Blocks.COMPOSTER && (Integer)state.getValue((Property)ComposterBlock.LEVEL) == 8 && RandomUtil.oneInNChance((int)10)) {
            Vec3 dropPos = Vec3.atLowerCornerWithOffset((Vec3i)ev.getPos(), (double)0.5, (double)1.01, (double)0.5).offsetRandom(level.random, 0.7f);
            ItemEntity greenManureSeeds = new ItemEntity(level, dropPos.x(), dropPos.y(), dropPos.z(), AoAItems.GREEN_MANURE_SEEDS.toStack());
            greenManureSeeds.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)greenManureSeeds);
        }
    }

    private static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent ev) {
        Player player = ev.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (player2.getGameProfile().getId().equals(AdventOfAscension.ENTRANCE_MESSAGE_UUID)) {
                player2.getServer().getPlayerList().broadcastSystemMessage((Component)Text.ofLiteral("It begins...Is this the end?", ChatFormatting.DARK_RED), false);
                player2.serverLevel().sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, player2.getX(), player2.getY() + 0.2, player2.getZ(), 16, (double)RandomUtil.randomValueUpTo((float)0.1f) - 0.05, (double)RandomUtil.randomValueUpTo((float)0.1f) - 0.05, (double)RandomUtil.randomValueUpTo((float)0.1f) - 0.05, 1.0);
            }
            ServerPlayerDataManager plData = PlayerUtil.getAdventPlayer(player2);
            plData.syncNewPlayer();
            AoAWorldEventManager.syncToPlayer(player2);
            PlayerAdvancements plAdvancements = player2.getAdvancements();
            AdvancementUtil.getAdvancement(player2.serverLevel(), AdventOfAscension.id("completionist/root")).ifPresentOrElse(rootAdv -> {
                AdvancementUtil.grantCriterion(player2, AdventOfAscension.id("completionist/by_the_books"), "legitimate");
                plAdvancements.award(rootAdv, "playerjoin");
            }, () -> Logging.logMessage(org.apache.logging.log4j.Level.WARN, "Unable to find inbuilt advancements, another mod is breaking things."));
        }
    }

    private static void onItemToss(ItemTossEvent ev) {
        Player player = ev.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ItemEntity entityItem = ev.getEntity();
            Item item = entityItem.getItem().getItem();
            if (item == AoAItems.BLANK_REALMSTONE.get() && entityItem.getOwner() == player2) {
                if (player2.isEyeInFluidType((FluidType)NeoForgeMod.LAVA_TYPE.value())) {
                    InventoryUtil.giveItemTo(player2, AoAItems.NETHER_REALMSTONE);
                    ev.getEntity().discard();
                }
            } else if (item instanceof ReservedItem) {
                ReservedItem.handlePlayerToss(ev);
            }
        }
    }

    private static void onPlayerPickupXp(PlayerXpEvent.PickupXp ev) {
        if (!ev.getEntity().level().isClientSide && ev.getOrb().value > 0) {
            InventoryUtil.findItem(ev.getEntity(), stack -> stack.getItem() instanceof ExpFlask).map(Pair::right).ifPresent(flask -> {
                ((ExpFlask)flask.getItem()).addCharge((ItemStack)flask, ev.getOrb().value);
                ev.setCanceled(true);
                ev.getOrb().value = 0;
                ev.getOrb().discard();
            });
        }
    }

    private static void onPlayerFishing(ItemFishedEvent ev) {
        if (WorldUtil.isWorld(ev.getEntity().level(), AoADimensions.LBOREAN) && RandomUtil.oneInNChance((int)10)) {
            FishingHook hook = ev.getHookEntity();
            Player fisher = ev.getEntity();
            ItemEntity drop = new ItemEntity(fisher.level(), hook.getX(), hook.getY(), hook.getZ(), new ItemStack((ItemLike)AoAItems.CALL_OF_THE_DRAKE.get()));
            double velocityX = fisher.getX() - hook.getX();
            double velocityY = fisher.getY() - hook.getY();
            double velocityZ = fisher.getZ() - hook.getZ();
            double velocity = Math.sqrt(velocityX * velocityX + velocityY * velocityY + velocityZ * velocityZ);
            drop.setDeltaMovement(velocityX * 0.1, velocityY * 0.1 + Math.sqrt(velocity) * 0.08, velocityZ * 0.1);
            fisher.level().addFreshEntity((Entity)drop);
        }
    }

    private static void onDimensionChange(PlayerEvent.PlayerChangedDimensionEvent ev) {
        Player player;
        if (ev.getFrom() == AoADimensions.NOWHERE || ev.getTo() == AoADimensions.NOWHERE) {
            NowhereEvents.doDimensionChange(ev);
        }
        if ((player = ev.getEntity()) instanceof ServerPlayer) {
            ServerPlayer pl = (ServerPlayer)player;
            PlayerUtil.getAdventPlayer((ServerPlayer)pl).storage.clearActiveCheckpoint();
            AoAWorldEventManager.syncToPlayer(pl);
        }
    }
}

