/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.event;

import java.util.concurrent.TimeUnit;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.level.ModifyCustomSpawnersEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.tslat.aoa3.advent.AoAResourceCaching;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.content.world.event.AoAWorldEventManager;
import net.tslat.aoa3.content.world.spawner.AoACustomSpawner;
import net.tslat.aoa3.scheduling.AoAScheduler;
import net.tslat.aoa3.scheduling.async.UpdateHalosMapTask;

public final class GlobalEvents {
    public static int tick;

    public static void preInit() {
        IEventBus forgeBus = NeoForge.EVENT_BUS;
        forgeBus.addListener(EventPriority.NORMAL, false, ServerTickEvent.Post.class, GlobalEvents::serverTick);
        forgeBus.addListener(EventPriority.NORMAL, false, ModifyCustomSpawnersEvent.class, GlobalEvents::addCustomSpawners);
        forgeBus.addListener(EventPriority.NORMAL, false, LevelEvent.Load.class, GlobalEvents::levelLoad);
        forgeBus.addListener(EventPriority.NORMAL, false, LevelTickEvent.Pre.class, GlobalEvents::levelTick);
        forgeBus.addListener(EventPriority.NORMAL, false, ServerStartingEvent.class, GlobalEvents::serverStarting);
        forgeBus.addListener(EventPriority.NORMAL, false, ServerStartedEvent.class, GlobalEvents::serverStarted);
        forgeBus.addListener(EventPriority.NORMAL, false, ServerStoppingEvent.class, GlobalEvents::serverStopping);
        forgeBus.addListener(EventPriority.NORMAL, false, TagsUpdatedEvent.class, GlobalEvents::datapackUpdate);
    }

    private static void serverTick(ServerTickEvent.Post ev) {
        AoAScheduler.handleSyncScheduledTasks(++tick);
    }

    private static void addCustomSpawners(ModifyCustomSpawnersEvent ev) {
        ev.getLevel().getServer().registryAccess().registryOrThrow(AoARegistries.CUSTOM_SPAWNERS_REGISTRY_KEY).stream().filter(spawner -> spawner.shouldAddToDimension(ev.getLevel())).map(AoACustomSpawner::copy).forEach(arg_0 -> ((ModifyCustomSpawnersEvent)ev).addCustomSpawner(arg_0));
    }

    private static void levelLoad(LevelEvent.Load ev) {
        LevelAccessor levelAccessor = ev.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            AoAWorldEventManager.load(level);
        }
    }

    private static void levelTick(LevelTickEvent.Pre ev) {
        AoAWorldEventManager.tick(ev.getLevel());
    }

    private static void serverStarting(ServerStartingEvent ev) {
        AoAScheduler.scheduleAsyncTask(new UpdateHalosMapTask(), 1, TimeUnit.SECONDS);
        AoAScheduler.serverStartupTasks();
    }

    private static void serverStarted(ServerStartedEvent ev) {
    }

    private static void serverStopping(ServerStoppingEvent ev) {
        AoAScheduler.serverShutdownTasks();
    }

    private static void datapackUpdate(TagsUpdatedEvent ev) {
        if (ev.shouldUpdateStaticData()) {
            AoAResourceCaching.datapackReload(ev.getRegistryAccess());
        }
    }
}

