/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.event;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.ArmorHurtEvent;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import net.neoforged.neoforge.event.entity.living.MobSplitEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;
import net.tslat.aoa3.common.registration.AoAConfigs;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.common.registration.worldgen.AoADimensions;
import net.tslat.aoa3.scheduling.AoAScheduler;
import net.tslat.aoa3.util.InventoryUtil;
import net.tslat.aoa3.util.WorldUtil;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;

public final class EntityEvents {
    public static final String SPAWNED_BY_SPAWNER_TAG = "spawned_by_spawner";

    public static void preInit() {
        IEventBus forgeBus = NeoForge.EVENT_BUS;
        forgeBus.addListener(EventPriority.NORMAL, false, EntityJoinLevelEvent.class, EntityEvents::onEntityJoinWorld);
        forgeBus.addListener(EventPriority.LOWEST, false, FinalizeSpawnEvent.class, EntityEvents::onEntitySpawn);
        forgeBus.addListener(EventPriority.LOWEST, false, MobSplitEvent.class, EntityEvents::onEntitySplit);
        forgeBus.addListener(EventPriority.LOWEST, false, ArmorHurtEvent.class, EntityEvents::onArmourDamage);
        forgeBus.addListener(EventPriority.NORMAL, false, ExplosionEvent.Detonate.class, EntityEvents::onEntityExploded);
        forgeBus.addListener(EventPriority.NORMAL, false, PlayerInteractEvent.EntityInteractSpecific.class, EntityEvents::onEntityInteract);
    }

    private static void onEntityInteract(PlayerInteractEvent.EntityInteractSpecific ev) {
        ItemStack stack;
        Piglin piglin;
        Entity entity;
        if (!ev.getEntity().level().isClientSide && (entity = ev.getTarget()) instanceof Piglin && (piglin = (Piglin)entity).getItemBySlot(EquipmentSlot.HEAD).getItem() == Items.GOLDEN_HELMET && ((stack = ev.getEntity().getItemInHand(ev.getHand())).getItem() == Items.ENCHANTED_GOLDEN_APPLE || stack.getItem() == AoAItems.GOLD_COIN.get()) && piglin.getOffhandItem().isEmpty()) {
            piglin.addTag("BarteringForExplosiveIdol");
            piglin.setItemSlot(EquipmentSlot.OFFHAND, stack.split(1));
            piglin.setGuaranteedDrop(EquipmentSlot.OFFHAND);
            piglin.getBrain().setMemoryWithExpiry(MemoryModuleType.ADMIRING_ITEM, (Object)true, 121L);
            piglin.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
            piglin.getNavigation().stop();
            AoAScheduler.scheduleSyncronisedTask(() -> {
                ItemStack offHandItem;
                if (piglin != null && piglin.isAlive() && piglin.getHealth() >= piglin.getMaxHealth() && ((offHandItem = piglin.getItemInHand(InteractionHand.OFF_HAND)).getItem() == Items.ENCHANTED_GOLDEN_APPLE || offHandItem.getItem() == AoAItems.GOLD_COIN.get())) {
                    piglin.setItemInHand(InteractionHand.OFF_HAND, Items.GOLD_INGOT.getDefaultInstance());
                    piglin.getBrain().eraseMemory(MemoryModuleType.ADMIRING_ITEM);
                }
            }, 120);
        }
    }

    private static void onEntityJoinWorld(EntityJoinLevelEvent ev) {
        if (!ev.getLevel().isClientSide && WorldUtil.isWorld(ev.getLevel(), AoADimensions.NETHER) && ev.getEntity() instanceof WitherBoss && ((WitherBoss)ev.getEntity()).getInvulnerableTicks() == 220) {
            for (Player pl : EntityRetrievalUtil.getPlayers((Level)ev.getLevel(), (AABB)ev.getEntity().getBoundingBox().inflate(50.0))) {
                if (!InventoryUtil.findItemForConsumption(pl, AoAItems.BLANK_REALMSTONE, pl.getAbilities().instabuild ? 0 : 1, true)) continue;
                InventoryUtil.giveItemTo((ServerPlayer)pl, AoAItems.ABYSS_REALMSTONE);
            }
        }
    }

    private static void onArmourDamage(ArmorHurtEvent ev) {
    }

    private static void onEntitySpawn(FinalizeSpawnEvent ev) {
        if (ev.getSpawnType() == MobSpawnType.SPAWNER || ev.getSpawnType() == MobSpawnType.TRIAL_SPAWNER) {
            ev.getEntity().getPersistentData().putBoolean(SPAWNED_BY_SPAWNER_TAG, true);
        }
    }

    private static void onEntitySplit(MobSplitEvent ev) {
        if (ev.getParent().getPersistentData().contains(SPAWNED_BY_SPAWNER_TAG, 1)) {
            ev.getChildren().forEach(mob -> mob.getPersistentData().putBoolean(SPAWNED_BY_SPAWNER_TAG, true));
        }
    }

    private static void onEntityExploded(ExplosionEvent.Detonate ev) {
        if (((Boolean)AoAConfigs.SERVER.saveLootFromExplosions.get()).booleanValue()) {
            ev.getAffectedEntities().removeIf(entity -> entity instanceof ItemEntity && entity.tickCount < 40);
        }
    }
}

