/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.data.server;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIntPair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.player.PlayerDataManager;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.aoa3.util.RegistryUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AoASkillReqReloadListener
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String folder = "player/skill_reqs";
    private static final HashMap<ResourceLocation, SkillReqHandler> REQUIREMENTS_MAP = new HashMap();
    private static Map<ResourceLocation, Map<String, List<ObjectIntPair<ResourceLocation>>>> requirementsData = new HashMap<ResourceLocation, Map<String, List<ObjectIntPair<ResourceLocation>>>>();

    public AoASkillReqReloadListener() {
        super(GSON, folder);
    }

    public static boolean canEquip(PlayerDataManager plData, Item item, boolean notifyPlayer) {
        SkillReqHandler handler = AoASkillReqReloadListener.getRequirements(RegistryUtil.getId(item));
        if (handler != null && !handler.canEquip(plData)) {
            Player player;
            if (notifyPlayer && (player = plData.getPlayer()) instanceof ServerPlayer) {
                ServerPlayer pl = (ServerPlayer)player;
                handler.notifyPlayerCantEquip(pl);
            }
            return false;
        }
        return true;
    }

    public static boolean canPlaceBlock(PlayerDataManager plData, Block block, boolean notifyPlayer) {
        SkillReqHandler handler = AoASkillReqReloadListener.getRequirements(RegistryUtil.getId(block));
        if (handler != null && !handler.canPlaceBlock(plData)) {
            Player player;
            if (notifyPlayer && (player = plData.getPlayer()) instanceof ServerPlayer) {
                ServerPlayer pl = (ServerPlayer)player;
                handler.notifyPlayerCantPlaceBlock(pl);
            }
            return false;
        }
        return true;
    }

    public static boolean canBreakBlock(PlayerDataManager plData, Block block, boolean notifyPlayer) {
        SkillReqHandler handler = AoASkillReqReloadListener.getRequirements(RegistryUtil.getId(block));
        if (handler != null && !handler.canBreakBlock(plData)) {
            Player player;
            if (notifyPlayer && (player = plData.getPlayer()) instanceof ServerPlayer) {
                ServerPlayer pl = (ServerPlayer)player;
                handler.notifyPlayerCantBreakBlock(pl);
            }
            return false;
        }
        return true;
    }

    public static boolean canInteractWith(PlayerDataManager plData, Block block, boolean notifyPlayer) {
        SkillReqHandler handler = AoASkillReqReloadListener.getRequirements(RegistryUtil.getId(block));
        if (handler != null && !handler.canInteractWith(plData)) {
            Player player;
            if (notifyPlayer && (player = plData.getPlayer()) instanceof ServerPlayer) {
                ServerPlayer pl = (ServerPlayer)player;
                handler.notifyPlayerCantInteract(pl);
            }
            return false;
        }
        return true;
    }

    @Nullable
    public static SkillReqHandler getRequirements(ResourceLocation id) {
        return REQUIREMENTS_MAP.get(id);
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsonMap, ResourceManager resourceManager, ProfilerFiller profiler) {
        REQUIREMENTS_MAP.clear();
        AoASkillReqReloadListener.parseAll(this.prepData(jsonMap));
    }

    public static void parseAll(Map<ResourceLocation, Map<String, List<ObjectIntPair<ResourceLocation>>>> restrictions) {
        requirementsData = new Object2ObjectOpenHashMap(restrictions);
        for (Map.Entry<ResourceLocation, Map<String, List<ObjectIntPair<ResourceLocation>>>> entry : requirementsData.entrySet()) {
            SkillReqHandler handler = AoASkillReqReloadListener.parse(entry.getValue());
            if (handler.isValid()) {
                REQUIREMENTS_MAP.put(entry.getKey(), handler);
                continue;
            }
            REQUIREMENTS_MAP.remove(entry.getKey());
        }
    }

    public static SkillReqHandler parse(Map<String, List<ObjectIntPair<ResourceLocation>>> reqData) {
        SkillReqHandler handler = new SkillReqHandler();
        if (reqData.containsKey("equip")) {
            handler.forEquipping(AoASkillReqReloadListener.parseRequirements(reqData.get("equip")));
        }
        if (reqData.containsKey("place_block")) {
            handler.forPlacingBlocks(AoASkillReqReloadListener.parseRequirements(reqData.get("place_block")));
        }
        if (reqData.containsKey("break_block")) {
            handler.forBreakingBlocks(AoASkillReqReloadListener.parseRequirements(reqData.get("break_block")));
        }
        if (reqData.containsKey("interact_with")) {
            handler.forInteracting(AoASkillReqReloadListener.parseRequirements(reqData.get("interact_with")));
        }
        return handler;
    }

    private static Pair<Predicate<PlayerDataManager>, Consumer<ServerPlayer>> parseRequirements(List<ObjectIntPair<ResourceLocation>> reqs) {
        Predicate<PlayerDataManager> predicate = plData -> true;
        Consumer<ServerPlayer> notificationHandler = plData -> {};
        for (ObjectIntPair<ResourceLocation> pair : reqs) {
            AoASkill skill = AoASkills.getSkill((ResourceLocation)pair.first());
            int level = pair.valueInt();
            if (level <= 0 || level > 1000) {
                throw new IllegalArgumentException("Invalid skill level requirement: " + level + ", must be 1-1000");
            }
            if (skill == null) {
                throw new IllegalArgumentException("Unknown skill: '" + String.valueOf(pair.first()) + "' for item skill entry.");
            }
            predicate = predicate.and(plData -> plData.getSkill(skill).hasLevel(level));
            notificationHandler = notificationHandler.andThen(player -> PlayerUtil.notifyPlayerOfInsufficientLevel(player, skill, level));
        }
        return Pair.of(predicate, notificationHandler);
    }

    private Map<ResourceLocation, Map<String, List<ObjectIntPair<ResourceLocation>>>> prepData(Map<ResourceLocation, JsonElement> jsonData) {
        HashMap<ResourceLocation, Map<String, List<ObjectIntPair<ResourceLocation>>>> idToReqsMap = new HashMap<ResourceLocation, Map<String, List<ObjectIntPair<ResourceLocation>>>>(jsonData.size());
        for (Map.Entry<ResourceLocation, JsonElement> jsonFile : jsonData.entrySet()) {
            List<ResourceLocation> targetIds;
            JsonObject json = jsonFile.getValue().getAsJsonObject();
            JsonElement target = json.get("target");
            if (target.isJsonPrimitive()) {
                targetIds = List.of((ResourceLocation)ResourceLocation.read((String)target.getAsString()).getOrThrow());
            } else if (target.isJsonArray()) {
                JsonArray array = target.getAsJsonArray();
                targetIds = new ArrayList<ResourceLocation>();
                for (JsonElement element : array) {
                    targetIds.add((ResourceLocation)ResourceLocation.read((String)element.getAsString()).getOrThrow());
                }
            } else {
                throw new IllegalArgumentException("Unknown entry type for 'target' in AoA Skill Req json: " + String.valueOf(jsonFile.getKey()));
            }
            HashMap<String, List<ObjectIntPair<ResourceLocation>>> reqMap = new HashMap<String, List<ObjectIntPair<ResourceLocation>>>();
            for (Map.Entry reqEntry : json.entrySet()) {
                if (((String)reqEntry.getKey()).equals("target")) continue;
                ArrayList<ObjectIntPair> reqList = new ArrayList<ObjectIntPair>();
                JsonElement element = (JsonElement)reqEntry.getValue();
                if (element.isJsonObject()) {
                    JsonObject reqEntryObj = element.getAsJsonObject();
                    reqList.add(ObjectIntPair.of((Object)((ResourceLocation)ResourceLocation.read((String)GsonHelper.getAsString((JsonObject)reqEntryObj, (String)"skill")).getOrThrow()), (int)GsonHelper.getAsInt((JsonObject)reqEntryObj, (String)"level")));
                } else if (element.isJsonArray() && !element.getAsJsonArray().isEmpty()) {
                    for (JsonElement ele2 : element.getAsJsonArray()) {
                        JsonObject reqEntryObj = ele2.getAsJsonObject();
                        reqList.add(ObjectIntPair.of((Object)((ResourceLocation)ResourceLocation.read((String)GsonHelper.getAsString((JsonObject)reqEntryObj, (String)"skill")).getOrThrow()), (int)GsonHelper.getAsInt((JsonObject)reqEntryObj, (String)"level")));
                    }
                }
                reqMap.put((String)reqEntry.getKey(), reqList);
            }
            for (ResourceLocation id : targetIds) {
                AoASkillReqReloadListener.mergeOrAddEntry(id, reqMap, idToReqsMap);
            }
        }
        return idToReqsMap;
    }

    private static void mergeOrAddEntry(ResourceLocation id, Map<String, List<ObjectIntPair<ResourceLocation>>> newReqs, Map<ResourceLocation, Map<String, List<ObjectIntPair<ResourceLocation>>>> reqMap) {
        Map<String, List<ObjectIntPair<ResourceLocation>>> existingReqsMap = reqMap.putIfAbsent(id, newReqs);
        if (existingReqsMap == null) {
            return;
        }
        for (Map.Entry<String, List<ObjectIntPair<ResourceLocation>>> newReqEntry : newReqs.entrySet()) {
            List<ObjectIntPair<ResourceLocation>> newReqsList;
            String reqType = newReqEntry.getKey();
            List<ObjectIntPair<ResourceLocation>> existingReqsList = existingReqsMap.putIfAbsent(reqType, newReqsList = newReqEntry.getValue());
            if (existingReqsList == null) continue;
            for (ObjectIntPair<ResourceLocation> newReq : newReqsList) {
                int index = -1;
                for (int i = 0; i < existingReqsList.size(); ++i) {
                    ObjectIntPair<ResourceLocation> oldReq = existingReqsList.get(i);
                    if (!((ResourceLocation)oldReq.first()).equals(newReq.first())) continue;
                    if (oldReq.valueInt() >= newReq.valueInt()) break;
                    index = i;
                    break;
                }
                if (index < 0) continue;
                existingReqsList.set(index, newReq);
            }
        }
    }

    public static void setRequirements(ResourceLocation id, SkillReqHandler handler) {
        REQUIREMENTS_MAP.put(id, handler);
    }

    public static void addRequirements(ResourceLocation id, Map<String, List<ObjectIntPair<ResourceLocation>>> data) {
        AoASkillReqReloadListener.mergeOrAddEntry(id, data, requirementsData);
        AoASkillReqReloadListener.setRequirements(id, AoASkillReqReloadListener.parse(AoASkillReqReloadListener.getParsedReqDataFor(id)));
    }

    public static Map<ResourceLocation, Map<String, List<ObjectIntPair<ResourceLocation>>>> getParsedReqData() {
        return requirementsData;
    }

    @NotNull
    public static Map<String, List<ObjectIntPair<ResourceLocation>>> getParsedReqDataFor(ResourceLocation itemId) {
        if (!requirementsData.containsKey(itemId)) {
            return new HashMap<String, List<ObjectIntPair<ResourceLocation>>>(0);
        }
        return requirementsData.get(itemId);
    }

    public static class SkillReqHandler {
        @Nullable
        private Pair<Predicate<PlayerDataManager>, Consumer<ServerPlayer>> equipPredicate;
        @Nullable
        private Pair<Predicate<PlayerDataManager>, Consumer<ServerPlayer>> blockPlacePredicate;
        @Nullable
        private Pair<Predicate<PlayerDataManager>, Consumer<ServerPlayer>> blockBreakPredicate;
        @Nullable
        private Pair<Predicate<PlayerDataManager>, Consumer<ServerPlayer>> interactionPredicate;

        private void forEquipping(Pair<Predicate<PlayerDataManager>, Consumer<ServerPlayer>> equipPredicate) {
            this.equipPredicate = equipPredicate;
        }

        private void forPlacingBlocks(Pair<Predicate<PlayerDataManager>, Consumer<ServerPlayer>> blockPlacePredicate) {
            this.blockPlacePredicate = blockPlacePredicate;
        }

        private void forBreakingBlocks(Pair<Predicate<PlayerDataManager>, Consumer<ServerPlayer>> blockBreakPredicate) {
            this.blockBreakPredicate = blockBreakPredicate;
        }

        private void forInteracting(Pair<Predicate<PlayerDataManager>, Consumer<ServerPlayer>> interactionPredicate) {
            this.interactionPredicate = interactionPredicate;
        }

        public boolean handlingEquip() {
            return this.equipPredicate != null;
        }

        public boolean handlingBlockPlacement() {
            return this.blockPlacePredicate != null;
        }

        public boolean handlingBlockBreak() {
            return this.blockBreakPredicate != null;
        }

        public boolean handlingInteraction() {
            return this.interactionPredicate != null;
        }

        public boolean canEquip(PlayerDataManager plData) {
            return !this.handlingEquip() || ((Predicate)this.equipPredicate.getFirst()).test(plData);
        }

        public void notifyPlayerCantEquip(ServerPlayer player) {
            if (this.handlingEquip()) {
                ((Consumer)this.equipPredicate.getSecond()).accept(player);
            }
        }

        public boolean canPlaceBlock(PlayerDataManager plData) {
            return !this.handlingBlockPlacement() || ((Predicate)this.blockPlacePredicate.getFirst()).test(plData);
        }

        public void notifyPlayerCantPlaceBlock(ServerPlayer player) {
            if (this.handlingBlockPlacement()) {
                ((Consumer)this.blockPlacePredicate.getSecond()).accept(player);
            }
        }

        public boolean canBreakBlock(PlayerDataManager plData) {
            return !this.handlingBlockBreak() || ((Predicate)this.blockBreakPredicate.getFirst()).test(plData);
        }

        public void notifyPlayerCantBreakBlock(ServerPlayer player) {
            if (this.handlingBlockBreak()) {
                ((Consumer)this.blockBreakPredicate.getSecond()).accept(player);
            }
        }

        public boolean canInteractWith(PlayerDataManager plData) {
            return !this.handlingInteraction() || ((Predicate)this.interactionPredicate.getFirst()).test(plData);
        }

        public void notifyPlayerCantInteract(ServerPlayer player) {
            if (this.handlingInteraction()) {
                ((Consumer)this.interactionPredicate.getSecond()).accept(player);
            }
        }

        public boolean isValid() {
            return this.handlingEquip() || this.handlingBlockPlacement() || this.handlingBlockBreak() || this.handlingInteraction();
        }
    }
}

